/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.math;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MapN<K, V>
extends AbstractMap<K, V> {
    final Object[] table;
    final int size;

    MapN(Object ... input) {
        if ((input.length & 1) != 0) {
            throw new InternalError("length is odd");
        }
        this.size = input.length >> 1;
        int len = 2 * input.length;
        len = len + 1 & 0xFFFFFFFE;
        this.table = new Object[len];
        for (int i = 0; i < input.length; i += 2) {
            Object k = Objects.requireNonNull(input[i]);
            Object v = Objects.requireNonNull(input[i + 1]);
            int idx = this.probe(k);
            if (idx >= 0) {
                throw new IllegalArgumentException("duplicate key: " + k);
            }
            int dest = -(idx + 1);
            this.table[dest] = k;
            this.table[dest + 1] = v;
        }
    }

    private int probe(Object pk) {
        int idx = Math.floorMod(pk.hashCode(), this.table.length >> 1) << 1;
        Object ek;
        while ((ek = this.table[idx]) != null) {
            if (pk.equals(ek)) {
                return idx;
            }
            if ((idx += 2) != this.table.length) continue;
            idx = 0;
        }
        return -idx - 1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (int i = 0; i < this.table.length; i += 2) {
            Object k = this.table[i];
            if (k == null) continue;
            Object v = this.table[i + 1];
            entries.add(new AbstractMap.SimpleEntry<Object, Object>(k, v));
        }
        return entries;
    }
}

