/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.math;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class RegistryMultiMap<K, V>
implements Multimap<K, V> {
    private final FastMap<K, LinkedHashSet<V>> internal = new FastMap();
    private int totalSize = 0;

    public RegistryMultiMap() {
    }

    public RegistryMultiMap(Multimap<K, V> multimap) {
        this.putAll(multimap);
    }

    public RegistryMultiMap(Collection<Map.Entry<K, V>> entries) {
        for (Map.Entry<K, V> entry : entries) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public int size() {
        return this.totalSize;
    }

    public boolean isEmpty() {
        return this.totalSize == 0;
    }

    public boolean containsKey(Object key) {
        return this.internal.containsKey(key);
    }

    public boolean containsValue(Object value) {
        if (value == null || this.isEmpty()) {
            return false;
        }
        for (Set set : this.internal.values()) {
            if (!set.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsEntry(Object key, Object value) {
        Set values = this.internal.get(key);
        return values != null && values.contains(value);
    }

    public boolean put(K key, V value) {
        Set values = this.internal.computeIfAbsent(key, k -> new LinkedHashSet());
        if (values.add(value)) {
            ++this.totalSize;
            return true;
        }
        return false;
    }

    public boolean remove(Object key, Object value) {
        Set values = this.internal.get(key);
        if (values != null && values.remove(value)) {
            --this.totalSize;
            if (values.isEmpty()) {
                this.internal.remove(key);
            }
            return true;
        }
        return false;
    }

    public boolean putAll(K key, Iterable<? extends V> values) {
        boolean changed = false;
        for (V value : values) {
            changed |= this.put(key, value);
        }
        return changed;
    }

    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean changed = false;
        for (Map.Entry entry : multimap.entries()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    public boolean putAll(Collection<Map.Entry<K, V>> entries) {
        boolean changed = false;
        for (Map.Entry<K, V> entry : entries) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    public Set<V> replaceValues(K key, Iterable<? extends V> values) {
        LinkedHashSet<V> oldValues = this.internal.get(key);
        if (oldValues == null) {
            oldValues = new LinkedHashSet<V>();
        } else {
            this.totalSize -= oldValues.size();
            oldValues.clear();
        }
        for (V value : values) {
            oldValues.add(value);
            ++this.totalSize;
        }
        this.internal.put((Object)key, (Object)oldValues);
        return oldValues;
    }

    public Set<V> removeAll(Object key) {
        Set removed = this.internal.remove(key);
        if (removed != null) {
            this.totalSize -= removed.size();
        }
        return removed != null ? removed : new LinkedHashSet();
    }

    public void clear() {
        this.internal.clear();
        this.totalSize = 0;
    }

    public LinkedHashSet<V> get(K key) {
        LinkedHashSet values = CSMath.orElse(this.internal.get(key), new LinkedHashSet());
        LinkedHashSet<V> nullValues = this.internal.get(null);
        if (nullValues != null) {
            values.addAll(nullValues);
        }
        return values;
    }

    public LinkedHashSet<V> getRaw(K key) {
        return CSMath.orElse(this.internal.get(key), new LinkedHashSet());
    }

    public Set<K> keySet() {
        return this.internal.keySet();
    }

    public Multiset<K> keys() {
        HashMultiset keys = HashMultiset.create();
        for (Map.Entry<K, LinkedHashSet<V>> entry : this.internal.entrySet()) {
            keys.add(entry.getKey(), entry.getValue().size());
        }
        return keys;
    }

    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<LinkedHashSet<V>> setIterator;
                    private Iterator<V> currentIterator;
                    {
                        this.setIterator = RegistryMultiMap.this.internal.values().iterator();
                        this.currentIterator = Collections.emptyIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (!this.currentIterator.hasNext() && this.setIterator.hasNext()) {
                            this.currentIterator = this.setIterator.next().iterator();
                        }
                        return this.currentIterator.hasNext();
                    }

                    @Override
                    public V next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return this.currentIterator.next();
                    }

                    @Override
                    public void remove() {
                        this.currentIterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return RegistryMultiMap.this.totalSize;
            }
        };
    }

    public Collection<Map.Entry<K, V>> entries() {
        return new AbstractCollection<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, LinkedHashSet<V>>> entryIterator;
                    private Map.Entry<K, LinkedHashSet<V>> currentEntry;
                    private Iterator<V> valueIterator;
                    {
                        this.entryIterator = RegistryMultiMap.this.internal.entrySet().iterator();
                        this.valueIterator = Collections.emptyIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (!this.valueIterator.hasNext() && this.entryIterator.hasNext()) {
                            this.currentEntry = this.entryIterator.next();
                            this.valueIterator = this.currentEntry.getValue().iterator();
                        }
                        return this.valueIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new AbstractMap.SimpleEntry(this.currentEntry.getKey(), this.valueIterator.next());
                    }

                    @Override
                    public void remove() {
                        this.valueIterator.remove();
                        if (this.currentEntry.getValue().isEmpty()) {
                            this.entryIterator.remove();
                        }
                    }
                };
            }

            @Override
            public int size() {
                return RegistryMultiMap.this.totalSize;
            }
        };
    }

    public FastMap<K, Collection<V>> asMap() {
        FastMap<K, LinkedHashSet<V>> map = new FastMap<K, LinkedHashSet<V>>(this.internal.size());
        map.putAll(this.internal);
        return map;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Multimap) {
            Multimap other = (Multimap)obj;
            return this.internal.equals(other.asMap());
        }
        return false;
    }

    public String toString() {
        return this.internal.toString();
    }
}

