/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.math.FastMultiMap;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.util.TriConsumer;

public class ConfigHelper {
    private ConfigHelper() {
    }

    public static <T> List<T> parseRegistryItems(RegistryKey<Registry<T>> registry, DynamicRegistries registryAccess, String objects) {
        return ConfigHelper.parseRegistryItems(registry, registryAccess, objects.split(","));
    }

    public static <T> List<T> parseRegistryItems(RegistryKey<Registry<T>> registry, DynamicRegistries registryAccess, String[] objects) {
        ArrayList registryList = new ArrayList();
        MutableRegistry reg = registryAccess.func_243612_b(registry);
        for (String objString : objects) {
            ResourceLocation id = new ResourceLocation(objString);
            Optional obj = reg.func_241873_b(id);
            if (!obj.isPresent()) {
                ColdSweat.LOGGER.error("Error parsing config: \"{}\" does not exist", (Object)objString);
                continue;
            }
            registryList.add(obj.get());
        }
        return registryList;
    }

    public static <T> List<Either<ITag<T>, T>> parseTaggableRegistryItems(RegistryKey<Registry<T>> registry, DynamicRegistries registryAccess, String objects) {
        return ConfigHelper.parseTaggableRegistryItems(registry, registryAccess, objects.split(","));
    }

    public static <T> List<Either<ITag<T>, T>> parseTaggableRegistryItems(RegistryKey<Registry<T>> registry, DynamicRegistries registryAccess, String[] objects) {
        ArrayList<Either<ITag<T>, T>> registryList = new ArrayList<Either<ITag<T>, T>>();
        MutableRegistry reg = registryAccess.func_243612_b(registry);
        for (String objString : objects) {
            if (objString.startsWith("#")) {
                ITagCollection<T> tags = ConfigHelper.getTagsForRegistry(registry);
                if (tags == null) continue;
                String tagID = objString.replace("#", "");
                registryList.add(Either.left((Object)ConfigHelper.getTagsForRegistry(registry).func_199910_a(new ResourceLocation(tagID))));
                continue;
            }
            ResourceLocation id = new ResourceLocation(objString);
            Optional obj = reg.func_241873_b(id);
            if (!reg.func_212607_c(id) || !obj.isPresent()) {
                ColdSweat.LOGGER.error("Error parsing config: {} \"{}\" does not exist", (Object)registry.func_240901_a_().func_110623_a(), (Object)objString);
                continue;
            }
            registryList.add(Either.right(obj.get()));
        }
        return registryList;
    }

    public static <T> ITagCollection<T> getTagsForRegistry(RegistryKey<Registry<T>> registry) {
        if (registry.equals((Object)Registry.field_239714_o_)) {
            return ItemTags.func_199903_a();
        }
        if (registry.equals((Object)Registry.field_239711_l_)) {
            return BlockTags.func_199896_a();
        }
        if (registry.equals((Object)Registry.field_239709_j_)) {
            return FluidTags.func_226157_a_();
        }
        if (registry.equals((Object)Registry.field_239713_n_)) {
            return EntityTypeTags.func_219762_a();
        }
        return null;
    }

    public static <T> ITagCollection<T> getTagsForObject(T object) {
        if (object instanceof Item) {
            return ItemTags.func_199903_a();
        }
        if (object instanceof Block) {
            return BlockTags.func_199896_a();
        }
        if (object instanceof Fluid) {
            return FluidTags.func_226157_a_();
        }
        if (object instanceof EntityType) {
            return EntityTypeTags.func_219762_a();
        }
        return null;
    }

    public static <T extends IForgeRegistryEntry<T>> List<Either<ITag<T>, T>> parseBuiltinItems(RegistryKey<Registry<T>> registryKey, IForgeRegistry<T> registry, String objects) {
        return ConfigHelper.parseBuiltinItems(registryKey, registry, objects.split(","));
    }

    public static <T extends IForgeRegistryEntry<T>> List<Either<ITag<T>, T>> parseBuiltinItems(RegistryKey<Registry<T>> registryKey, IForgeRegistry<T> registry, String[] objects) {
        ArrayList<Either<ITag<T>, T>> registryList = new ArrayList<Either<ITag<T>, T>>();
        for (String objString : objects) {
            if (objString.startsWith("#")) {
                String tagID = objString.replace("#", "");
                registryList.add(Either.left((Object)ConfigHelper.getTagsForRegistry(registryKey).func_199910_a(new ResourceLocation(tagID))));
                continue;
            }
            ResourceLocation id = new ResourceLocation(objString);
            if (!registry.containsKey(id)) {
                ColdSweat.LOGGER.error("Error parsing config: {} \"{}\" does not exist", (Object)registryKey.func_240901_a_().func_110623_a(), (Object)objString);
                continue;
            }
            IForgeRegistryEntry obj = registry.getValue(id);
            registryList.add(Either.right((Object)obj));
        }
        return registryList;
    }

    public static List<Either<ITag<Block>, Block>> getBlocks(String blocks) {
        return ConfigHelper.getBlocks(blocks.split(","));
    }

    public static List<Either<ITag<Block>, Block>> getBlocks(String[] blocks) {
        return ConfigHelper.parseBuiltinItems(Registry.field_239711_l_, ForgeRegistries.BLOCKS, blocks);
    }

    public static List<Either<ITag<Item>, Item>> getItems(String items) {
        return ConfigHelper.getItems(items.split(","));
    }

    public static List<Either<ITag<Item>, Item>> getItems(String[] items) {
        return ConfigHelper.parseBuiltinItems(Registry.field_239714_o_, ForgeRegistries.ITEMS, items);
    }

    public static List<Either<ITag<EntityType<?>>, EntityType<?>>> getEntityTypes(String entities) {
        return ConfigHelper.getEntityTypes(entities.split(","));
    }

    public static List<Either<ITag<EntityType<?>>, EntityType<?>>> getEntityTypes(String[] entities) {
        return ConfigHelper.parseBuiltinItems(Registry.field_239713_n_, ForgeRegistries.ENTITIES, entities);
    }

    public static <K, V extends ConfigData> Map<K, V> getRegistryMap(List<? extends List<?>> source, DynamicRegistries dynamicRegistries, RegistryKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, List<Either<ITag<K>, K>>> taggedListGetter) {
        return ConfigHelper.getRegistryMapLike(source, dynamicRegistries, keyRegistry, valueCreator, taggedListGetter, FastMap::new, FastMap::put);
    }

    public static <K, V extends ConfigData> Map<K, V> getRegistryMap(List<? extends List<?>> source, RegistryKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, List<K>> taggedListGetter) {
        return ConfigHelper.getRegistryMapLike(source, null, keyRegistry, valueCreator, v -> ((List)taggedListGetter.apply(v)).stream().map(Either::right).collect(Collectors.toList()), FastMap::new, FastMap::put);
    }

    public static <K, V extends ConfigData> Multimap<K, V> getRegistryMultimap(List<? extends List<?>> source, DynamicRegistries dynamicRegistries, RegistryKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, List<Either<ITag<K>, K>>> taggedListGetter) {
        return ConfigHelper.getRegistryMapLike(source, dynamicRegistries, keyRegistry, valueCreator, taggedListGetter, FastMultiMap::new, FastMultiMap::put);
    }

    public static <K, V extends ConfigData> Multimap<K, V> getRegistryMultimap(List<? extends List<?>> source, RegistryKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, List<K>> taggedListGetter) {
        return ConfigHelper.getRegistryMapLike(source, null, keyRegistry, valueCreator, v -> ((List)taggedListGetter.apply(v)).stream().map(Either::right).collect(Collectors.toList()), FastMultiMap::new, FastMultiMap::put);
    }

    private static <K, V extends ConfigData, M> M getRegistryMapLike(List<? extends List<?>> source, DynamicRegistries dynamicRegistries, RegistryKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, List<Either<ITag<K>, K>>> listGetter, Supplier<M> mapSupplier, TriConsumer<M, K, V> mapAdder) {
        M map = mapSupplier.get();
        for (List<?> entry : source) {
            ConfigData data = (ConfigData)valueCreator.apply(entry);
            if (data != null) {
                data.setType(ConfigData.Type.TOML);
                for (Object key : RegistryHelper.mapTaggableList(listGetter.apply(data))) {
                    mapAdder.accept(map, key, (Object)data);
                }
                continue;
            }
            ColdSweat.LOGGER.error("Error parsing {} config \"{}\"", (Object)keyRegistry.func_240901_a_(), (Object)entry.toString());
        }
        return map;
    }

    public static CompoundNBT serializeNbtBool(boolean value, String key) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a(key, value);
        return tag;
    }

    public static CompoundNBT serializeNbtInt(int value, String key) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a(key, value);
        return tag;
    }

    public static CompoundNBT serializeNbtDouble(double value, String key) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74780_a(key, value);
        return tag;
    }

    public static CompoundNBT serializeNbtString(String value, String key) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a(key, value);
        return tag;
    }

    public static <K, V extends ConfigData> CompoundNBT serializeRegistry(Map<K, V> map, String key, RegistryKey<Registry<K>> gameRegistry, ModRegistries.ConfigRegistry<V> modRegistry, Function<K, ResourceLocation> keyGetter) {
        return ConfigHelper.serializeEitherRegistry(map, key, gameRegistry, modRegistry, keyGetter);
    }

    public static <K, V extends ConfigData> CompoundNBT serializeHolderRegistry(Map<K, V> map, String key, RegistryKey<Registry<K>> gameRegistry, ModRegistries.ConfigRegistry<V> modRegistry, DynamicRegistries dynamicRegistries) {
        return ConfigHelper.serializeEitherRegistry(map, key, gameRegistry, modRegistry, k -> dynamicRegistries.func_243612_b(gameRegistry).func_177774_c(k));
    }

    private static <K, V extends ConfigData> CompoundNBT serializeEitherRegistry(Map<K, V> map, String key, RegistryKey<?> gameRegistry, ModRegistries.ConfigRegistry<V> modRegistry, Function<K, ResourceLocation> keyGetter) {
        Codec<V> codec = modRegistry.codec();
        NBTDynamicOps encoderOps = NBTDynamicOps.field_210820_a;
        CompoundNBT tag = new CompoundNBT();
        CompoundNBT mapTag = new CompoundNBT();
        for (Map.Entry entry : map.entrySet()) {
            ResourceLocation elementId = keyGetter.apply(entry.getKey());
            if (elementId == null) {
                ColdSweat.LOGGER.error("Error serializing {}: \"{}\" does not exist", (Object)gameRegistry.func_240901_a_(), entry.getKey());
                continue;
            }
            codec.encode(entry.getValue(), (DynamicOps)encoderOps, encoderOps.empty()).resultOrPartial(e -> ColdSweat.LOGGER.error("Error serializing {} {}: {}", (Object)modRegistry.key().func_240901_a_(), entry.getValue(), e)).ifPresent(encoded -> {
                ((CompoundNBT)encoded).func_186854_a("UUID", ((ConfigData)entry.getValue()).getId());
                mapTag.func_218657_a(elementId.toString(), encoded);
            });
        }
        tag.func_218657_a(key, (INBT)mapTag);
        return tag;
    }

    public static <K, V extends ConfigData> Map<K, V> deserializeRegistry(CompoundNBT tag, String key, ModRegistries.ConfigRegistry<V> modRegistry, Function<ResourceLocation, K> keyGetter) {
        return ConfigHelper.deserializeEitherRegistry(tag, key, modRegistry, keyGetter, null);
    }

    public static <K, V extends ConfigData> Map<K, V> deserializeHolderRegistry(CompoundNBT tag, String key, RegistryKey<Registry<K>> gameRegistry, ModRegistries.ConfigRegistry<V> modRegistry, DynamicRegistries dynamicRegistries) {
        MutableRegistry registry = dynamicRegistries.func_243612_b(gameRegistry);
        return ConfigHelper.deserializeEitherRegistry(tag, key, modRegistry, arg_0 -> ConfigHelper.lambda$deserializeHolderRegistry$5((Registry)registry, arg_0), dynamicRegistries);
    }

    private static <K, V extends ConfigData> Map<K, V> deserializeEitherRegistry(CompoundNBT tag, String key, ModRegistries.ConfigRegistry<V> modRegistry, Function<ResourceLocation, K> keyGetter, DynamicRegistries dynamicRegistries) {
        Codec<V> codec = modRegistry.codec();
        FastMap map = new FastMap();
        CompoundNBT mapTag = tag.func_74775_l(key);
        NBTDynamicOps decoderOps = NBTDynamicOps.field_210820_a;
        for (String entryKey : mapTag.func_150296_c()) {
            CompoundNBT entryData = mapTag.func_74775_l(entryKey);
            codec.decode((DynamicOps)decoderOps, (Object)entryData).resultOrPartial(e -> ColdSweat.LOGGER.error("Error deserializing {}: {}", (Object)modRegistry.key().func_240901_a_(), e)).map(Pair::getFirst).ifPresent(value -> {
                Object entry = keyGetter.apply(new ResourceLocation(entryKey));
                if (entry != null) {
                    value.setId(entryData.func_186857_a("UUID"));
                    map.put(entry, value);
                }
            });
        }
        return map;
    }

    public static <K, V extends ConfigData> CompoundNBT serializeMultimapRegistry(Multimap<K, V> map, String key, RegistryKey<Registry<K>> gameRegistry, ModRegistries.ConfigRegistry<V> modRegistry, Function<K, ResourceLocation> keyGetter) {
        return ConfigHelper.serializeEitherMultimapRegistry(map, key, gameRegistry, modRegistry, keyGetter);
    }

    public static <K, V extends ConfigData> CompoundNBT serializeHolderMultimapRegistry(Multimap<K, V> map, String key, RegistryKey<Registry<K>> gameRegistry, ModRegistries.ConfigRegistry<V> modRegistry, DynamicRegistries dynamicRegistries) {
        return ConfigHelper.serializeEitherMultimapRegistry(map, key, gameRegistry, modRegistry, k -> dynamicRegistries.func_243612_b(gameRegistry).func_177774_c(k));
    }

    private static <K, V extends ConfigData> CompoundNBT serializeEitherMultimapRegistry(Multimap<K, V> map, String key, RegistryKey<Registry<K>> gameRegistry, ModRegistries.ConfigRegistry<V> modRegistry, Function<K, ResourceLocation> keyGetter) {
        Codec<V> codec = modRegistry.codec();
        CompoundNBT tag = new CompoundNBT();
        CompoundNBT mapTag = new CompoundNBT();
        for (Map.Entry entry : map.asMap().entrySet()) {
            ResourceLocation elementId = keyGetter.apply(entry.getKey());
            if (elementId == null) {
                ColdSweat.LOGGER.error("Error serializing {}: \"{}\" does not exist", (Object)gameRegistry.func_240901_a_(), entry.getKey());
                continue;
            }
            ListNBT valuesTag = new ListNBT();
            for (ConfigData value : (Collection)entry.getValue()) {
                codec.encode((Object)value, (DynamicOps)NBTDynamicOps.field_210820_a, (Object)NBTDynamicOps.field_210820_a.empty()).resultOrPartial(e -> ColdSweat.LOGGER.error("Error serializing {} \"{}\": {}", (Object)modRegistry.key().func_240901_a_(), (Object)elementId, e)).ifPresent(encoded -> {
                    ((CompoundNBT)encoded).func_186854_a("UUID", value.getId());
                    valuesTag.add(encoded);
                });
            }
            mapTag.func_218657_a(elementId.toString(), (INBT)valuesTag);
        }
        tag.func_218657_a(key, (INBT)mapTag);
        return tag;
    }

    public static <K, V extends ConfigData> Multimap<K, V> deserializeMultimapRegistry(CompoundNBT tag, String key, ModRegistries.ConfigRegistry<V> modRegistry, Function<ResourceLocation, K> keyGetter) {
        return ConfigHelper.deserializeEitherMultimapRegistry(tag, key, modRegistry, keyGetter, null);
    }

    public static <K, V extends ConfigData> Multimap<K, V> deserializeHolderMultimapRegistry(CompoundNBT tag, String key, RegistryKey<Registry<K>> gameRegistry, ModRegistries.ConfigRegistry<V> modRegistry, DynamicRegistries dynamicRegistries) {
        MutableRegistry registry = dynamicRegistries.func_243612_b(gameRegistry);
        return ConfigHelper.deserializeEitherMultimapRegistry(tag, key, modRegistry, arg_0 -> ConfigHelper.lambda$deserializeHolderMultimapRegistry$11((Registry)registry, arg_0), dynamicRegistries);
    }

    private static <K, V extends ConfigData> Multimap<K, V> deserializeEitherMultimapRegistry(CompoundNBT tag, String key, ModRegistries.ConfigRegistry<V> modRegistry, Function<ResourceLocation, K> keyGetter, DynamicRegistries registryAccess) {
        Codec<V> codec = modRegistry.codec();
        FastMultiMap map = new FastMultiMap();
        CompoundNBT mapTag = tag.func_74775_l(key);
        for (String entryKey : mapTag.func_150296_c()) {
            ListNBT entryData = mapTag.func_150295_c(entryKey, 10);
            Object object = keyGetter.apply(new ResourceLocation(entryKey));
            if (object == null) {
                ColdSweat.LOGGER.error("Error deserializing: \"{}\" does not exist in registry", (Object)entryKey);
                continue;
            }
            for (INBT valueTag : entryData) {
                CompoundNBT valueData = (CompoundNBT)valueTag;
                codec.decode((DynamicOps)NBTDynamicOps.field_210820_a, (Object)valueData).result().map(Pair::getFirst).ifPresent(value -> {
                    value.setId(valueData.func_186857_a("UUID"));
                    map.put(object, value);
                });
            }
        }
        return map;
    }

    public static <T> void writeRegistryMap(Map<Item, T> map, Function<T, List<String>> keyWriter, Function<T, List<?>> valueWriter, Consumer<List<? extends List<?>>> saver) {
        ConfigHelper.writeRegistryMapLike(Either.left(map), keyWriter, valueWriter, saver);
    }

    public static <K, V> void writeRegistryMultimap(Multimap<K, V> map, Function<V, List<String>> keyWriter, Function<V, List<?>> valueWriter, Consumer<List<? extends List<?>>> saver) {
        ConfigHelper.writeRegistryMapLike(Either.right(map), keyWriter, valueWriter, saver);
    }

    private static <K, V> void writeRegistryMapLike(Either<Map<K, V>, Multimap<K, V>> map, Function<V, List<String>> keyWriter, Function<V, List<?>> valueWriter, Consumer<List<? extends List<?>>> saver) {
        ArrayList list = new ArrayList();
        for (Map.Entry entry : (Collection)map.map(Map::entrySet, Multimap::entries)) {
            Object value = entry.getValue();
            ArrayList<String> itemData = new ArrayList<String>();
            List<String> keySet = keyWriter.apply(value);
            itemData.add(ConfigHelper.concatStringList(keySet));
            List<?> args = valueWriter.apply(value);
            if (args == null) continue;
            itemData.addAll(args);
            list.add(itemData);
        }
        saver.accept(list);
    }

    public static <T extends IForgeRegistryEntry<T>> Codec<Either<ITag<T>, T>> tagOrBuiltinCodec(RegistryKey<Registry<T>> vanillaRegistry, Registry<T> forgeRegistry) {
        ITagCollection vanillaTags = ConfigHelper.getTagsForRegistry(vanillaRegistry);
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error((String)("Not a tag key: " + str));
            }
            ResourceLocation itemLocation = new ResourceLocation(str.replace("#", ""));
            return DataResult.success((Object)vanillaTags.func_199910_a(itemLocation));
        }, key -> "#" + vanillaTags.func_232973_a_(key)), forgeRegistry);
    }

    public static <T> Codec<T> dynamicCodec(RegistryKey<Registry<T>> vanillaRegistry) {
        Supplier<Registry> registryGetter = () -> (MutableRegistry)RegistryHelper.getDynamicRegistries().func_230521_a_(vanillaRegistry).get();
        return Codec.STRING.xmap(str -> ((Registry)registryGetter.get()).func_82594_a(new ResourceLocation(str)), item -> ((Registry)registryGetter.get()).func_177774_c(item).toString());
    }

    public static <T> String serializeTagOrRegistryKey(Either<ITag<T>, RegistryKey<T>> obj) {
        return (String)obj.map(tag -> "#" + ConfigHelper.getTagsForObject(obj).func_232973_a_(tag), key -> key.func_240901_a_().toString());
    }

    public static <T extends IForgeRegistryEntry<T>> String serializeTagOrBuiltinObject(IForgeRegistry<T> forgeRegistry, Either<ITag<T>, T> obj) {
        return (String)obj.map(tag -> "#" + ConfigHelper.getTagsForObject(obj).func_232973_a_(tag), regObj -> Optional.ofNullable(forgeRegistry.getKey(regObj)).map(ResourceLocation::toString).orElse(""));
    }

    public static <T> String serializeTagOrRegistryObject(RegistryKey<Registry<T>> registry, Either<ITag<T>, T> obj, DynamicRegistries DynamicRegistries2) {
        MutableRegistry reg = DynamicRegistries2.func_243612_b(registry);
        return (String)obj.map(tag -> "#" + ConfigHelper.getTagsForObject(obj).func_232973_a_(tag), arg_0 -> ConfigHelper.lambda$serializeTagOrRegistryObject$23((Registry)reg, arg_0));
    }

    public static <T> Either<ITag<T>, RegistryKey<T>> deserializeTagOrRegistryKey(RegistryKey<Registry<T>> registry, String key) {
        if (key.startsWith("#")) {
            ResourceLocation tagID = new ResourceLocation(key.replace("#", ""));
            return Either.left((Object)ConfigHelper.getTagsForRegistry(registry).func_199910_a(tagID));
        }
        RegistryKey biomeKey = RegistryKey.func_240903_a_(registry, (ResourceLocation)new ResourceLocation(key));
        return Either.right((Object)biomeKey);
    }

    public static <T extends IForgeRegistryEntry<T>> Either<ITag<T>, T> deserializeTagOrRegistryObject(String tagOrRegistryObject, RegistryKey<Registry<T>> vanillaRegistry, IForgeRegistry<T> forgeRegistry) {
        if (tagOrRegistryObject.startsWith("#")) {
            ResourceLocation tagID = new ResourceLocation(tagOrRegistryObject.replace("#", ""));
            return Either.left((Object)ConfigHelper.getTagsForRegistry(vanillaRegistry).func_199910_a(tagID));
        }
        ResourceLocation id = new ResourceLocation(tagOrRegistryObject);
        IForgeRegistryEntry obj = forgeRegistry.getValue(id);
        if (obj == null) {
            ColdSweat.LOGGER.error("Error deserializing config: object \"{}\" does not exist", (Object)tagOrRegistryObject);
            return null;
        }
        return Either.right((Object)obj);
    }

    public static Optional<FuelData> findFirstFuelMatching(DynamicHolder<Multimap<Item, FuelData>> predicates, ItemStack stack) {
        for (FuelData predicate : predicates.get().get((Object)stack.func_77973_b())) {
            if (!predicate.test(stack)) continue;
            return Optional.of(predicate);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> Optional<T> parseResource(IResourceManager resourceManager, ResourceLocation location, Codec<T> codec) {
        if (resourceManager == null) {
            return Optional.empty();
        }
        try {
            IResource resource = resourceManager.func_199002_a(location);
            try (InputStreamReader reader = new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8);){
                JsonObject json = JSONUtils.func_212743_a((Reader)reader);
                DataResult result = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                Optional optional = result.result();
                return optional;
            }
        }
        catch (IOException e) {
            ColdSweat.LOGGER.error((Object)new RuntimeException("Failed to load JSON file: " + location, e));
            return Optional.empty();
        }
    }

    public static String concatStringList(List<String> list) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public static <T> List<String> getTaggableListStrings(List<Either<ITag<T>, T>> list, RegistryKey<Registry<T>> registry) {
        DynamicRegistries DynamicRegistries2 = RegistryHelper.getDynamicRegistries();
        if (DynamicRegistries2 == null) {
            return Arrays.asList(new String[0]);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (Either<ITag<T>, T> entry : list) {
            strings.add(ConfigHelper.serializeTagOrRegistryObject(registry, entry, DynamicRegistries2));
        }
        return strings;
    }

    public static List<String> getModIDs(String[] ids) {
        ArrayList<String> modIDs = new ArrayList<String>();
        for (String id : ids) {
            String[] split = id.split(":");
            if (split.length <= 1) continue;
            modIDs.add(split[0].replace("#", ""));
        }
        return modIDs;
    }

    public static String getModID(String id) {
        String[] split = id.split(":");
        if (split.length > 1) {
            return split[0].replace("#", "");
        }
        return "";
    }

    public static <T extends IForgeRegistryEntry<T>> List<String> getModIDs(List<Either<ITag<T>, T>> list, IForgeRegistry<T> registry) {
        return list.stream().map(either -> (String)either.map(tag -> tag instanceof ITag.INamedTag ? ((ITag.INamedTag)tag).func_230234_a_().func_110624_b() : "", obj -> Optional.ofNullable(registry.getKey(obj)).map(ResourceLocation::func_110624_b).orElse(""))).distinct().filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public static <T> List<String> getModIDs(List<T> list, RegistryKey<Registry<T>> registry) {
        DynamicRegistries dynamicRegistries = RegistryHelper.getDynamicRegistries();
        if (dynamicRegistries == null) {
            return Arrays.asList(new String[0]);
        }
        MutableRegistry reg = dynamicRegistries.func_243612_b(registry);
        return list.stream().map(arg_0 -> ConfigHelper.lambda$getModIDs$28((Registry)reg, arg_0)).distinct().filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public static <T extends IForgeRegistryEntry<T>> List<String> getTaggableModIDs(List<Either<ITag.INamedTag<T>, T>> list, IForgeRegistry<T> registry) {
        return list.stream().map(either -> (String)either.map(tag -> tag.func_230234_a_().func_110624_b(), obj -> Optional.ofNullable(registry.getKey(obj)).map(ResourceLocation::func_110624_b).orElse(""))).distinct().filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private static /* synthetic */ String lambda$getModIDs$28(Registry reg, Object obj) {
        return Optional.ofNullable(reg.func_177774_c(obj)).map(ResourceLocation::func_110624_b).orElse("");
    }

    private static /* synthetic */ String lambda$serializeTagOrRegistryObject$23(Registry reg, Object regObj) {
        return Optional.ofNullable(reg.func_177774_c(regObj)).map(ResourceLocation::toString).orElse("");
    }

    private static /* synthetic */ Object lambda$deserializeHolderMultimapRegistry$11(Registry registry, ResourceLocation rl) {
        return registry.func_241873_b(rl).orElse(null);
    }

    private static /* synthetic */ Object lambda$deserializeHolderRegistry$5(Registry registry, ResourceLocation rl) {
        return registry.func_241873_b(rl).orElse(null);
    }
}

