/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.mojang.datafixers.util.Either;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class RegistryHelper {
    @Nullable
    public static <T> Registry<T> getRegistry(RegistryKey<Registry<T>> registry) {
        return CSMath.getIfNotNull(RegistryHelper.getDynamicRegistries(), access -> access.func_243612_b(registry), null);
    }

    @Nullable
    public static DynamicRegistries getDynamicRegistries() {
        DynamicRegistries access = null;
        MinecraftServer server = WorldHelper.getServer();
        if (server != null) {
            ServerWorld level = server.func_71218_a(World.field_234918_g_);
            access = level != null ? level.func_241828_r() : server.func_244267_aX();
        }
        if (access == null && FMLEnvironment.dist == Dist.CLIENT) {
            if (Minecraft.func_71410_x().field_71441_e != null) {
                access = Minecraft.func_71410_x().field_71441_e.func_241828_r();
            } else {
                ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
                if (connection != null) {
                    access = connection.func_239165_n_();
                }
            }
        }
        return access;
    }

    public static <T> List<T> mapTaggableList(List<Either<ITag<T>, T>> eitherList) {
        ArrayList list = new ArrayList();
        for (Either<ITag<T>, T> either : eitherList) {
            either.ifLeft(tag -> {
                if (tag != null) {
                    list.addAll(tag.func_230236_b_());
                }
            });
            either.ifRight(list::add);
        }
        return list;
    }

    public static <T> Optional<T> getVanillaRegistryValue(RegistryKey<Registry<T>> registry, ResourceLocation id) {
        try {
            return Optional.ofNullable(RegistryHelper.getRegistry(registry)).map(reg -> reg.func_82594_a(id));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static ResourceLocation getKey(ConfigData object) {
        for (ModRegistries.ConfigRegistry<?> registry : ModRegistries.getRegistries().values()) {
            if (!registry.type().isInstance(object)) continue;
            for (Map.Entry<ResourceLocation, ?> entry : registry.data().entrySet()) {
                if (entry.getValue() != object) continue;
                return entry.getKey();
            }
        }
        return new ResourceLocation("unknown");
    }

    @Nullable
    public static Biome getBiome(ResourceLocation biomeId, DynamicRegistries registryAccess) {
        return (Biome)registryAccess.func_243612_b(Registry.field_239720_u_).func_82594_a(biomeId);
    }

    @Nullable
    public static ResourceLocation getBiomeId(Biome biome, DynamicRegistries registryAccess) {
        return registryAccess.func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
    }

    @Nullable
    public static DimensionType getDimension(ResourceLocation dimensionId, DynamicRegistries registryAccess) {
        return (DimensionType)registryAccess.func_243612_b(Registry.field_239698_ad_).func_82594_a(dimensionId);
    }

    @Nullable
    public static ResourceLocation getDimensionId(DimensionType dimension, DynamicRegistries registryAccess) {
        return registryAccess.func_243612_b(Registry.field_239698_ad_).func_177774_c((Object)dimension);
    }

    @Nullable
    public static StructureFeature<?, ?> getStructure(ResourceLocation structureId, DynamicRegistries registryAccess) {
        return (StructureFeature)registryAccess.func_243612_b(Registry.field_243553_av).func_82594_a(structureId);
    }

    @Nullable
    public static ResourceLocation getStructureId(StructureFeature<?, ?> structure, DynamicRegistries registryAccess) {
        return registryAccess.func_243612_b(Registry.field_243553_av).func_177774_c(structure);
    }
}

