/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.world;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.event.core.init.GatherDefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.temperature.modifier.BiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BlockTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ElevationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FrigidnessTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WarmthTempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.BlockDataUpdateMessage;
import com.momosoftworks.coldsweat.core.network.message.ParticleBatchMessage;
import com.momosoftworks.coldsweat.core.network.message.PlayEntityAttachedSoundMessage;
import com.momosoftworks.coldsweat.core.network.message.SyncForgeDataMessage;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.entity.DummyPlayer;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IStructureReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public abstract class WorldHelper {
    static Map<RegistryKey<World>, DummyPlayer> DUMMIES = new HashMap<RegistryKey<World>, DummyPlayer>();
    static Map<RegistryKey<World>, List<TempSnapshot>> TEMPERATURE_CHECKS = new FastMap<RegistryKey<World>, List<TempSnapshot>>();
    private static final Field CHUNK_BLOCK_ENTITIES = ObfuscationReflectionHelper.findField(Chunk.class, (String)"field_150816_i");

    @SubscribeEvent
    public static void clearCachesOnUnload(FMLServerStoppedEvent event) {
        DUMMIES.clear();
        TEMPERATURE_CHECKS.clear();
    }

    public static int getHeight(BlockPos pos, World level) {
        int seaLevel = level.func_181545_F();
        if (!level.func_195588_v(pos)) {
            return seaLevel;
        }
        IChunk chunk = WorldHelper.getChunk((IWorld)level, pos);
        if (chunk == null) {
            return seaLevel;
        }
        return chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR, pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF);
    }

    public static List<BlockPos> getPositionGrid(BlockPos pos, int samples, int interval) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        int sampleRoot = (int)Math.sqrt(samples);
        int radius = sampleRoot * interval / 2;
        for (int x = -radius; x < radius; x += interval) {
            for (int z = -radius; z < radius; z += interval) {
                posList.add(pos.func_177982_a(x + interval / 2, 0, z + interval / 2));
            }
        }
        return posList;
    }

    public static List<BlockPos> getPositionCube(BlockPos pos, int size, int interval) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        int radius = size * interval / 2;
        int halfInterval = interval / 2;
        for (int x = -radius + halfInterval; x < radius + halfInterval; x += interval) {
            for (int y = -radius + halfInterval; y < radius + halfInterval; y += interval) {
                for (int z = -radius + halfInterval; z < radius + halfInterval; z += interval) {
                    posList.add(pos.func_177982_a(x, y, z));
                }
            }
        }
        return posList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canSeeSky(IWorld level, BlockPos pos, int maxDistance) {
        BlockPos.Mutable pos2 = pos.func_239590_i_();
        int iterations = Math.min(maxDistance, level.func_217301_I() - pos.func_177956_o());
        IChunk chunk = WorldHelper.getChunk(level, pos);
        if (chunk == null) {
            return true;
        }
        for (int i = 0; i < iterations; ++i) {
            try {
                BlockState state = chunk.func_180495_p((BlockPos)pos2);
                if (state.func_196958_f() || state.func_185904_a().func_76224_d() || ConfigSettings.THERMAL_SOURCE_SPREAD_WHITELIST.get().contains(state.func_177230_c())) continue;
                VoxelShape shape = state.func_215700_a((IBlockReader)level, pos, ISelectionContext.func_216377_a());
                if (shape.equals(VoxelShapes.func_197868_b())) {
                    boolean bl = false;
                    return bl;
                }
                if (!WorldHelper.isFullSide(CSMath.flattenShape(Direction.Axis.Y, shape), Direction.UP)) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                pos2.func_196234_d(0, 1, 0);
            }
        }
        return true;
    }

    public static boolean isSpreadBlocked(IWorld world, BlockState state, BlockPos pos, Direction fromDir, Direction toDir) {
        Block block = state.func_177230_c();
        if (state.func_196958_f() || ConfigSettings.THERMAL_SOURCE_SPREAD_WHITELIST.get().contains(block)) {
            return false;
        }
        if (ConfigSettings.THERMAL_SOURCE_SPREAD_BLACKLIST.get().contains(block)) {
            return true;
        }
        VoxelShape shape = state.func_215685_b((IBlockReader)world, pos, ISelectionContext.func_216377_a());
        if (shape.equals(VoxelShapes.func_197868_b())) {
            return true;
        }
        return WorldHelper.isFullSide(shape.func_212434_a(fromDir.func_176734_d()), fromDir) || WorldHelper.isFullSide(CSMath.flattenShape(toDir.func_176740_k(), shape), toDir);
    }

    public static boolean isFullSide(VoxelShape shape, Direction dir) {
        if (shape.func_197766_b()) {
            return false;
        }
        double[] area = new double[1];
        switch (dir.func_176740_k()) {
            case X: {
                shape.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
                    area[0] = area[0] + Math.abs(y2 - y1) * Math.abs(z2 - z1);
                });
            }
            case Y: {
                shape.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
                    area[0] = area[0] + Math.abs(x2 - x1) * Math.abs(z2 - z1);
                });
            }
            case Z: {
                shape.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
                    area[0] = area[0] + Math.abs(x2 - x1) * Math.abs(y2 - y1);
                });
            }
        }
        return area[0] >= 1.0;
    }

    @Nullable
    public static IChunk getChunk(IWorld level, BlockPos pos) {
        return WorldHelper.getChunk(level, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    @Nullable
    public static IChunk getChunk(IWorld level, ChunkPos pos) {
        return WorldHelper.getChunk(level, pos.field_77276_a, pos.field_77275_b);
    }

    @Nullable
    public static IChunk getChunk(IWorld level, int chunkX, int chunkZ) {
        return level.func_72863_F().func_225313_a(chunkX, chunkZ);
    }

    public static ChunkSection getChunkSection(IChunk chunk, int y) {
        ChunkSection[] sections = chunk.func_76587_i();
        return sections[CSMath.clamp(y >> 4, 0, sections.length - 1)];
    }

    public static Optional<StructureFeature<?, ?>> getStructureAt(World level, BlockPos pos) {
        if (!(level instanceof ServerWorld)) {
            return Optional.empty();
        }
        ServerWorld serverLevel = (ServerWorld)level;
        StructureManager structureManager = serverLevel.func_241112_a_();
        for (Map.Entry entry : level.func_217349_x(pos).func_201604_d().entrySet()) {
            Structure structure = (Structure)entry.getKey();
            LongSet strucCoordinates = (LongSet)entry.getValue();
            LongIterator longIterator = strucCoordinates.iterator();
            while (longIterator.hasNext()) {
                long coordinate = (Long)longIterator.next();
                SectionPos sectionpos = SectionPos.func_218156_a((ChunkPos)new ChunkPos(coordinate), (int)SectionPos.func_218159_a((int)0));
                StructureStart structurestart = structureManager.func_235013_a_(sectionpos, structure, (IStructureReader)level.func_217348_a(sectionpos.func_218149_a(), sectionpos.func_218148_c(), ChunkStatus.field_222606_b));
                if (structurestart == null || !structurestart.func_75069_d() || !structurestart.func_75071_a().func_175898_b((Vector3i)pos) || !structurestart.func_186161_c().stream().anyMatch(piece -> piece.func_74874_b().func_175898_b((Vector3i)pos))) continue;
                ResourceLocation structureId = structure.delegate.name();
                if (structureId == null) {
                    return Optional.empty();
                }
                return Optional.ofNullable(serverLevel.func_241828_r().func_243612_b(Registry.field_243553_av).func_82594_a(Registry.field_218361_B.func_177774_c((Object)structure)));
            }
        }
        return Optional.empty();
    }

    public static void playEntitySound(SoundEvent sound, Entity entity, SoundCategory source, float volume, float pitch) {
        if (!entity.func_174814_R()) {
            if (entity.field_70170_p.field_72995_K) {
                ClientOnlyHelper.playEntitySound(sound, source, volume, pitch, entity);
            } else {
                ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new PlayEntityAttachedSoundMessage(sound, source, volume, pitch, entity.func_145782_y()));
            }
        }
    }

    public static boolean isInWater(Entity entity) {
        BlockPos pos = entity.func_233580_cy_();
        IChunk chunk = WorldHelper.getChunk((IWorld)entity.field_70170_p, pos);
        if (chunk == null) {
            return false;
        }
        return entity.func_70090_H() || chunk.func_180495_p(pos).func_177230_c() == Blocks.field_203203_C;
    }

    public static boolean isRainingAt(World level, BlockPos pos) {
        DynamicHolder<Biome> biome = DynamicHolder.create(() -> null, h -> h.set(level.func_225523_d_().func_226836_a_(pos)));
        return level.func_72896_J() && biome.get().func_201851_b() == Biome.RainType.RAIN && WorldHelper.canSeeSky((IWorld)level, pos.func_177984_a(), level.func_217301_I()) && biome.get().func_225486_c(pos) >= 0.15f && !CompatManager.SereneSeasons.isColdEnoughToSnow(level, pos);
    }

    public static void forBlocksInRay(Vector3d from, Vector3d to, World level, IChunk chunk, Map<BlockPos, BlockState> stateCache, BiConsumer<BlockState, BlockPos> rayTracer, int maxHits) {
        block5: {
            if (from.equals((Object)to)) break block5;
            Vector3d ray = to.func_178788_d(from);
            Vector3d normalRay = ray.func_72432_b();
            BlockPos.Mutable pos = new BlockPos(from).func_239590_i_();
            IChunk workingChunk = chunk;
            int i = 0;
            while ((double)i < ray.func_72433_c()) {
                block6: {
                    BlockState state;
                    block7: {
                        Vector3d vec = from.func_178787_e(normalRay.func_186678_a((double)i));
                        if (new BlockPos(vec).equals((Object)pos)) break block6;
                        pos.func_189532_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                        state = stateCache.get(pos);
                        if (state != null) break block7;
                        if (workingChunk == null || !workingChunk.func_76632_l().equals((Object)new ChunkPos((BlockPos)pos))) {
                            workingChunk = WorldHelper.getChunk((IWorld)level, (BlockPos)pos);
                        }
                        if (workingChunk == null) break block6;
                        state = workingChunk.func_180495_p((BlockPos)pos);
                        stateCache.put(pos.func_185334_h(), state);
                    }
                    if (!state.func_196958_f() && --maxHits <= 0) break;
                    rayTracer.accept(state, (BlockPos)pos);
                }
                ++i;
            }
        }
    }

    public static void forBlocksInRay(Vector3d from, Vector3d to, World level, BiConsumer<BlockState, BlockPos> rayTracer, int maxHits) {
        WorldHelper.forBlocksInRay(from, to, level, WorldHelper.getChunk((IWorld)level, new BlockPos(from)), new HashMap<BlockPos, BlockState>(), rayTracer, maxHits);
    }

    public static Entity raycastEntity(Vector3d from, Vector3d to, World level, Predicate<Entity> filter) {
        if (!from.equals((Object)to)) {
            Vector3d ray = to.func_178788_d(from);
            Vector3d normalRay = ray.func_72432_b();
            BlockPos.Mutable pos = new BlockPos(from).func_239590_i_();
            int i = 0;
            while ((double)i < ray.func_72433_c()) {
                Vector3d vec = from.func_178787_e(normalRay.func_186678_a((double)i));
                if (!new BlockPos(vec).equals((Object)pos)) {
                    pos.func_189532_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                    List entities = level.func_175647_a(Entity.class, new AxisAlignedBB((BlockPos)pos), filter);
                    if (!entities.isEmpty()) {
                        return (Entity)entities.get(0);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static void spawnParticle(World world, IParticleData particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        if (!world.field_72995_K) {
            ParticleBatchMessage particles = new ParticleBatchMessage();
            particles.addParticle(particle, new ParticleBatchMessage.ParticlePlacement(x, y, z, xSpeed, ySpeed, zSpeed));
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> (Chunk)WorldHelper.getChunk((IWorld)world, (int)x >> 4, (int)z >> 4)), (Object)particles);
        } else {
            world.func_195594_a(particle, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public static void spawnParticleBatch(World level, IParticleData particle, double x, double y, double z, double xSpread, double ySpread, double zSpread, double count, double speed) {
        Random rand = new Random();
        if (!level.field_72995_K) {
            ParticleBatchMessage particles = new ParticleBatchMessage();
            int i = 0;
            while ((double)i < count) {
                Vector3d vec = new Vector3d(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).func_72432_b().func_186678_a(speed);
                particles.addParticle(particle, new ParticleBatchMessage.ParticlePlacement(x + xSpread - rand.nextDouble() * (xSpread * 2.0), y + ySpread - rand.nextDouble() * (ySpread * 2.0), z + zSpread - rand.nextDouble() * (zSpread * 2.0), vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
                ++i;
            }
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.DIMENSION.with(() -> ((World)level).func_234923_W_()), (Object)particles);
        } else {
            int i = 0;
            while ((double)i < count) {
                Vector3d vec = new Vector3d(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).func_72432_b().func_186678_a(speed);
                level.func_195594_a(particle, x + xSpread - rand.nextDouble() * (xSpread * 2.0), y + ySpread - rand.nextDouble() * (ySpread * 2.0), z + zSpread - rand.nextDouble() * (zSpread * 2.0), vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                ++i;
            }
        }
    }

    public static ItemEntity dropItem(World level, BlockPos pos, ItemStack stack) {
        return WorldHelper.dropItem(level, pos, stack, 6000);
    }

    public static ItemEntity dropItem(World level, BlockPos pos, ItemStack stack, int lifeTime) {
        Random rand = new Random();
        ItemEntity item = new ItemEntity(level, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        item.func_213317_d(item.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
        Field age = ObfuscationReflectionHelper.findField(ItemEntity.class, (String)"f_31985_");
        age.setAccessible(true);
        try {
            age.set(item, 6000 - lifeTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    public static ItemEntity entityDropItem(Entity entity, ItemStack stack) {
        return WorldHelper.entityDropItem(entity, stack, 6000);
    }

    public static ItemEntity entityDropItem(Entity entity, ItemStack stack, int lifeTime) {
        Random rand = new Random();
        ItemEntity item = entity.func_70099_a(stack, entity.func_213302_cg());
        if (item != null) {
            item.func_213317_d(item.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
            item.lifespan = lifeTime;
        }
        return item;
    }

    public static Vector3d getClosestPointOnEntity(LivingEntity entity, Vector3d pos) {
        double playerRadius = entity.func_213311_cf() / 2.0f;
        return new Vector3d(CSMath.clamp(pos.field_72450_a, entity.func_226277_ct_() - playerRadius, entity.func_226277_ct_() + playerRadius), CSMath.clamp(pos.field_72448_b, entity.func_226278_cu_(), entity.func_226278_cu_() + (double)entity.func_213302_cg()), CSMath.clamp(pos.field_72449_c, entity.func_226281_cx_() - playerRadius, entity.func_226281_cx_() + playerRadius));
    }

    public static void syncEntityForgeData(Entity entity, ServerPlayerEntity destination) {
        ColdSweatPacketHandler.INSTANCE.send(destination != null ? PacketDistributor.PLAYER.with(() -> destination) : PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new SyncForgeDataMessage(entity));
    }

    public static void syncBlockEntityData(TileEntity te) {
        if (te.func_145831_w() == null || te.func_145831_w().field_72995_K) {
            return;
        }
        IChunk ichunk = WorldHelper.getChunk((IWorld)te.func_145831_w(), te.func_174877_v());
        if (ichunk instanceof Chunk) {
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> (Chunk)ichunk), (Object)new BlockDataUpdateMessage(te));
        }
    }

    public static ServerWorld getServerLevel(World level) {
        return ServerLifecycleHooks.getCurrentServer().func_71218_a(level.func_234923_W_());
    }

    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static Pair<Double, Double> getBiomeTemperatureRange(IWorld level, Biome biome) {
        return WorldHelper.getBiomeTemperatureRange(level.func_241828_r(), biome);
    }

    public static Pair<Double, Double> getBiomeTemperatureRange(DynamicRegistries registryAccess, Biome biome) {
        double variance = 1.0f / Math.max(1.0f, 2.0f + biome.func_76727_i() * 2.0f);
        double baseTemp = biome.func_242445_k();
        BiomeTempData biomeTemp = ConfigSettings.BIOME_TEMPS.get(registryAccess).getOrDefault(biome, new BiomeTempData(biome, baseTemp - variance, baseTemp + variance, Temperature.Units.MC, true));
        BiomeTempData configOffset = ConfigSettings.BIOME_OFFSETS.get(registryAccess).getOrDefault(biome, new BiomeTempData(biome, 0.0, 0.0, Temperature.Units.MC, false));
        return CSMath.addPairs(Pair.of((Object)biomeTemp.minTemp(), (Object)biomeTemp.maxTemp()), Pair.of((Object)configOffset.minTemp(), (Object)configOffset.maxTemp()));
    }

    public static double getBiomeTemperature(IWorld level, Biome biome) {
        Pair<Double, Double> temps = WorldHelper.getBiomeTemperatureRange(level, biome);
        return CSMath.blend((Double)temps.getFirst(), (Double)temps.getSecond(), Math.sin((double)level.func_241851_ab() / 3819.7186342054883), -1.0, 1.0);
    }

    public static double getRoughTemperatureAt(World level, BlockPos pos) {
        List snapshots = TEMPERATURE_CHECKS.computeIfAbsent((RegistryKey<World>)level.func_234923_W_(), dim -> new ArrayList());
        int tickSpeedMultiplier = Math.max(1, level.func_82736_K().func_223592_c(GameRules.field_223610_m) / 20);
        for (int i = 0; i < snapshots.size(); ++i) {
            TempSnapshot snapshot = (TempSnapshot)snapshots.get(i);
            if (level != snapshot.level() || !CSMath.withinCubeDistance(pos, snapshot.pos(), 10.0)) continue;
            if (level.func_82737_E() - snapshot.timestamp < (long)(200 / tickSpeedMultiplier)) {
                return snapshot.temperature();
            }
            snapshots.remove(i);
            --i;
        }
        DummyPlayer dummy = WorldHelper.getDummyPlayer(level);
        Vector3d newPos = CSMath.getCenterPos(pos);
        dummy.func_70107_b(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
        ArrayList<TempModifier> modifiers = new ArrayList<TempModifier>(Temperature.getModifiers((LivingEntity)dummy, Temperature.Trait.WORLD));
        for (int i = 0; i < modifiers.size(); ++i) {
            TempModifier modifier = (TempModifier)modifiers.get(i);
            if (modifier instanceof BlockTempModifier) {
                modifiers.set(i, new BlockTempModifier(3));
                continue;
            }
            if (modifier instanceof BiomeTempModifier) {
                modifiers.set(i, new BiomeTempModifier(9));
                continue;
            }
            if (!(modifier instanceof ElevationTempModifier)) continue;
            modifiers.set(i, new ElevationTempModifier(9));
        }
        Pair<Integer, Integer> maxCoolingHeating = WorldHelper.getInsulationFromNearbySources(level, pos, 2);
        int maxCoolingLevel = (Integer)maxCoolingHeating.getFirst();
        int maxHeatingLevel = (Integer)maxCoolingHeating.getSecond();
        if (maxCoolingLevel > 0) {
            modifiers.add(new FrigidnessTempModifier(maxCoolingLevel));
        }
        if (maxHeatingLevel > 0) {
            modifiers.add(new WarmthTempModifier(maxHeatingLevel));
        }
        double tempAt = Temperature.apply(0.0, (LivingEntity)dummy, Temperature.Trait.WORLD, modifiers, true);
        snapshots.add(new TempSnapshot(level, pos, level.func_82737_E(), tempAt));
        return tempAt;
    }

    public static double getBlockTemperature(World level, BlockState block) {
        Collection<BlockTemp> blockTemps = BlockTempRegistry.getBlockTempsFor(block);
        double temp = 0.0;
        for (BlockTemp blockTemp : blockTemps) {
            temp += blockTemp.getTemperature(level, null, block, BlockPos.field_177992_a, 0.0);
        }
        return temp;
    }

    public static double getTemperatureAt(World level, BlockPos pos) {
        DummyPlayer dummy = WorldHelper.getDummyPlayer(level);
        Vector3d newPos = CSMath.getCenterPos(pos);
        dummy.func_70107_b(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
        return Temperature.apply(0.0, (LivingEntity)dummy, Temperature.Trait.WORLD, Temperature.getModifiers((LivingEntity)dummy, Temperature.Trait.WORLD), true);
    }

    public static DummyPlayer getDummyPlayer(World level) {
        RegistryKey dimension = level.func_234923_W_();
        DummyPlayer dummy = DUMMIES.get(dimension);
        if (dummy == null || dummy.field_70170_p != level) {
            dummy = new DummyPlayer(level);
            DUMMIES.put((RegistryKey<World>)dimension, dummy);
            GatherDefaultTempModifiersEvent event = new GatherDefaultTempModifiersEvent((LivingEntity)dummy, Temperature.Trait.WORLD);
            MinecraftForge.EVENT_BUS.post((Event)event);
            for (TempModifier modifier : event.getModifiers()) {
                modifier.tickRate(1);
            }
            Temperature.addModifiers((LivingEntity)dummy, event.getModifiers(), Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
        }
        return dummy;
    }

    public Map<RegistryKey<World>, DummyPlayer> getDummyPlayers() {
        return DUMMIES;
    }

    public Map<RegistryKey<World>, List<TempSnapshot>> getWorldTempCache() {
        return TEMPERATURE_CHECKS;
    }

    public static boolean allAdjacentBlocksMatch(BlockPos pos, Predicate<BlockPos> predicate) {
        BlockPos.Mutable pos2 = pos.func_239590_i_();
        for (int i = 0; i < Direction.values().length; ++i) {
            BlockPos.Mutable offset = pos2.func_239622_a_((Vector3i)pos, Direction.values()[i]);
            if (predicate.test((BlockPos)offset)) continue;
            return false;
        }
        return true;
    }

    public static BlockState waterlog(BlockState state, World level, BlockPos pos) {
        boolean waterAt = level.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(waterAt));
    }

    public static boolean shouldFreeze(IWorld levelReader, BlockPos pos, boolean mustBeAtEdge) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < levelReader.func_217301_I() && levelReader instanceof ServerWorld) {
            if (WorldHelper.surroundedByIce(levelReader, pos)) {
                return true;
            }
            DynamicHolder<Boolean> freezingTemp = DynamicHolder.create(() -> WorldHelper.getRoughTemperatureAt((World)((ServerWorld)levelReader), pos) < 0.0);
            if (!mustBeAtEdge) {
                return freezingTemp.get();
            }
            boolean surroundedByWater = levelReader.func_201671_F(pos.func_177978_c()) && levelReader.func_201671_F(pos.func_177968_d()) && levelReader.func_201671_F(pos.func_177974_f()) && levelReader.func_201671_F(pos.func_177976_e());
            return !surroundedByWater && freezingTemp.get() != false;
        }
        return false;
    }

    public static boolean shouldMelt(IWorld levelReader, BlockPos pos, boolean mustBeAtEdge) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < levelReader.func_217301_I() && levelReader instanceof ServerWorld) {
            if (mustBeAtEdge && WorldHelper.surroundedByIce(levelReader, pos)) {
                return false;
            }
            return WorldHelper.getRoughTemperatureAt((World)((ServerWorld)levelReader), pos) >= 0.0;
        }
        return false;
    }

    public static boolean surroundedByIce(IWorld level, BlockPos pos) {
        return level.func_180495_p(pos.func_177978_c()).func_203425_a(Blocks.field_150432_aD) && level.func_180495_p(pos.func_177968_d()).func_203425_a(Blocks.field_150432_aD) && level.func_180495_p(pos.func_177974_f()).func_203425_a(Blocks.field_150432_aD) && level.func_180495_p(pos.func_177976_e()).func_203425_a(Blocks.field_150432_aD);
    }

    public static boolean nextToSoulFire(IWorld level, BlockPos pos) {
        BlockPos.Mutable pos2 = pos.func_239590_i_();
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockState state = level.func_180495_p((BlockPos)pos2.func_239621_a_((Vector3i)pos, x, y, z));
                    if (!state.func_203425_a(Blocks.field_235335_bO_) && (!state.func_203425_a(Blocks.field_235367_mf_) || !((Boolean)state.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Pair<Integer, Integer> getInsulationFromNearbySources(World level, BlockPos pos, int chunkRadius) {
        int maxCoolingLevel = 0;
        int maxHeatingLevel = 0;
        ChunkPos chunkPos = new ChunkPos(pos);
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                IChunk ichunk = WorldHelper.getChunk((IWorld)level, chunkPos.field_77276_a + x, chunkPos.field_77275_b + z);
                if (!(ichunk instanceof Chunk)) continue;
                Chunk chunk = (Chunk)ichunk;
                for (TileEntity be : WorldHelper.getBlockEntities(chunk).values()) {
                    if (!(be instanceof HearthBlockEntity) || !((HearthBlockEntity)be).getPathLookup().containsKey((Object)pos)) continue;
                    HearthBlockEntity hearth = (HearthBlockEntity)be;
                    maxCoolingLevel = Math.max(maxCoolingLevel, hearth.getCoolingLevel());
                    maxHeatingLevel = Math.max(maxHeatingLevel, hearth.getHeatingLevel());
                }
            }
        }
        return Pair.of((Object)maxCoolingLevel, (Object)maxHeatingLevel);
    }

    public static Map<BlockPos, TileEntity> getBlockEntities(Chunk chunk) {
        try {
            return (Map)CHUNK_BLOCK_ENTITIES.get(chunk);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return Collections.emptyMap();
        }
    }

    public static List<BlockPos> getOccupiedPositions(AxisAlignedBB bb) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int minX = (int)Math.floor(bb.field_72340_a);
        int minY = (int)Math.floor(bb.field_72338_b);
        int minZ = (int)Math.floor(bb.field_72339_c);
        int maxX = (int)Math.ceil(bb.field_72336_d);
        int maxY = (int)Math.ceil(bb.field_72337_e);
        int maxZ = (int)Math.ceil(bb.field_72334_f);
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    positions.add(new BlockPos(x, y, z));
                }
            }
        }
        return positions;
    }

    static {
        CHUNK_BLOCK_ENTITIES.setAccessible(true);
    }

    public static class TempSnapshot {
        private final World level;
        private final BlockPos pos;
        private final long timestamp;
        private final double temperature;

        public TempSnapshot(World level, BlockPos pos, long timestamp, double temperature) {
            this.level = level;
            this.pos = pos;
            this.timestamp = timestamp;
            this.temperature = temperature;
        }

        public World level() {
            return this.level;
        }

        public BlockPos pos() {
            return this.pos;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public double temperature() {
            return this.temperature;
        }
    }
}

