/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntitySpring;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.IColorProvidingBlock;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.Nullable;

public class BlockSpring
extends BlockContainerImpl
implements ICustomBlockState,
IColorProvidingBlock,
IColorProvidingItem,
BucketPickup {
    public BlockSpring() {
        super("spring", BlockEntitySpring.class, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockColor getBlockColor() {
        return (state, level, pos, i) -> level == null || pos == null ? -1 : BiomeColors.getAverageWaterColor((BlockAndTintGetter)level, (BlockPos)pos);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor() {
        return new ItemColor(this){

            public int getColor(ItemStack stack, int i) {
                LocalPlayer player = Minecraft.getInstance().player;
                if (player == null) {
                    return 0;
                }
                return BiomeColors.getAverageWaterColor((BlockAndTintGetter)player.level(), (BlockPos)player.blockPosition());
            }
        };
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().getExistingFile(generator.modLoc(this.getBaseName())));
    }

    public ItemStack pickupBlock(@Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        BlockEntitySpring spring;
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof BlockEntitySpring && (spring = (BlockEntitySpring)blockEntity).tryConsumeAura(2500)) {
            return new ItemStack((ItemLike)Items.WATER_BUCKET);
        }
        return ItemStack.EMPTY;
    }

    public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }
}

