/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.misc.LevelData;
import de.ellpeck.naturesaura.packet.PacketAuraChunk;
import de.ellpeck.naturesaura.packet.PacketHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;

public class AuraChunk
implements IAuraChunk {
    private final Map<BlockPos, DrainSpot> drainSpots = new ConcurrentHashMap<BlockPos, DrainSpot>();
    private final Table<BlockPos, Integer, Pair<Integer, Integer>> auraAndSpotAmountCache = HashBasedTable.create();
    private final Table<BlockPos, Integer, Pair<BlockPos, Integer>[]> limitSpotCache = HashBasedTable.create();
    private final List<IDrainSpotEffect> effects = new ArrayList<IDrainSpotEffect>();
    private final LevelChunk chunk;
    private final IAuraType type;
    private boolean needsSync;

    public AuraChunk(LevelChunk chunk) {
        this.chunk = chunk;
        this.type = IAuraType.forLevel(chunk.getLevel());
        for (Supplier<IDrainSpotEffect> supplier : NaturesAuraAPI.DRAIN_SPOT_EFFECTS.values()) {
            IDrainSpotEffect effect = supplier.get();
            if (!effect.appliesHere(this.chunk, this, this.type)) continue;
            this.effects.add(effect);
        }
    }

    @Override
    public int drainAura(BlockPos pos, int amount, boolean aimForZero, boolean simulate) {
        int curr;
        if (amount <= 0) {
            return 0;
        }
        DrainSpot spot = this.getActualDrainSpot(pos, !simulate);
        int n = curr = spot != null ? spot.intValue() : 0;
        if (curr < 0 && curr - amount > 0) {
            return this.drainAura(pos.above(), amount, aimForZero, simulate);
        }
        if (aimForZero && curr > 0 && curr - amount < 0) {
            amount = curr;
        }
        if (!simulate) {
            spot.subtract(amount);
            if (spot.intValue() == 0) {
                this.drainSpots.remove(pos);
            }
            this.markDirty();
        }
        return amount;
    }

    @Override
    public int drainAura(BlockPos pos, int amount) {
        return this.drainAura(pos, amount, false, false);
    }

    @Override
    public int storeAura(BlockPos pos, int amount, boolean aimForZero, boolean simulate) {
        int curr;
        if (amount <= 0) {
            return 0;
        }
        DrainSpot spot = this.getActualDrainSpot(pos, !simulate);
        int n = curr = spot != null ? spot.intValue() : 0;
        if (curr > 0 && curr + amount < 0) {
            return this.storeAura(pos.above(), amount, aimForZero, simulate);
        }
        if (aimForZero && curr < 0 && curr + amount > 0) {
            amount = -curr;
        }
        if (!simulate) {
            spot.add(amount);
            if (spot.intValue() == 0) {
                this.drainSpots.remove(pos);
            }
            this.markDirty();
        }
        return amount;
    }

    @Override
    public int storeAura(BlockPos pos, int amount) {
        return this.storeAura(pos, amount, true, false);
    }

    @Override
    public DrainSpot getActualDrainSpot(BlockPos pos, boolean make) {
        DrainSpot spot = this.drainSpots.get(pos);
        if (spot == null && make) {
            spot = new DrainSpot(pos, 0);
            this.addDrainSpot(spot);
        }
        return spot;
    }

    @Override
    public int getDrainSpot(BlockPos pos) {
        DrainSpot spot = this.getActualDrainSpot(pos, false);
        return spot == null ? 0 : spot.intValue();
    }

    private void addDrainSpot(DrainSpot spot) {
        int expX = spot.pos.getX() >> 4;
        int expZ = spot.pos.getZ() >> 4;
        ChunkPos myPos = this.chunk.getPos();
        if (expX != myPos.x || expZ != myPos.z) {
            throw new IllegalArgumentException("Tried to add drain spot " + String.valueOf(spot.pos) + " to chunk at " + myPos.x + ", " + myPos.z + " when it should've been added to chunk at " + expX + ", " + expZ);
        }
        this.drainSpots.put(spot.pos, spot);
    }

    public void setSpots(Collection<CompoundTag> spots) {
        this.drainSpots.clear();
        for (CompoundTag spot : spots) {
            this.addDrainSpot(new DrainSpot(spot));
        }
        this.addOrRemoveAsActive();
    }

    @Override
    public IAuraType getType() {
        return this.type;
    }

    @Override
    public void markDirty() {
        this.chunk.setUnsaved(true);
        this.needsSync = true;
        this.auraAndSpotAmountCache.clear();
        this.limitSpotCache.clear();
        this.addOrRemoveAsActive();
    }

    public void update() {
        Level level = this.chunk.getLevel();
        for (DrainSpot spot : this.drainSpots.values()) {
            for (IDrainSpotEffect effect : this.effects) {
                effect.update(level, this.chunk, this, spot.pos, spot.intValue(), spot);
            }
            if (spot.intValue() <= 0 || spot.originalSpreadPos == null || spot.originalSpreadPos.closerThan((Vec3i)spot.pos, (double)((Integer)ModConfig.instance.maxAuraSpreadRange.get()).intValue())) continue;
            this.drainAura(spot.pos, spot.intValue());
        }
        if (this.needsSync) {
            ChunkPos pos = this.chunk.getPos();
            PacketHandler.sendToAllLoaded(level, new BlockPos(pos.x * 16, 0, pos.z * 16), this.makePacket());
            this.needsSync = false;
        }
    }

    public PacketAuraChunk makePacket() {
        ChunkPos pos = this.chunk.getPos();
        return new PacketAuraChunk(pos.x, pos.z, this.drainSpots.values().stream().map(DrainSpot::serializeNBT).toList());
    }

    public void getSpots(BlockPos pos, int radius, BiConsumer<BlockPos, Integer> consumer) {
        for (Map.Entry<BlockPos, DrainSpot> entry : this.drainSpots.entrySet()) {
            BlockPos drainPos = entry.getKey();
            if (!(drainPos.distSqr((Vec3i)pos) <= (double)(radius * radius))) continue;
            consumer.accept(drainPos, entry.getValue().intValue());
        }
    }

    public Pair<Integer, Integer> getAuraAndSpotAmount(BlockPos pos, int radius) {
        Pair ret = (Pair)this.auraAndSpotAmountCache.get((Object)pos, (Object)radius);
        if (ret == null) {
            MutableInt aura = new MutableInt();
            MutableInt spots = new MutableInt();
            this.getSpots(pos, radius, (p, i) -> {
                aura.add((Number)i);
                spots.increment();
            });
            ret = Pair.of((Object)aura.intValue(), (Object)spots.intValue());
            this.auraAndSpotAmountCache.put((Object)pos, (Object)radius, (Object)ret);
        }
        return ret;
    }

    public Pair<BlockPos, Integer>[] getLowestAndHighestSpots(BlockPos pos, int radius) {
        Pair[] ret = (Pair[])this.limitSpotCache.get((Object)pos, (Object)radius);
        if (ret == null) {
            MutableObject lowestSpot = new MutableObject();
            MutableObject highestSpot = new MutableObject();
            MutableInt lowestAmount = new MutableInt(Integer.MAX_VALUE);
            MutableInt highestAmount = new MutableInt(Integer.MIN_VALUE);
            this.getSpots(pos, radius, (p, i) -> {
                if (i > highestAmount.intValue()) {
                    highestAmount.setValue((Number)i);
                    highestSpot.setValue(p);
                }
                if (i < lowestAmount.intValue()) {
                    lowestAmount.setValue((Number)i);
                    lowestSpot.setValue(p);
                }
            });
            ret = new Pair[]{Pair.of((Object)((BlockPos)lowestSpot.getValue()), (Object)lowestAmount.intValue()), Pair.of((Object)((BlockPos)highestSpot.getValue()), (Object)highestAmount.intValue())};
            this.limitSpotCache.put((Object)pos, (Object)radius, (Object)ret);
        }
        return ret;
    }

    public void getActiveEffectIcons(Player player, Map<ResourceLocation, Tuple<ItemStack, Boolean>> icons) {
        for (IDrainSpotEffect effect : this.effects) {
            Tuple<ItemStack, Boolean> alreadyThere = icons.get(effect.getName());
            if (alreadyThere != null && ((Boolean)alreadyThere.getB()).booleanValue()) continue;
            for (Map.Entry<BlockPos, DrainSpot> entry : this.drainSpots.entrySet()) {
                ItemStack stack;
                DrainSpot amount;
                BlockPos pos = entry.getKey();
                IDrainSpotEffect.ActiveType state = effect.isActiveHere(player, this.chunk, this, pos, (amount = entry.getValue()).intValue());
                if (state == IDrainSpotEffect.ActiveType.INACTIVE || (stack = effect.getDisplayIcon()).isEmpty()) continue;
                icons.put(effect.getName(), (Tuple<ItemStack, Boolean>)new Tuple((Object)stack, (Object)(state == IDrainSpotEffect.ActiveType.INHIBITED ? 1 : 0)));
            }
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        for (DrainSpot spot : this.drainSpots.values()) {
            list.add((Object)spot.serializeNBT());
        }
        CompoundTag compound = new CompoundTag();
        compound.put("drain_spots", (Tag)list);
        return compound;
    }

    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag compound) {
        this.drainSpots.clear();
        ListTag list = compound.getList("drain_spots", 10);
        for (Tag base : list) {
            this.addDrainSpot(new DrainSpot((CompoundTag)base));
        }
        this.addOrRemoveAsActive();
    }

    private void addOrRemoveAsActive() {
        long chunkPos = this.chunk.getPos().toLong();
        LevelData data = (LevelData)ILevelData.getLevelData(this.chunk.getLevel());
        if (!this.drainSpots.isEmpty()) {
            data.auraChunksWithSpots.put(chunkPos, (Object)this);
        } else {
            data.auraChunksWithSpots.remove(chunkPos);
        }
    }

    public static class DrainSpot
    extends MutableInt {
        public final BlockPos pos;
        public BlockPos originalSpreadPos;

        public DrainSpot(BlockPos pos, int value) {
            super(value);
            this.pos = pos;
        }

        public DrainSpot(CompoundTag tag) {
            this(BlockPos.of((long)tag.getLong("pos")), tag.getInt("amount"));
            if (tag.contains("original_spread_pos")) {
                this.originalSpreadPos = BlockPos.of((long)tag.getLong("original_spread_pos"));
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag ret = new CompoundTag();
            ret.putLong("pos", this.pos.asLong());
            ret.putInt("amount", this.intValue());
            if (this.originalSpreadPos != null) {
                ret.putLong("original_spread_pos", this.originalSpreadPos.asLong());
            }
            return ret;
        }
    }
}

