/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.networking;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.dawnoftime.armoroftheages.config.AOTAConfig;
import org.dawnoftime.armoroftheages.config.PreferredModel;
import org.dawnoftime.armoroftheages.networking.ConfigSyncNetworkHandler;
import org.dawnoftime.armoroftheages.networking.packets.C2SDisablePreferencesPacket;
import org.dawnoftime.armoroftheages.networking.packets.C2SPreferenceSyncPacket;
import org.dawnoftime.armoroftheages.networking.packets.S2CPreferenceSyncPacket;

public class FabricConfigSyncNetworkHandler
implements ConfigSyncNetworkHandler {
    private final HashMap<UUID, PreferredModel> CURRENT_SERVER_STATE = new HashMap();
    private Consumer<HashMap<UUID, PreferredModel>> mapHandler = null;

    @Override
    public void syncConfig() {
        try {
            if (class_310.method_1551().field_1687 == null) {
                return;
            }
        }
        catch (Exception ignored) {
            return;
        }
        if (!AOTAConfig.get().usePreferredModel) {
            ClientPlayNetworking.send((class_8710)new C2SDisablePreferencesPacket());
        } else {
            ClientPlayNetworking.send((class_8710)new C2SPreferenceSyncPacket(AOTAConfig.get().preferredModel));
        }
    }

    @Override
    public void registerHandler(Consumer<HashMap<UUID, PreferredModel>> handler) {
        this.mapHandler = handler;
    }

    @Override
    public void setup() {
        PayloadTypeRegistry.playC2S().register(C2SPreferenceSyncPacket.TYPE, C2SPreferenceSyncPacket.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(C2SDisablePreferencesPacket.TYPE, class_9139.method_56431((Object)new C2SDisablePreferencesPacket()));
        PayloadTypeRegistry.playS2C().register(S2CPreferenceSyncPacket.TYPE, S2CPreferenceSyncPacket.STREAM_CODEC);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver(S2CPreferenceSyncPacket.TYPE, (packet, context) -> this.mapHandler.accept(new HashMap<UUID, PreferredModel>(packet.modelHashMap())));
        }
        ServerPlayNetworking.registerGlobalReceiver(C2SPreferenceSyncPacket.TYPE, (packet, context) -> {
            this.CURRENT_SERVER_STATE.put(context.player().method_5667(), packet.preferredModel());
            this.globalSync(context.server());
        });
        ServerPlayNetworking.registerGlobalReceiver(C2SDisablePreferencesPacket.TYPE, (packet, context) -> {
            this.CURRENT_SERVER_STATE.remove(context.player().method_5667());
            this.globalSync(context.server());
        });
    }

    private void globalSync(MinecraftServer server) {
        for (class_3222 serverPlayer : PlayerLookup.all((MinecraftServer)server)) {
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new S2CPreferenceSyncPacket(this.CURRENT_SERVER_STATE));
        }
    }
}

