/*
 * Decompiled with CFR 0.152.
 */
package at.stjubit.ControlCraft.guis;

import at.stjubit.ControlCraft.ControlCraft;
import at.stjubit.ControlCraft.packets.ControlCenterPackets.ControlCenterItemRemovePacket;
import at.stjubit.ControlCraft.packets.ControlCenterPackets.ControlCenterSetLockPacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;

public class GuiList
extends Gui {
    FontRenderer fontRendererObj;
    int x;
    int y;
    int width;
    int height;
    boolean withLock;
    List<Integer> frequencies;
    List<String> names;
    List<String> items;
    List<Boolean> locks;
    int leftItemMargin = 5;
    int marginBetweenItems = 5;
    int fontHeight = 10;
    boolean isItemSelected = false;
    boolean isRealItemSelected = false;
    int selectedItem = 0;
    int listIndex = 0;
    int maxShownItems;
    int lockWidth = 11;
    ResourceLocation TEXTURE = new ResourceLocation("ControlCraft:textures/guis/guielements.png");
    int lockMarginBetween = 5;
    int lockMarginFirst = 2;
    int blockX;
    int blockY;
    int blockZ;

    public GuiList(FontRenderer fontRendererObj, int x, int y, int width, int height, boolean withLock) {
        this.fontRendererObj = fontRendererObj;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.withLock = withLock;
        fontRendererObj.field_78288_b = this.fontHeight;
        this.frequencies = new ArrayList<Integer>();
        this.names = new ArrayList<String>();
        this.locks = new ArrayList<Boolean>();
        this.maxShownItems = height / (this.marginBetweenItems + this.fontHeight);
        if (this.maxShownItems * (this.marginBetweenItems + this.fontHeight) + this.marginBetweenItems > height) {
            --this.maxShownItems;
        }
    }

    public void drawList(Minecraft mc) {
        GuiList.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 1), (int)Color.WHITE.getRGB());
        GuiList.func_73734_a((int)this.x, (int)(this.y + this.height), (int)(this.x + this.width), (int)(this.y + this.height + 1), (int)new Color(85, 85, 85).getRGB());
        GuiList.func_73734_a((int)this.x, (int)this.y, (int)(this.x + 1), (int)(this.y + this.height), (int)Color.WHITE.getRGB());
        GuiList.func_73734_a((int)(this.x + this.width), (int)this.y, (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)new Color(85, 85, 85).getRGB());
        GuiList.func_73734_a((int)(this.x + this.width - this.lockWidth - 6), (int)this.y, (int)(this.x + this.width - this.lockWidth - 5), (int)(this.y + this.height), (int)new Color(85, 85, 85).getRGB());
        if (this.isItemSelected) {
            GuiList.func_73734_a((int)this.x, (int)(this.y + this.selectedItem * (this.marginBetweenItems + this.fontHeight)), (int)(this.x + this.width), (int)(this.y + this.selectedItem * (this.marginBetweenItems + this.fontHeight) + this.fontHeight + this.marginBetweenItems), (int)new Color(85, 85, 85).getRGB());
            GuiList.func_73734_a((int)(this.x + this.width - this.lockWidth - 6), (int)(this.y + this.selectedItem * (this.marginBetweenItems + this.fontHeight)), (int)(this.x + this.width - this.lockWidth - 5), (int)(this.y + this.selectedItem * (this.marginBetweenItems + this.fontHeight) + this.fontHeight + this.marginBetweenItems), (int)new Color(0, 0, 0).getRGB());
        }
        int temp = this.listIndex;
        for (int i = 0; i < this.maxShownItems && this.items.size() > 0 && i < this.items.size(); ++i) {
            if (this.withLock && temp < this.locks.size()) {
                mc.field_71446_o.func_110577_a(this.TEXTURE);
                if (this.locks.get(temp).booleanValue()) {
                    this.func_73729_b(this.x + this.width - this.lockWidth, this.y + i * this.fontHeight + this.lockMarginFirst + i * this.lockMarginBetween, 0, 17, 6, 10);
                }
            }
            int itemX = this.x + this.leftItemMargin;
            int itemY = this.y + this.marginBetweenItems + i * this.fontHeight + i * this.marginBetweenItems;
            String text = "";
            text = this.fontRendererObj.func_78269_a(this.items.get(temp), this.width - this.lockWidth - 12);
            if (!text.equals(this.items.get(temp))) {
                text = text.substring(0, text.length() - 2) + "..";
            }
            this.fontRendererObj.func_78276_b(text, itemX, itemY, Color.BLACK.getRGB());
            ++temp;
        }
    }

    public void onMouseClicked(int x, int y) {
        this.isRealItemSelected = false;
        int itemNr = y / (this.marginBetweenItems + this.fontHeight);
        if (itemNr + 1 > this.maxShownItems) {
            --itemNr;
        }
        this.selectedItem = itemNr;
        this.isItemSelected = true;
        if (this.selectedItem >= 0 && this.selectedItem < this.items.size()) {
            this.isRealItemSelected = true;
        }
        if (x >= this.width - this.lockWidth - 5 && x <= this.width && this.isRealItemSelected) {
            this.changeLock();
        }
    }

    private void changeLock() {
        this.updateRealItemSelected();
        if (this.isRealItemSelected && this.selectedItem + this.listIndex < this.locks.size()) {
            boolean newLock = this.locks.get(this.selectedItem + this.listIndex) == false;
            this.locks.set(this.selectedItem + this.listIndex, newLock);
            ControlCraft.snw.sendToServer((IMessage)new ControlCenterSetLockPacket(this.frequencies.get(this.selectedItem + this.listIndex), newLock, this.blockX, this.blockY, this.blockZ, Minecraft.func_71410_x().field_71439_g.field_71093_bK));
        }
    }

    public boolean[] onBtnUp() {
        boolean[] states = new boolean[2];
        if (this.listIndex > 1) {
            --this.listIndex;
            states[0] = true;
            states[1] = true;
        } else if (this.listIndex == 1) {
            --this.listIndex;
            states[0] = false;
            states[1] = true;
        }
        this.isItemSelected = false;
        this.isRealItemSelected = false;
        return states;
    }

    public boolean[] onBtnDown() {
        boolean[] states = new boolean[2];
        if (this.listIndex + this.maxShownItems < this.items.size() - 1) {
            ++this.listIndex;
            states[0] = true;
            states[1] = true;
        } else if (this.listIndex + this.maxShownItems == this.items.size() - 1) {
            ++this.listIndex;
            states[0] = true;
            states[1] = false;
        }
        this.isItemSelected = false;
        this.isRealItemSelected = false;
        return states;
    }

    public boolean onBtnRemove() {
        if (this.isItemSelected) {
            int index = this.selectedItem + this.listIndex;
            if (index >= 0 && index < this.items.size()) {
                if (this.listIndex != 0) {
                    --this.listIndex;
                }
                this.items.remove(index);
                this.frequencies.remove(index);
                this.names.remove(index);
                this.locks.remove(index);
                ControlCraft.snw.sendToServer((IMessage)new ControlCenterItemRemovePacket(index));
                if (this.items.size() <= this.maxShownItems) {
                    return false;
                }
            }
            this.isRealItemSelected = this.selectedItem >= 0 && this.selectedItem < this.items.size();
        }
        return true;
    }

    public void updateRealItemSelected() {
        this.isRealItemSelected = this.selectedItem + this.listIndex >= 0 && this.selectedItem + this.listIndex < this.items.size();
    }

    public boolean getDownState() {
        return this.items.size() > this.maxShownItems;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public void addItem(String item) {
        this.items.add(item);
    }

    public void removeItem(int index) {
        this.items.remove(index);
    }

    public void removeItem(String item) {
        this.items.remove(item);
    }

    public String getItemAt(int index) {
        return this.items.get(index);
    }

    public int getSize() {
        return this.items.size();
    }

    public void setItemAt(int index, String item) {
        this.items.set(index, item);
    }

    public boolean getIsRealItemSelected() {
        return this.isRealItemSelected;
    }

    public int getSelectedItemIndex() {
        return this.selectedItem + this.listIndex;
    }

    public void addFrequency(int frequency) {
        this.frequencies.add(frequency);
    }

    public void addName(String name) {
        this.names.add(name);
    }

    public int getFrequency(int index) {
        if (index >= 0 && index < this.frequencies.size()) {
            return this.frequencies.get(index);
        }
        return 0;
    }

    public void removeFrequency(int index) {
        this.frequencies.remove(index);
    }

    public void removeName(int index) {
        this.names.remove(index);
    }

    public void addLock(boolean lock) {
        this.locks.add(lock);
    }

    public void setBlockX(int blockX) {
        this.blockX = blockX;
    }

    public void setBlockY(int blockY) {
        this.blockY = blockY;
    }

    public void setBlockZ(int blockZ) {
        this.blockZ = blockZ;
    }

    public void setLockByFrequency(int frequency, boolean lock) {
        int index;
        if (this.frequencies.contains(frequency) && (index = this.frequencies.indexOf(frequency)) < this.locks.size()) {
            this.locks.set(index, lock);
        }
    }

    public void removeLock(int index) {
        this.locks.remove(index);
    }

    public void clearSelection() {
        this.isItemSelected = false;
        this.isRealItemSelected = false;
    }
}

