/*
 * Decompiled with CFR 0.152.
 */
package at.stjubit.ControlCraft.tileentities;

import at.stjubit.ControlCraft.items.upgrades.ControlCenterRangeUpgrade;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class ControlCenterTileEntity
extends TileEntity
implements IInventory {
    List<Integer> frequencies = new ArrayList<Integer>();
    List<String> names = new ArrayList<String>();
    List<Boolean> redstonesignals = new ArrayList<Boolean>();
    List<Boolean> locks = new ArrayList<Boolean>();
    HashMap<Integer, Integer> ranges = new HashMap();
    ItemStack[] upgrades = new ItemStack[4];
    int facingSide;
    int securityIndex;
    String owner;

    public void markForUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        if (nbtTagCompound != null) {
            NBTTagCompound nbt;
            int i;
            this.facingSide = nbtTagCompound.func_74762_e("FacingSide");
            this.owner = nbtTagCompound.func_74779_i("Owner");
            this.securityIndex = nbtTagCompound.func_74762_e("SecurityIndex");
            NBTTagList nbtFrequencyList = nbtTagCompound.func_150295_c("FrequencyList", 10);
            NBTTagList nbtNameList = nbtTagCompound.func_150295_c("NameList", 10);
            NBTTagList nbtRedstonesignalList = nbtTagCompound.func_150295_c("RedstoneSignalList", 10);
            NBTTagList nbtUpgrades = nbtTagCompound.func_150295_c("ControlCenterUpgradeList", 10);
            NBTTagList nbtLocks = nbtTagCompound.func_150295_c("LocksList", 10);
            NBTTagList nbtRanges = nbtTagCompound.func_150295_c("RangeList", 10);
            if (nbtFrequencyList != null) {
                this.frequencies.clear();
                for (i = 0; i < nbtFrequencyList.func_74745_c(); ++i) {
                    nbt = nbtFrequencyList.func_150305_b(i);
                    if (nbt == null) continue;
                    int frequency = nbt.func_74762_e("FrequencyForList");
                    this.frequencies.add(frequency);
                }
            }
            if (nbtNameList != null) {
                this.names.clear();
                for (i = 0; i < nbtNameList.func_74745_c(); ++i) {
                    nbt = nbtNameList.func_150305_b(i);
                    if (nbt == null) continue;
                    String name = nbt.func_74779_i("NameForList");
                    this.names.add(name);
                }
            }
            if (nbtRedstonesignalList != null) {
                this.redstonesignals.clear();
                for (i = 0; i < nbtRedstonesignalList.func_74745_c(); ++i) {
                    nbt = nbtRedstonesignalList.func_150305_b(i);
                    if (nbt == null) continue;
                    boolean redstonesignal = nbt.func_74767_n("RedstonesignalForList");
                    this.redstonesignals.add(redstonesignal);
                }
            }
            if (nbtLocks != null) {
                this.locks.clear();
                for (i = 0; i < nbtLocks.func_74745_c(); ++i) {
                    nbt = nbtLocks.func_150305_b(i);
                    if (nbt == null) continue;
                    boolean lock = nbt.func_74767_n("LockForList");
                    this.locks.add(lock);
                }
            }
            if (nbtUpgrades != null) {
                this.upgrades = new ItemStack[this.func_70302_i_()];
                for (i = 0; i < nbtUpgrades.func_74745_c(); ++i) {
                    ItemStack is;
                    nbt = nbtUpgrades.func_150305_b(i);
                    if (nbt == null) continue;
                    int slot = nbt.func_74762_e("ControlCenterUpgradeSlot");
                    this.upgrades[slot] = is = ItemStack.func_77949_a((NBTTagCompound)nbt);
                }
            }
            if (nbtRanges != null) {
                this.ranges.clear();
                for (i = 0; i < nbtRanges.func_74745_c(); ++i) {
                    nbt = nbtRanges.func_150305_b(i);
                    if (nbt == null) continue;
                    int frequency = nbt.func_74762_e("RangeFrequency");
                    int range = nbt.func_74762_e("Range");
                    this.ranges.putIfAbsent(frequency, range);
                }
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        NBTTagCompound nbtFrequency;
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("FacingSide", this.facingSide);
        nbtTagCompound.func_74778_a("Owner", this.owner);
        nbtTagCompound.func_74768_a("SecurityIndex", this.securityIndex);
        NBTTagList nbtFrequencyList = new NBTTagList();
        NBTTagList nbtNameList = new NBTTagList();
        NBTTagList nbtRedstoneSignalList = new NBTTagList();
        NBTTagList nbtLocksList = new NBTTagList();
        NBTTagList nbtUpgrades = new NBTTagList();
        NBTTagList nbtRanges = new NBTTagList();
        Iterator<Object> iterator = this.frequencies.iterator();
        while (iterator.hasNext()) {
            int frequency = iterator.next();
            nbtFrequency = new NBTTagCompound();
            nbtFrequency.func_74768_a("FrequencyForList", frequency);
            nbtFrequencyList.func_74742_a((NBTBase)nbtFrequency);
        }
        for (String name : this.names) {
            nbtFrequency = new NBTTagCompound();
            nbtFrequency.func_74778_a("NameForList", name);
            nbtNameList.func_74742_a((NBTBase)nbtFrequency);
        }
        iterator = this.redstonesignals.iterator();
        while (iterator.hasNext()) {
            boolean redstonesignal = (Boolean)iterator.next();
            NBTTagCompound nbtRedstonesignal = new NBTTagCompound();
            nbtRedstonesignal.func_74757_a("RedstonesignalForList", redstonesignal);
            nbtRedstoneSignalList.func_74742_a((NBTBase)nbtRedstonesignal);
        }
        iterator = this.locks.iterator();
        while (iterator.hasNext()) {
            boolean lock = (Boolean)iterator.next();
            NBTTagCompound nbtLock = new NBTTagCompound();
            nbtLock.func_74757_a("LockForList", lock);
            nbtLocksList.func_74742_a((NBTBase)nbtLock);
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.upgrades[i] == null) continue;
            NBTTagCompound nbtItemStack = new NBTTagCompound();
            nbtItemStack.func_74768_a("ControlCenterUpgradeSlot", i);
            this.upgrades[i].func_77955_b(nbtItemStack);
            nbtUpgrades.func_74742_a((NBTBase)nbtItemStack);
        }
        for (int frequency : this.frequencies) {
            if (!this.ranges.containsKey(frequency)) continue;
            NBTTagCompound nbtRange = new NBTTagCompound();
            nbtRange.func_74768_a("RangeFrequency", frequency);
            nbtRange.func_74768_a("Range", this.ranges.get(frequency).intValue());
            nbtRanges.func_74742_a((NBTBase)nbtRange);
        }
        nbtTagCompound.func_74782_a("FrequencyList", (NBTBase)nbtFrequencyList);
        nbtTagCompound.func_74782_a("NameList", (NBTBase)nbtNameList);
        nbtTagCompound.func_74782_a("RedstoneSignalList", (NBTBase)nbtRedstoneSignalList);
        nbtTagCompound.func_74782_a("LocksList", (NBTBase)nbtLocksList);
        nbtTagCompound.func_74782_a("ControlCenterUpgradeList", (NBTBase)nbtUpgrades);
        nbtTagCompound.func_74782_a("RangeList", (NBTBase)nbtRanges);
    }

    public void addFrequency(int frequency) {
        this.frequencies.add(frequency);
        this.markForUpdate();
    }

    public void addName(String name) {
        this.names.add(name);
        this.markForUpdate();
    }

    public void addRedstoneSignal(boolean redstonesignal) {
        this.redstonesignals.add(redstonesignal);
        this.markForUpdate();
    }

    public void setRange(int frequency, int range) {
        this.ranges.put(frequency, range);
        this.markForUpdate();
    }

    public void removeFrequency(int index) {
        if (index < this.frequencies.size()) {
            this.frequencies.remove(index);
            this.markForUpdate();
        }
    }

    public void removeName(int index) {
        if (index < this.names.size()) {
            this.names.remove(index);
            this.markForUpdate();
        }
    }

    public void removeRedstoneSignal(int index) {
        if (index < this.redstonesignals.size()) {
            this.redstonesignals.remove(index);
            this.markForUpdate();
        }
    }

    public void removeRange(int frequency) {
        this.ranges.remove(frequency);
        this.markForUpdate();
    }

    public void changeRedstoneSignal(int index) {
        this.redstonesignals.set(index, this.redstonesignals.get(index) == false);
    }

    public List<Integer> getFrequencies() {
        return this.frequencies;
    }

    public List<String> getNames() {
        return this.names;
    }

    public List<Boolean> getRedstonesignals() {
        return this.redstonesignals;
    }

    public HashMap<Integer, Integer> getRanges() {
        return this.ranges;
    }

    public int getFrequency(int index) {
        return this.frequencies.get(index);
    }

    public boolean getRedstonesignal(int index) {
        return this.redstonesignals.get(index);
    }

    public void changeRedstoneSignalByFrequency(int frequency, boolean redstonesignal) {
        for (int i = 0; i < this.frequencies.size(); ++i) {
            if (this.frequencies.get(i) != frequency) continue;
            this.redstonesignals.set(i, redstonesignal);
            break;
        }
    }

    public boolean containsRange(int frequency) {
        return this.ranges.containsKey(frequency);
    }

    public int getRangeByFrequency(int frequency) {
        return this.ranges.get(frequency);
    }

    public int func_70302_i_() {
        return this.upgrades.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.upgrades[index];
    }

    public ItemStack func_70298_a(int index, int amt) {
        ItemStack is = this.upgrades[index];
        if (is != null) {
            if (is.field_77994_a > amt) {
                is = is.func_77979_a(amt);
                if (is.field_77994_a == 0) {
                    this.func_70299_a(index, null);
                }
            } else {
                this.func_70299_a(index, null);
            }
        }
        return is;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack is = this.upgrades[index];
        if (is != null) {
            this.func_70299_a(index, null);
        }
        return is;
    }

    public void func_70299_a(int index, ItemStack is) {
        this.upgrades[index] = is;
        if (is != null && is.field_77994_a >= this.func_70297_j_()) {
            is.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "ControlCenterUpgradeInventory";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack is) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer ep) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && ep.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public boolean hasRangeUpgrade() {
        for (ItemStack upgrade : this.upgrades) {
            if (upgrade == null || !(upgrade.func_77973_b() instanceof ControlCenterRangeUpgrade)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFrequency(int frequency) {
        return this.frequencies.contains(frequency);
    }

    public boolean getRedstonesignalByFrequency(int frequency) {
        if (this.frequencies.contains(frequency)) {
            return this.redstonesignals.get(this.frequencies.indexOf(frequency));
        }
        return false;
    }

    public boolean getLockByFrequency(int frequency) {
        if (this.frequencies.contains(frequency)) {
            return this.locks.get(this.frequencies.indexOf(frequency));
        }
        return false;
    }

    public void setFacingSide(int facingSide) {
        this.facingSide = facingSide;
        this.markForUpdate();
    }

    public int getFacingSide() {
        return this.facingSide;
    }

    public void setOwner(UUID owner) {
        this.owner = owner.toString();
        this.markForUpdate();
    }

    public UUID getOwner() {
        return UUID.fromString(this.owner);
    }

    public int getSecurityIndex() {
        return this.securityIndex;
    }

    public void setSecurityIndex(int securityIndex) {
        this.securityIndex = securityIndex;
        this.markForUpdate();
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("FacingSide", this.facingSide);
        nbt.func_74778_a("Owner", this.owner);
        nbt.func_74768_a("SecurityIndex", this.securityIndex);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.facingSide = nbt.func_74762_e("FacingSide");
        this.owner = nbt.func_74779_i("Owner");
        this.securityIndex = nbt.func_74762_e("SecurityIndex");
    }

    public List<Boolean> getLocks() {
        return this.locks;
    }

    public void addLock(boolean lock) {
        this.locks.add(lock);
        this.markForUpdate();
    }

    public void setLock(int frequency, boolean lock) {
        int index;
        if (this.frequencies.contains(frequency) && (index = this.frequencies.indexOf(frequency)) < this.locks.size()) {
            this.locks.set(index, lock);
        }
    }

    public Collection<? extends Integer> getLockedFrequencies() {
        ArrayList<Integer> lockedFrequencies = new ArrayList<Integer>();
        for (int i = 0; i < this.locks.size(); ++i) {
            if (!this.locks.get(i).booleanValue()) continue;
            lockedFrequencies.add(this.frequencies.get(i));
        }
        return lockedFrequencies;
    }

    public void removeLock(int id) {
        if (id < this.locks.size()) {
            this.locks.remove(id);
            this.markForUpdate();
        }
    }

    public boolean isFrequencyLocked(int frequency) {
        if (this.frequencies.contains(frequency)) {
            int index = this.frequencies.indexOf(frequency);
            return this.locks.get(index);
        }
        return false;
    }

    public int getIndexOfFrequency(int frequency) {
        return this.frequencies.indexOf(frequency);
    }
}

