/*
 * Decompiled with CFR 0.152.
 */
package at.stjubit.ControlCraft.tileentities;

import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class WirelessReceiverTileEntity
extends TileEntity {
    int frequency;
    boolean redstonesignal;
    int range;
    int facingSide;
    int[] sideConfigSignals = new int[6];
    int securityIndex;
    String owner;

    public void setFrequency(int frequency) {
        this.frequency = frequency;
        this.markForUpdate();
    }

    public int getFrequency() {
        return this.frequency;
    }

    public boolean isRedstonesignal(int direction) {
        if (!this.redstonesignal) {
            return false;
        }
        switch (direction) {
            case 3: {
                return this.sideConfigSignals[this.getNorthSide()] == 0;
            }
            case 4: {
                return this.sideConfigSignals[this.getEastSide()] == 0;
            }
            case 2: {
                return this.sideConfigSignals[this.getSouthSide()] == 0;
            }
            case 5: {
                return this.sideConfigSignals[this.getWestSide()] == 0;
            }
        }
        return false;
    }

    public int getNorthSide() {
        switch (this.facingSide) {
            case 2: {
                return 0;
            }
            case 3: {
                return 4;
            }
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
        }
        return -1;
    }

    public int getEastSide() {
        switch (this.facingSide) {
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
            case 0: {
                return 4;
            }
            case 1: {
                return 2;
            }
        }
        return -1;
    }

    public int getSouthSide() {
        switch (this.facingSide) {
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
        }
        return -1;
    }

    public int getWestSide() {
        switch (this.facingSide) {
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
            case 0: {
                return 3;
            }
            case 1: {
                return 0;
            }
        }
        return -1;
    }

    public void setRedstonesignal(boolean redstonesignal) {
        this.redstonesignal = redstonesignal;
        this.markForUpdate();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
    }

    public void setRange(int range) {
        this.range = range;
        this.markForUpdate();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
    }

    public int getRange() {
        return this.range;
    }

    public int getFacingSide() {
        return this.facingSide;
    }

    public int getSignalBySide(int side) {
        return this.sideConfigSignals[side];
    }

    public void setSignalBySide(int side, int signal) {
        this.sideConfigSignals[side] = signal;
        this.markForUpdate();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
    }

    public void setFacingSide(int facingSide) {
        this.facingSide = facingSide;
        this.markForUpdate();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
    }

    public int getSecurityIndex() {
        return this.securityIndex;
    }

    public void setSecurityIndex(int securityIndex) {
        this.securityIndex = securityIndex;
        this.markForUpdate();
    }

    public void setOwner(UUID owner) {
        this.owner = owner.toString();
        this.markForUpdate();
    }

    public UUID getOwner() {
        return UUID.fromString(this.owner);
    }

    public void markForUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("Frequency", this.frequency);
        nbtTagCompound.func_74757_a("Redstonesignal", this.redstonesignal);
        nbtTagCompound.func_74768_a("Range", this.range);
        nbtTagCompound.func_74768_a("FacingSide", this.facingSide);
        nbtTagCompound.func_74783_a("SideSignals", this.sideConfigSignals);
        nbtTagCompound.func_74768_a("SecurityIndex", this.securityIndex);
        nbtTagCompound.func_74778_a("Owner", this.owner);
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.frequency = nbtTagCompound.func_74762_e("Frequency");
        this.redstonesignal = nbtTagCompound.func_74767_n("Redstonesignal");
        this.range = nbtTagCompound.func_74762_e("Range");
        this.facingSide = nbtTagCompound.func_74762_e("FacingSide");
        this.sideConfigSignals = nbtTagCompound.func_74759_k("SideSignals");
        this.securityIndex = nbtTagCompound.func_74762_e("SecurityIndex");
        this.owner = nbtTagCompound.func_74779_i("Owner");
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("FacingSide", this.facingSide);
        nbt.func_74783_a("SideSignals", this.sideConfigSignals);
        nbt.func_74757_a("Redstonesignal", this.redstonesignal);
        nbt.func_74778_a("Owner", this.owner);
        nbt.func_74768_a("SecurityIndex", this.securityIndex);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.facingSide = nbt.func_74762_e("FacingSide");
        this.sideConfigSignals = nbt.func_74759_k("SideSignals");
        this.redstonesignal = nbt.func_74767_n("Redstonesignal");
        this.owner = nbt.func_74779_i("Owner");
        this.securityIndex = nbt.func_74762_e("SecurityIndex");
    }

    public boolean isRedstonesignalOn() {
        return this.redstonesignal;
    }
}

