/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.oc2.client.gui.AbstractMachineTerminalScreen;
import li.cil.oc2.client.gui.Sprites;
import li.cil.oc2.client.gui.terminal.TerminalInput;
import li.cil.oc2.common.container.AbstractMachineTerminalContainer;
import li.cil.oc2.common.vm.Terminal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public final class MachineTerminalWidget {
    private static final int TERMINAL_WIDTH = 320;
    private static final int TERMINAL_HEIGHT = 192;
    private static final int MARGIN_SIZE = 8;
    private static final int TERMINAL_X = 8;
    private static final int TERMINAL_Y = 8;
    public static final int WIDTH = Sprites.TERMINAL_SCREEN.width;
    public static final int HEIGHT = Sprites.TERMINAL_SCREEN.height;
    private final AbstractMachineTerminalScreen<?> parent;
    private final AbstractMachineTerminalContainer container;
    private final Terminal terminal;
    private int leftPos;
    private int topPos;
    private boolean isMouseOverTerminal;
    private Terminal.RendererView rendererView;

    public MachineTerminalWidget(AbstractMachineTerminalScreen<?> parent) {
        this.parent = parent;
        this.container = (AbstractMachineTerminalContainer)this.parent.m_6262_();
        this.terminal = this.container.getTerminal();
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY) {
        this.isMouseOverTerminal = this.isMouseOverTerminal(mouseX, mouseY);
        Sprites.TERMINAL_SCREEN.draw(graphics, this.leftPos, this.topPos);
        if (this.shouldCaptureInput()) {
            Sprites.TERMINAL_FOCUSED.draw(graphics, this.leftPos, this.topPos);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, @Nullable Component error) {
        if (this.container.getVirtualMachine().isRunning()) {
            PoseStack terminalStack = new PoseStack();
            terminalStack.m_252880_((float)(this.leftPos + 8), (float)(this.topPos + 8), 0.0f);
            terminalStack.m_85841_(320.0f / (float)this.terminal.getWidth(), 192.0f / (float)this.terminal.getHeight(), 1.0f);
            if (this.rendererView == null) {
                this.rendererView = this.terminal.getRenderer();
            }
            Matrix4f projectionMatrix = new Matrix4f().setOrtho(0.0f, (float)this.parent.f_96543_, (float)this.parent.f_96544_, 0.0f, -10.0f, 10.0f);
            this.rendererView.render(terminalStack, projectionMatrix);
        } else {
            Font font = this.getClient().f_91062_;
            if (error != null) {
                int textWidth = font.m_92852_((FormattedText)error);
                int textOffsetX = (320 - textWidth) / 2;
                Objects.requireNonNull(font);
                int textOffsetY = (192 - 9) / 2;
                this.drawShadow(font, graphics, error, this.leftPos + 8 + textOffsetX, this.topPos + 8 + textOffsetY, 0xEE3322);
            }
        }
    }

    private void drawShadow(Font font, GuiGraphics graphics, Component text, float x, float y, int color) {
        MultiBufferSource.BufferSource batch = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_272077_(text, x, y, color, true, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)batch, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        batch.m_109911_();
    }

    private static Matrix4f orthographic(float pMinX, float pMaxX, float pMinY, float pMaxY, float pMinZ, float pMaxZ) {
        Matrix4f matrix4f = new Matrix4f();
        float f = pMaxX - pMinX;
        float f1 = pMinY - pMaxY;
        float f2 = pMaxZ - pMinZ;
        matrix4f.set(2.0f / f, 0.0f, 0.0f, -(pMaxX + pMinX) / f, 0.0f, 2.0f / f1, 0.0f, -(pMinY + pMaxY) / f1, 0.0f, 0.0f, -2.0f / f2, -(pMaxZ + pMinZ) / f2, 0.0f, 0.0f, 0.0f, 1.0f);
        return matrix4f;
    }

    public void tick() {
        ByteBuffer input = this.terminal.getInput();
        if (input != null) {
            this.container.sendTerminalInputToServer(input);
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        int mx = (int)x;
        int my = (int)y;
        int sx = (int)((x - 8.0) / 320.0 * 80.0);
        int sy = (int)((y - 8.0) / 192.0 * 24.0);
        boolean overTerminal = this.isMouseOverTerminal(mx, my);
        if (overTerminal && this.shouldCaptureInput()) {
            this.terminal.putInput((byte)27);
            this.terminal.putInput((byte)91);
            this.terminal.putInput((byte)button);
            this.terminal.putInput((byte)sx);
            this.terminal.putInput((byte)sy);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double x, double y, int button) {
        int mx = (int)x;
        int my = (int)y;
        int sx = (int)((x - 8.0) / 320.0 * 80.0);
        int sy = (int)((y - 8.0) / 192.0 * 24.0);
        boolean overTerminal = this.isMouseOverTerminal(mx, my);
        if (overTerminal && this.shouldCaptureInput()) {
            this.terminal.putInput((byte)27);
            this.terminal.putInput((byte)91);
            this.terminal.putInput((byte)3);
            this.terminal.putInput((byte)sx);
            this.terminal.putInput((byte)sy);
            return true;
        }
        return false;
    }

    public boolean charTyped(char ch, int modifier) {
        if (modifier == 0 || modifier == 1) {
            this.terminal.putInput((byte)ch);
        }
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        block4: {
            block3: {
                if (!this.shouldCaptureInput() && keyCode == 256) {
                    return false;
                }
                if ((modifiers & 2) == 0 || keyCode != 86) break block3;
                String value = this.getClient().f_91068_.m_90876_();
                for (char ch : value.toCharArray()) {
                    this.terminal.putInput((byte)ch);
                }
                break block4;
            }
            byte[] sequence = TerminalInput.getSequence(keyCode, modifiers);
            if (sequence == null) break block4;
            for (byte b : sequence) {
                this.terminal.putInput(b);
            }
        }
        return true;
    }

    public void init() {
        this.leftPos = (this.parent.f_96543_ - WIDTH) / 2;
        this.topPos = (this.parent.f_96544_ - HEIGHT) / 2;
    }

    public void onClose() {
        if (this.rendererView != null) {
            this.terminal.releaseRenderer(this.rendererView);
            this.rendererView = null;
        }
    }

    private Minecraft getClient() {
        return this.parent.getMinecraft();
    }

    private boolean shouldCaptureInput() {
        return this.isMouseOverTerminal && AbstractMachineTerminalScreen.isInputCaptureEnabled() && this.container.getVirtualMachine().isRunning();
    }

    private boolean isMouseOverTerminal(int mouseX, int mouseY) {
        return this.parent.isMouseOver(mouseX, mouseY, 8, 8, 320, 192);
    }
}

