/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui.terminal;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import javax.annotation.Nullable;

public final class TerminalInput {
    private static final Int2ObjectArrayMap<Int2ObjectArrayMap<byte[]>> KEYCODE_SEQUENCES = new Int2ObjectArrayMap();

    @Nullable
    public static byte[] getSequence(int keyCode) {
        return TerminalInput.getSequence(keyCode, 0);
    }

    @Nullable
    public static byte[] getSequence(int keyCode, int modifiers) {
        Int2ObjectArrayMap map = (Int2ObjectArrayMap)KEYCODE_SEQUENCES.get(modifiers);
        if (map == null) {
            return null;
        }
        return (byte[])map.get(keyCode);
    }

    private static void addSequence(int keyCode, char ch) {
        TerminalInput.addSequence(keyCode, (byte)ch);
    }

    private static void addSequence(int keyCode, byte ... sequence) {
        TerminalInput.addSequence(0, keyCode, sequence);
    }

    private static void addSequence(int keyCode, String sequence) {
        TerminalInput.addSequence(0, keyCode, sequence);
    }

    private static void addSequence(int modifiers, int keyCode, String sequence) {
        byte[] bytes = new byte[sequence.length()];
        char[] chars = sequence.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        TerminalInput.addSequence(modifiers, keyCode, bytes);
    }

    private static void addSequence(int modifiers, int keyCode, byte ... sequence) {
        ((Int2ObjectArrayMap)KEYCODE_SEQUENCES.computeIfAbsent(modifiers, i -> new Int2ObjectArrayMap())).put(keyCode, (Object)sequence);
    }

    static {
        TerminalInput.addSequence(257, '\r');
        TerminalInput.addSequence(258, '\t');
        TerminalInput.addSequence(259, '\b');
        TerminalInput.addSequence(256, "\u001b");
        TerminalInput.addSequence(268, "\u001b[1~");
        TerminalInput.addSequence(260, "\u001b[2~");
        TerminalInput.addSequence(261, "\u001b[3~");
        TerminalInput.addSequence(269, "\u001b[4~");
        TerminalInput.addSequence(266, "\u001b[5~");
        TerminalInput.addSequence(267, "\u001b[6~");
        TerminalInput.addSequence(290, "\u001b[11~");
        TerminalInput.addSequence(291, "\u001b[12~");
        TerminalInput.addSequence(292, "\u001b[13~");
        TerminalInput.addSequence(293, "\u001b[14~");
        TerminalInput.addSequence(294, "\u001b[15~");
        TerminalInput.addSequence(295, "\u001b[17~");
        TerminalInput.addSequence(296, "\u001b[18~");
        TerminalInput.addSequence(297, "\u001b[19~");
        TerminalInput.addSequence(298, "\u001b[20~");
        TerminalInput.addSequence(299, "\u001b[21~");
        TerminalInput.addSequence(300, "\u001b[23~");
        TerminalInput.addSequence(301, "\u001b[24~");
        TerminalInput.addSequence(265, "\u001b[A");
        TerminalInput.addSequence(264, "\u001b[B");
        TerminalInput.addSequence(262, "\u001b[C");
        TerminalInput.addSequence(263, "\u001b[D");
        for (int i = 65; i <= 90; ++i) {
            TerminalInput.addSequence(2, 65 + (i - 65), (byte)(1 + i - 65));
            TerminalInput.addSequence(3, 65 + (i - 65), (byte)(1 + i - 65));
            TerminalInput.addSequence(4, 65 + (i - 65), 27, (byte)(97 + i - 65));
            TerminalInput.addSequence(5, 65 + (i - 65), 27, (byte)(i + 128));
        }
        TerminalInput.addSequence(2, 91, 27);
        TerminalInput.addSequence(3, 91, 27);
        TerminalInput.addSequence(2, 92, 28);
        TerminalInput.addSequence(3, 92, 28);
        TerminalInput.addSequence(2, 93, 29);
        TerminalInput.addSequence(3, 93, 29);
    }
}

