/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.block;

import java.util.List;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.api.capabilities.RedstoneEmitter;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.ComputerBlockEntity;
import li.cil.oc2.common.blockentity.TickableBlockEntity;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.integration.Wrenches;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.util.NBTUtils;
import li.cil.oc2.common.util.TooltipUtils;
import li.cil.oc2.common.util.TranslationUtils;
import li.cil.oc2.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ComputerBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private static final VoxelShape NEG_Z_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)1.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0), Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0)});
    private static final VoxelShape NEG_X_SHAPE = VoxelShapeUtils.rotateHorizontalClockwise(NEG_Z_SHAPE);
    private static final VoxelShape POS_Z_SHAPE = VoxelShapeUtils.rotateHorizontalClockwise(NEG_X_SHAPE);
    private static final VoxelShape POS_X_SHAPE = VoxelShapeUtils.rotateHorizontalClockwise(POS_Z_SHAPE);

    public ComputerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60913_(1.5f, 6.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag advanced) {
        super.m_5871_(stack, level, tooltip, advanced);
        TooltipUtils.addEnergyConsumption(Config.computerEnergyPerTick, tooltip);
        TooltipUtils.addBlockEntityInventoryInformation(stack, tooltip);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null) {
            return blockEntity.getCapability(Capabilities.redstoneEmitter(), side.m_122424_()).map(RedstoneEmitter::getRedstoneOutput).orElse(0);
        }
        return super.m_6378_(state, level, pos, side);
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return this.m_6378_(state, level, pos, side);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block changedBlock, BlockPos changedBlockPos, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ComputerBlockEntity) {
            ComputerBlockEntity computer = (ComputerBlockEntity)blockEntity;
            computer.handleNeighborChanged();
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.NORTH -> NEG_Z_SHAPE;
            case Direction.SOUTH -> POS_Z_SHAPE;
            case Direction.WEST -> NEG_X_SHAPE;
            default -> POS_X_SHAPE;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof ComputerBlockEntity)) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        ComputerBlockEntity computer = (ComputerBlockEntity)blockEntity;
        ItemStack heldItem = player.m_21120_(hand);
        if (Wrenches.isWrench(heldItem)) {
            if (!player.m_6144_()) {
                if (!level.m_5776_() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    computer.openInventoryScreen(serverPlayer);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        } else {
            if (!level.m_5776_()) {
                if (player.m_6144_()) {
                    computer.start();
                } else if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    computer.openTerminalScreen(serverPlayer);
                }
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        ComputerBlockEntity computer;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!level.m_5776_() && blockEntity instanceof ComputerBlockEntity && !(computer = (ComputerBlockEntity)blockEntity).getItemStackHandlers().isEmpty()) {
            computer.getItemStackHandlers().exportDeviceDataToItemStacks();
            if (player.m_7500_()) {
                ItemStack stack = new ItemStack((ItemLike)Items.COMPUTER.get());
                computer.exportToItemStack(stack);
                ComputerBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntities.COMPUTER.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TickableBlockEntity.createTicker(level, type, (BlockEntityType)BlockEntities.COMPUTER.get());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_});
    }

    public static ItemStack getComputerWithFlash() {
        ItemStack computer = new ItemStack((ItemLike)Items.COMPUTER.get());
        CompoundTag itemsTag = NBTUtils.getOrCreateChildTag(computer.m_41784_(), "BlockEntityTag", "items");
        itemsTag.m_128365_(DeviceTypes.FLASH_MEMORY.getName().toString(), (Tag)NBTUtils.makeInventoryTag(new ItemStack((ItemLike)Items.FLASH_MEMORY_CUSTOM.get())));
        return computer;
    }

    public static ItemStack getPreconfiguredComputer() {
        ItemStack computer = ComputerBlock.getComputerWithFlash();
        CompoundTag itemsTag = NBTUtils.getOrCreateChildTag(computer.m_41784_(), "BlockEntityTag", "items");
        itemsTag.m_128365_(DeviceTypes.MEMORY.getName().toString(), (Tag)NBTUtils.makeInventoryTag(new ItemStack((ItemLike)Items.MEMORY_LARGE.get()), new ItemStack((ItemLike)Items.MEMORY_LARGE.get()), new ItemStack((ItemLike)Items.MEMORY_LARGE.get()), new ItemStack((ItemLike)Items.MEMORY_LARGE.get())));
        itemsTag.m_128365_(DeviceTypes.HARD_DRIVE.getName().toString(), (Tag)NBTUtils.makeInventoryTag(new ItemStack((ItemLike)Items.HARD_DRIVE_CUSTOM.get())));
        itemsTag.m_128365_(DeviceTypes.CARD.getName().toString(), (Tag)NBTUtils.makeInventoryTag(new ItemStack((ItemLike)Items.NETWORK_INTERFACE_CARD.get())));
        itemsTag.m_128365_(DeviceTypes.CPU.getName().toString(), (Tag)NBTUtils.makeInventoryTag(new ItemStack((ItemLike)Items.CPU_TIER_3.get())));
        computer.m_41714_((Component)TranslationUtils.text("block.{mod}.computer.preconfigured"));
        return computer;
    }
}

