/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.block;

import javax.annotation.Nullable;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.block.EnergyConsumingBlock;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.TickableBlockEntity;
import li.cil.oc2.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class ProjectorBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
EnergyConsumingBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private static final VoxelShape NEG_Z_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.125, (double)0.0625, (double)0.375, (double)0.875), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.9375, (double)0.125, (double)0.125, (double)1.0, (double)0.375, (double)0.875), Shapes.m_83048_((double)0.25, (double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.125)}), (a, b) -> a && !b);
    private static final VoxelShape NEG_X_SHAPE = VoxelShapeUtils.rotateHorizontalClockwise(NEG_Z_SHAPE);
    private static final VoxelShape POS_Z_SHAPE = VoxelShapeUtils.rotateHorizontalClockwise(NEG_X_SHAPE);
    private static final VoxelShape POS_X_SHAPE = VoxelShapeUtils.rotateHorizontalClockwise(POS_Z_SHAPE);

    public ProjectorBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60953_(state -> (Boolean)state.m_61143_((Property)LIT) != false ? 8 : 0).m_60913_(1.5f, 6.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public int getEnergyConsumption() {
        if (Config.projectorsUseEnergy()) {
            return Config.projectorEnergyPerTick;
        }
        return 0;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntities.PROJECTOR.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TickableBlockEntity.createServerTicker(level, type, (BlockEntityType)BlockEntities.PROJECTOR.get());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.NORTH -> NEG_Z_SHAPE;
            case Direction.SOUTH -> POS_Z_SHAPE;
            case Direction.WEST -> NEG_X_SHAPE;
            default -> POS_X_SHAPE;
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, LIT});
    }
}

