/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.blockentity;

import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc2.common.block.FlashMemoryFlasherBlock;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.ModBlockEntity;
import li.cil.oc2.common.bus.device.vm.block.FlashMemoryFlasherContainer;
import li.cil.oc2.common.bus.device.vm.block.FlashMemoryFlasherDevice;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.container.TypedItemStackHandler;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.FirmwareFlasherMessage;
import li.cil.oc2.common.tags.ItemTags;
import li.cil.oc2.common.util.ItemStackUtils;
import li.cil.oc2.common.util.LocationSupplierUtils;
import li.cil.oc2.common.util.SoundEvents;
import li.cil.oc2.common.util.ThrottledSoundEmitter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class FlashMemoryFlasherBlockEntity
extends ModBlockEntity
implements FlashMemoryFlasherContainer {
    private static final String DATA_TAG_NAME = "data";
    private final FlashMemoryItemStackHandler itemHandler = new FlashMemoryItemStackHandler();
    private final FlashMemoryFlasherDevice<FlashMemoryFlasherBlockEntity> device = new FlashMemoryFlasherDevice<FlashMemoryFlasherBlockEntity>(this);
    private final ThrottledSoundEmitter accessSoundEmitter = new ThrottledSoundEmitter(LocationSupplierUtils.of(this), (SoundEvent)SoundEvents.FLOPPY_ACCESS.get()).withMinInterval(Duration.ofSeconds(1L));
    private final ThrottledSoundEmitter insertSoundEmitter = new ThrottledSoundEmitter(LocationSupplierUtils.of(this), (SoundEvent)SoundEvents.FLOPPY_INSERT.get()).withMinInterval(Duration.ofMillis(100L));
    private final ThrottledSoundEmitter ejectSoundEmitter = new ThrottledSoundEmitter(LocationSupplierUtils.of(this), (SoundEvent)SoundEvents.FLOPPY_EJECT.get()).withMinInterval(Duration.ofMillis(100L));

    public FlashMemoryFlasherBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.FLASH_MEMORY_FLASHER.get(), pos, state);
    }

    public boolean canInsert(ItemStack stack) {
        return !stack.m_41619_() && stack.m_204117_(ItemTags.DEVICES_FLASH_MEMORY);
    }

    public ItemStack insert(ItemStack stack, @Nullable Player player) {
        if (!this.canInsert(stack)) {
            return stack;
        }
        this.eject(player);
        this.insertSoundEmitter.play();
        return this.itemHandler.insertItem(0, stack, false);
    }

    public boolean canEject() {
        return !this.itemHandler.extractItem(0, 1, true).m_41619_();
    }

    public void eject(@Nullable Player player) {
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack stack = this.itemHandler.extractItem(0, 1, false);
        if (!stack.m_41619_()) {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)FlashMemoryFlasherBlock.f_54117_);
            this.ejectSoundEmitter.play();
            ItemStackUtils.spawnAsEntity(this.f_58857_, this.m_58899_().m_121945_(facing), stack, facing).ifPresent(entity -> {
                if (player != null) {
                    entity.m_32061_();
                    entity.m_32052_(player.m_20148_());
                }
            });
        }
    }

    public ItemStack getFloppy() {
        return this.itemHandler.getStackInSlot(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setFlashMemory(ItemStack stack) {
        this.itemHandler.setStackInSlot(0, stack);
    }

    @Override
    protected void collectCapabilities(ModBlockEntity.CapabilityCollector collector, @Nullable Direction direction) {
        collector.offer(Capabilities.itemHandler(), this.itemHandler);
        if (direction == ((Direction)this.m_58900_().m_61143_((Property)FlashMemoryFlasherBlock.f_54117_)).m_122424_()) {
            collector.offer(Capabilities.device(), this.device);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_("items", (Tag)this.itemHandler.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("items"));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("items", (Tag)this.itemHandler.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("items"));
    }

    @Override
    public ItemStack getDiskItemStack() {
        return this.itemHandler.getStackInSlotRaw(0);
    }

    @Override
    public void handleDataAccess() {
        this.accessSoundEmitter.play();
    }

    private final class FlashMemoryItemStackHandler
    extends TypedItemStackHandler {
        public FlashMemoryItemStackHandler() {
            super(1, ItemTags.DEVICES_FLASH_MEMORY);
        }

        public ItemStack getStackInSlotRaw(int slot) {
            return super.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            ItemStack stack = this.getStackInSlotRaw(slot);
            this.exportDeviceDataToItemStack(stack);
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0 && !simulate && amount > 0) {
                this.exportDeviceDataToItemStack(this.getStackInSlotRaw(0));
            }
            return super.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public CompoundTag serializeNBT() {
            this.exportDeviceDataToItemStack(this.getStackInSlotRaw(0));
            return super.serializeNBT();
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (FlashMemoryFlasherBlockEntity.this.f_58857_ == null || FlashMemoryFlasherBlockEntity.this.f_58857_.m_5776_()) {
                return;
            }
            ItemStack stack = this.getStackInSlotRaw(slot);
            if (stack.m_41619_()) {
                FlashMemoryFlasherBlockEntity.this.device.removeBlockDevice();
            } else {
                CompoundTag tag = ItemStackUtils.getOrCreateModDataTag(stack).m_128469_(FlashMemoryFlasherBlockEntity.DATA_TAG_NAME);
                FlashMemoryFlasherBlockEntity.this.device.updateBlockDevice(tag);
            }
            Network.sendToClientsTrackingBlockEntity(new FirmwareFlasherMessage(FlashMemoryFlasherBlockEntity.this), FlashMemoryFlasherBlockEntity.this);
            FlashMemoryFlasherBlockEntity.this.m_6596_();
        }

        private void exportDeviceDataToItemStack(ItemStack stack) {
            if (stack.m_41619_()) {
                return;
            }
            if (FlashMemoryFlasherBlockEntity.this.f_58857_ == null || FlashMemoryFlasherBlockEntity.this.f_58857_.m_5776_()) {
                return;
            }
            CompoundTag tag = new CompoundTag();
            FlashMemoryFlasherBlockEntity.this.device.exportToItemStack(tag);
            ItemStackUtils.getOrCreateModDataTag(stack).m_128365_(FlashMemoryFlasherBlockEntity.DATA_TAG_NAME, (Tag)tag);
        }
    }
}

