/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.blockentity;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nullable;
import li.cil.oc2.api.capabilities.NetworkInterface;
import li.cil.oc2.client.renderer.NetworkCableRenderer;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.block.NetworkConnectorBlock;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.ModBlockEntity;
import li.cil.oc2.common.blockentity.TickableBlockEntity;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.NetworkConnectorConnectionsMessage;
import li.cil.oc2.common.util.ItemStackUtils;
import li.cil.oc2.common.util.LazyOptionalUtils;
import li.cil.oc2.common.util.ServerScheduler;
import li.cil.oc2.common.util.TickUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

public final class NetworkConnectorBlockEntity
extends ModBlockEntity
implements TickableBlockEntity {
    private static final String CONNECTIONS_TAG_NAME = "connections";
    private static final String IS_OWNER_TAG_NAME = "is_owner";
    private static final int RETRY_UNLOADED_CHUNK_INTERVAL = TickUtils.toTicks(Duration.ofSeconds(5L));
    private static final int MAX_CONNECTION_COUNT = 2;
    private static final int MAX_CONNECTION_DISTANCE = 16;
    private static final int BYTES_PER_TICK = 65536 / TickUtils.toTicks(Duration.ofSeconds(1L));
    private static final int MIN_ETHERNET_FRAME_SIZE = 42;
    private static final int TTL_COST = 1;
    private final NetworkConnectorNetworkInterface networkInterface = new NetworkConnectorNetworkInterface();
    private LazyOptional<NetworkInterface> adjacentInterface = LazyOptional.empty();
    private boolean isAdjacentInterfaceDirty = true;
    private final HashSet<BlockPos> connectorPositions = new HashSet();
    private final HashSet<BlockPos> ownedCables = new HashSet();
    private final HashSet<BlockPos> dirtyConnectors = new HashSet();
    private final HashMap<BlockPos, NetworkConnectorBlockEntity> connectors = new HashMap();

    public NetworkConnectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.NETWORK_CONNECTOR.get(), pos, state);
    }

    public static ConnectionResult connect(NetworkConnectorBlockEntity connectorA, NetworkConnectorBlockEntity connectorB) {
        ConnectionResult result;
        BlockPos posB;
        if (connectorA == connectorB || !connectorA.isValid() || !connectorB.isValid()) {
            return ConnectionResult.FAILURE;
        }
        Level level = connectorA.f_58857_;
        if (level == null || level.m_5776_()) {
            return ConnectionResult.FAILURE;
        }
        if (connectorB.f_58857_ != level) {
            return ConnectionResult.FAILURE;
        }
        if (!connectorA.canConnectMore() || !connectorB.canConnectMore()) {
            return ConnectionResult.FAILURE_FULL;
        }
        BlockPos posA = connectorA.m_58899_();
        if (!posA.m_123314_((Vec3i)(posB = connectorB.m_58899_()), 16.0)) {
            return ConnectionResult.FAILURE_TOO_FAR;
        }
        if (NetworkConnectorBlockEntity.isObstructed(level, posA, posB)) {
            return ConnectionResult.FAILURE_OBSTRUCTED;
        }
        if (connectorA.connectorPositions.add(posB)) {
            connectorA.dirtyConnectors.add(posB);
            connectorA.onConnectedPositionsChanged();
        }
        if (connectorB.connectorPositions.add(posA)) {
            connectorB.dirtyConnectors.add(posA);
            connectorB.onConnectedPositionsChanged();
        }
        if (connectorA.ownedCables.contains(posB) || connectorB.ownedCables.contains(posA)) {
            connectorA.ownedCables.add(posB);
            connectorB.ownedCables.remove(posA);
            result = ConnectionResult.ALREADY_CONNECTED;
        } else {
            connectorA.ownedCables.add(posB);
            result = ConnectionResult.SUCCESS;
        }
        connectorA.m_6596_();
        connectorB.m_6596_();
        return result;
    }

    public void disconnectFrom(BlockPos pos) {
        this.dirtyConnectors.remove(pos);
        this.connectors.remove(pos);
        if (this.ownedCables.remove(pos) && this.f_58857_ != null) {
            Vec3 middle = Vec3.m_82512_((Vec3i)this.m_58899_().m_121955_((Vec3i)pos)).m_82490_(0.5);
            ItemStackUtils.spawnAsEntity(this.f_58857_, middle, new ItemStack((ItemLike)Items.NETWORK_CABLE.get()));
        }
        if (this.isValid()) {
            if (this.connectorPositions.remove(pos)) {
                this.onConnectedPositionsChanged();
            }
            this.m_6596_();
        }
    }

    public boolean canConnectMore() {
        return this.connectorPositions.size() < 2;
    }

    public Collection<BlockPos> getConnectedPositions() {
        return this.connectorPositions;
    }

    public void setNeighborChanged() {
        this.isAdjacentInterfaceDirty = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setConnectedPositionsClient(ArrayList<BlockPos> positions) {
        this.connectorPositions.clear();
        this.connectorPositions.addAll(positions);
        NetworkCableRenderer.invalidateConnections();
    }

    @Override
    public void serverTick() {
        byte[] frame;
        if (this.f_58857_ == null) {
            return;
        }
        if (this.isAdjacentInterfaceDirty) {
            this.isAdjacentInterfaceDirty = false;
            this.resolveLocalInterface();
        }
        if (!this.dirtyConnectors.isEmpty()) {
            ArrayList<BlockPos> list = new ArrayList<BlockPos>(this.dirtyConnectors);
            this.dirtyConnectors.clear();
            for (BlockPos connectedPosition : list) {
                this.resolveConnectedInterface(connectedPosition);
            }
        }
        NetworkInterface source = (NetworkInterface)this.adjacentInterface.orElse((Object)NullNetworkInterface.INSTANCE);
        for (int byteBudget = BYTES_PER_TICK; (frame = source.readEthernetFrame()) != null && byteBudget > 0; byteBudget -= Math.max(frame.length, 42)) {
            this.networkInterface.writeEthernetFrame(source, frame, Config.ethernetFrameTimeToLive);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        ListTag connections = new ListTag();
        for (BlockPos position : this.connectorPositions) {
            CompoundTag connectionTag = NbtUtils.m_129224_((BlockPos)position);
            connections.add((Object)connectionTag);
        }
        tag.m_128365_(CONNECTIONS_TAG_NAME, (Tag)connections);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        ListTag connections = tag.m_128437_(CONNECTIONS_TAG_NAME, 10);
        for (int i = 0; i < Math.min(connections.size(), 2); ++i) {
            CompoundTag connectionTag = connections.m_128728_(i);
            BlockPos position = NbtUtils.m_129239_((CompoundTag)connectionTag);
            this.connectorPositions.add(position);
            this.dirtyConnectors.add(position);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag connections = new ListTag();
        for (BlockPos position : this.connectorPositions) {
            CompoundTag connectionTag = NbtUtils.m_129224_((BlockPos)position);
            if (this.ownedCables.contains(position)) {
                connectionTag.m_128379_(IS_OWNER_TAG_NAME, true);
            }
            connections.add((Object)connectionTag);
        }
        tag.m_128365_(CONNECTIONS_TAG_NAME, (Tag)connections);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ListTag connections = tag.m_128437_(CONNECTIONS_TAG_NAME, 10);
        for (int i = 0; i < Math.min(connections.size(), 2); ++i) {
            CompoundTag connectionTag = connections.m_128728_(i);
            BlockPos position = NbtUtils.m_129239_((CompoundTag)connectionTag);
            this.connectorPositions.add(position);
            this.dirtyConnectors.add(position);
            if (!connectionTag.m_128471_(IS_OWNER_TAG_NAME)) continue;
            this.ownedCables.add(position);
        }
    }

    public AABB getRenderBoundingBox() {
        if (Minecraft.m_91085_()) {
            return new AABB(this.m_58899_().m_7918_(-16, -16, -16), this.m_58899_().m_7918_(17, 17, 17));
        }
        return super.getRenderBoundingBox();
    }

    @Override
    protected void collectCapabilities(ModBlockEntity.CapabilityCollector collector, @Nullable Direction direction) {
        if (direction == NetworkConnectorBlock.getFacing(this.m_58900_()).m_122424_()) {
            collector.offer(Capabilities.networkInterface(), this.networkInterface);
        }
    }

    @Override
    protected void loadClient() {
        super.loadClient();
        NetworkCableRenderer.addNetworkConnector(this);
    }

    @Override
    protected void unloadServer(boolean isRemove) {
        super.unloadServer(isRemove);
        if (isRemove) {
            ArrayList<NetworkConnectorBlockEntity> list = new ArrayList<NetworkConnectorBlockEntity>(this.connectors.values());
            this.connectors.clear();
            for (NetworkConnectorBlockEntity connector : list) {
                this.disconnectFrom(connector.m_58899_());
                connector.disconnectFrom(this.m_58899_());
            }
        } else {
            BlockPos pos = this.m_58899_();
            for (NetworkConnectorBlockEntity connector : this.connectors.values()) {
                connector.connectors.remove(pos);
                if (!connector.connectorPositions.contains(pos)) continue;
                connector.dirtyConnectors.add(pos);
            }
        }
    }

    private void resolveLocalInterface() {
        assert (this.f_58857_ != null);
        this.adjacentInterface = LazyOptional.empty();
        if (!this.isValid()) {
            return;
        }
        Direction facing = NetworkConnectorBlock.getFacing(this.m_58900_());
        BlockPos sourcePos = this.m_58899_().m_121945_(facing.m_122424_());
        if (!this.f_58857_.m_46749_(sourcePos)) {
            ServerScheduler.schedule((LevelAccessor)this.f_58857_, this::setNeighborChanged, RETRY_UNLOADED_CHUNK_INTERVAL);
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(sourcePos);
        if (blockEntity == null) {
            return;
        }
        this.adjacentInterface = blockEntity.getCapability(Capabilities.networkInterface(), facing);
        if (this.adjacentInterface.isPresent()) {
            LazyOptionalUtils.addWeakListener(this.adjacentInterface, this, (connector, unused) -> connector.setNeighborChanged());
        }
    }

    private void resolveConnectedInterface(BlockPos connectedPosition) {
        this.connectors.remove(connectedPosition);
        if (!this.isValid()) {
            return;
        }
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        ChunkPos destinationChunk = new ChunkPos(connectedPosition);
        if (!this.f_58857_.m_7232_(destinationChunk.f_45578_, destinationChunk.f_45579_)) {
            ServerScheduler.schedule((LevelAccessor)this.f_58857_, () -> this.dirtyConnectors.add(connectedPosition), RETRY_UNLOADED_CHUNK_INTERVAL);
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(connectedPosition);
        if (!(blockEntity instanceof NetworkConnectorBlockEntity)) {
            this.disconnectFrom(connectedPosition);
            return;
        }
        NetworkConnectorBlockEntity networkConnector = (NetworkConnectorBlockEntity)blockEntity;
        if (!connectedPosition.m_123314_((Vec3i)this.m_58899_(), 16.0)) {
            this.disconnectFrom(connectedPosition);
            networkConnector.disconnectFrom(this.m_58899_());
            return;
        }
        if (NetworkConnectorBlockEntity.isObstructed(this.f_58857_, this.m_58899_(), connectedPosition)) {
            this.disconnectFrom(connectedPosition);
            networkConnector.disconnectFrom(this.m_58899_());
            return;
        }
        this.connectors.put(connectedPosition, networkConnector);
    }

    private static boolean isObstructed(Level level, BlockPos a, BlockPos b) {
        Vec3 va = Vec3.m_82512_((Vec3i)a);
        Vec3 vb = Vec3.m_82512_((Vec3i)b);
        Vec3 ab = vb.m_82546_(va).m_82541_().m_82490_(0.5);
        BlockHitResult hitAB = level.m_45547_(new ClipContext(va.m_82549_(ab), vb.m_82546_(ab), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        BlockHitResult hitBA = level.m_45547_(new ClipContext(vb.m_82546_(ab), va.m_82549_(ab), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        return hitAB.m_6662_() != HitResult.Type.MISS || hitBA.m_6662_() != HitResult.Type.MISS;
    }

    private void onConnectedPositionsChanged() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            NetworkConnectorConnectionsMessage message = new NetworkConnectorConnectionsMessage(this);
            Network.sendToClientsTrackingBlockEntity(message, this);
        }
    }

    private final class NetworkConnectorNetworkInterface
    implements NetworkInterface {
        private NetworkConnectorNetworkInterface() {
        }

        @Override
        public byte[] readEthernetFrame() {
            return null;
        }

        @Override
        public void writeEthernetFrame(NetworkInterface source, byte[] frame, int timeToLive) {
            if (timeToLive <= 0) {
                return;
            }
            NetworkConnectorBlockEntity.this.adjacentInterface.ifPresent(dst -> {
                if (dst == source) {
                    return;
                }
                dst.writeEthernetFrame(this, frame, timeToLive - 1);
            });
            for (NetworkConnectorBlockEntity dst2 : NetworkConnectorBlockEntity.this.connectors.values()) {
                if (!dst2.isValid() || dst2.networkInterface == source) continue;
                dst2.networkInterface.writeEthernetFrame(this, frame, timeToLive - 1);
            }
        }
    }

    public static enum ConnectionResult {
        SUCCESS,
        FAILURE,
        FAILURE_FULL,
        FAILURE_TOO_FAR,
        FAILURE_OBSTRUCTED,
        ALREADY_CONNECTED;

    }

    private static final class NullNetworkInterface
    implements NetworkInterface {
        public static final NetworkInterface INSTANCE = new NullNetworkInterface();

        private NullNetworkInterface() {
        }

        @Override
        public byte[] readEthernetFrame() {
            return null;
        }

        @Override
        public void writeEthernetFrame(NetworkInterface source, byte[] frame, int timeToLive) {
        }
    }
}

