/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.blockentity;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.annotation.Nullable;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.block.ProjectorBlock;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.ModBlockEntity;
import li.cil.oc2.common.blockentity.TickableBlockEntity;
import li.cil.oc2.common.bus.device.vm.block.ProjectorDevice;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.energy.FixedEnergyStorage;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.ProjectorLoadBalancer;
import li.cil.oc2.common.network.message.ProjectorRequestFramebufferMessage;
import li.cil.oc2.common.network.message.ProjectorStateMessage;
import li.cil.oc2.jcodec.codecs.h264.H264Decoder;
import li.cil.oc2.jcodec.codecs.h264.H264Encoder;
import li.cil.oc2.jcodec.codecs.h264.encode.CQPRateControl;
import li.cil.oc2.jcodec.common.model.ColorSpace;
import li.cil.oc2.jcodec.common.model.Picture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public final class ProjectorBlockEntity
extends ModBlockEntity
implements TickableBlockEntity {
    public static final int MAX_RENDER_DISTANCE = 16;
    public static final int MAX_GOOD_RENDER_DISTANCE = 12;
    public static final int MAX_WIDTH = 13;
    public static final int MAX_HEIGHT = 10;
    private static final String ENERGY_TAG_NAME = "energy";
    private static final String IS_PROJECTING_TAG_NAME = "projecting";
    private static final String HAS_ENERGY_TAG_NAME = "has_energy";
    private static final ExecutorService DECODER_WORKERS = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setName("Projector Frame Decoder");
        return thread;
    });
    private final ProjectorDevice projectorDevice = new ProjectorDevice(this, this::handleMountedChanged);
    private boolean isMounted;
    private boolean hasEnergy;
    private final FixedEnergyStorage energy = new FixedEnergyStorage(Config.projectorEnergyStorage);
    private final Picture picture = Picture.create(640, 480, ColorSpace.YUV420J);
    private final H264Encoder encoder = new H264Encoder(new CQPRateControl(12));
    private final ByteBuffer encoderBuffer = ByteBuffer.allocateDirect(0x100000);
    private boolean needsIDR;
    private final H264Decoder decoder = new H264Decoder();
    @Nullable
    private CompletableFuture<?> runningDecode;
    private final ByteBuffer decoderBuffer = ByteBuffer.allocateDirect(0x100000);
    @Nullable
    private FrameConsumer frameConsumer;
    private AABB renderBounds;
    private long lastKeepAliveSentAt;

    public ProjectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.PROJECTOR.get(), pos, state);
        this.encoder.setKeyInterval(100);
        this.updateRenderBounds();
    }

    public boolean isProjecting() {
        int neighborChunkZ;
        if (!this.isMounted || this.f_58857_ == null) {
            return false;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)ProjectorBlock.f_54117_);
        BlockPos neighborPos = this.m_58899_().m_121945_(facing);
        int neighborChunkX = SectionPos.m_123171_((int)neighborPos.m_123341_());
        if (!this.f_58857_.m_7232_(neighborChunkX, neighborChunkZ = SectionPos.m_123171_((int)neighborPos.m_123343_()))) {
            return false;
        }
        BlockState neighborBlockState = this.f_58857_.m_8055_(neighborPos);
        return !neighborBlockState.m_60804_((BlockGetter)this.f_58857_, neighborPos);
    }

    public boolean hasEnergy() {
        return this.hasEnergy;
    }

    public void setRequiresKeyframe() {
        this.needsIDR = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrameConsumer(@Nullable FrameConsumer consumer) {
        if (consumer == this.frameConsumer) {
            return;
        }
        Picture picture = this.picture;
        synchronized (picture) {
            this.frameConsumer = consumer;
            if (this.frameConsumer != null) {
                this.frameConsumer.processFrame(this.picture);
            }
        }
    }

    public void onRendering() {
        long now = System.currentTimeMillis();
        if (now - this.lastKeepAliveSentAt > 1000L) {
            this.lastKeepAliveSentAt = now;
            Network.sendToServer(new ProjectorRequestFramebufferMessage(this));
        }
    }

    @Override
    public void serverTick() {
        boolean isPowered;
        if (!this.isMounted) {
            return;
        }
        if (Config.projectorsUseEnergy()) {
            boolean bl = isPowered = this.energy.extractEnergy(Config.projectorEnergyPerTick, true) >= Config.projectorEnergyPerTick;
            if (isPowered) {
                this.energy.extractEnergy(Config.projectorEnergyPerTick, false);
            }
        } else {
            isPowered = true;
        }
        this.updateProjectorState(this.isMounted, isPowered);
        if (!this.hasEnergy || !this.projectorDevice.hasChanges() && !this.needsIDR) {
            return;
        }
        ProjectorLoadBalancer.offerFrame(this, this::encodeFrame);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_(IS_PROJECTING_TAG_NAME, this.isMounted);
        tag.m_128379_(HAS_ENERGY_TAG_NAME, this.hasEnergy);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.isMounted = tag.m_128471_(IS_PROJECTING_TAG_NAME);
        this.hasEnergy = tag.m_128471_(HAS_ENERGY_TAG_NAME);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ENERGY_TAG_NAME, (Tag)this.energy.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energy.deserializeNBT((Tag)tag.m_128469_(ENERGY_TAG_NAME));
    }

    public AABB getRenderBoundingBox() {
        return this.renderBounds;
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.updateRenderBounds();
    }

    public void applyProjectorStateClient(boolean isProjecting, boolean hasEnergy) {
        if (this.f_58857_ == null || !this.f_58857_.m_5776_()) {
            return;
        }
        this.isMounted = isProjecting;
        this.hasEnergy = hasEnergy;
    }

    public void applyNextFrameClient(ByteBuffer frameData) {
        if (this.f_58857_ == null || !this.f_58857_.m_5776_()) {
            return;
        }
        CompletableFuture<?> lastDecode = this.runningDecode;
        this.runningDecode = CompletableFuture.runAsync(() -> {
            try {
                try {
                    if (lastDecode != null) {
                        lastDecode.join();
                    }
                }
                catch (CompletionException completionException) {
                    // empty catch block
                }
                Inflater inflater = new Inflater();
                inflater.setInput(frameData);
                this.decoderBuffer.clear();
                inflater.inflate(this.decoderBuffer);
                this.decoderBuffer.flip();
                this.decoder.decodeFrame(this.decoderBuffer, this.picture.getData());
                Picture picture = this.picture;
                synchronized (picture) {
                    if (this.frameConsumer != null) {
                        this.frameConsumer.processFrame(this.picture);
                    }
                }
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }, DECODER_WORKERS);
    }

    @Override
    protected void collectCapabilities(ModBlockEntity.CapabilityCollector collector, @Nullable Direction direction) {
        if (Config.projectorsUseEnergy()) {
            collector.offer(Capabilities.energyStorage(), this.energy);
        }
        if (direction == ((Direction)this.m_58900_().m_61143_((Property)ProjectorBlock.f_54117_)).m_122424_()) {
            collector.offer(Capabilities.device(), this.projectorDevice);
        }
    }

    private void handleMountedChanged(boolean value) {
        this.updateProjectorState(value, this.hasEnergy);
    }

    private void updateProjectorState(boolean isMounted, boolean hasEnergy) {
        if (isMounted == this.isMounted && hasEnergy == this.hasEnergy || !this.isValid()) {
            return;
        }
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && this.f_58857_.m_46749_(this.m_58899_())) {
            if (this.isMounted && !isMounted) {
                Arrays.fill(this.picture.getPlaneData(0), (byte)-128);
                Arrays.fill(this.picture.getPlaneData(1), (byte)0);
                Arrays.fill(this.picture.getPlaneData(2), (byte)0);
            }
            this.isMounted = isMounted;
            this.hasEnergy = hasEnergy;
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ProjectorBlock.LIT, (Comparable)Boolean.valueOf(isMounted)), 2);
            Network.sendToClientsTrackingBlockEntity(new ProjectorStateMessage(this, isMounted, hasEnergy), this);
        }
    }

    @Nullable
    private ByteBuffer encodeFrame() {
        ByteBuffer frameData;
        boolean hasChanges = this.projectorDevice.applyChanges(this.picture);
        if (!hasChanges && !this.needsIDR) {
            return null;
        }
        this.encoderBuffer.clear();
        try {
            if (this.needsIDR) {
                frameData = this.encoder.encodeIDRFrame(this.picture, this.encoderBuffer);
                this.needsIDR = false;
            } else {
                frameData = this.encoder.encodeFrame(this.picture, this.encoderBuffer).data();
            }
        }
        catch (BufferOverflowException ignored) {
            return null;
        }
        Deflater deflater = new Deflater(9);
        deflater.setInput(frameData);
        deflater.finish();
        ByteBuffer compressedFrameData = ByteBuffer.allocateDirect(0x100000);
        deflater.deflate(compressedFrameData, 3);
        deflater.end();
        compressedFrameData.flip();
        return compressedFrameData;
    }

    private void updateRenderBounds() {
        Direction blockFacing = (Direction)this.m_58900_().m_61143_((Property)ProjectorBlock.f_54117_);
        Direction canvasUp = Direction.UP;
        Direction canvasLeft = blockFacing.m_122428_();
        BlockPos projectorPos = this.m_58899_();
        BlockPos screenBasePos = projectorPos.m_5484_(blockFacing, 16);
        BlockPos screenMinPos = screenBasePos.m_5484_(canvasLeft.m_122424_(), 6);
        BlockPos screenMaxPos = screenBasePos.m_5484_(canvasLeft, 6).m_5484_(canvasUp, 8);
        this.renderBounds = new AABB(this.m_58899_()).m_82367_(new AABB(screenMinPos)).m_82367_(new AABB(screenMaxPos));
    }

    @FunctionalInterface
    public static interface FrameConsumer {
        public void processFrame(Picture var1);
    }
}

