/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device;

import java.util.function.Supplier;
import li.cil.oc2.api.bus.device.DeviceType;
import li.cil.oc2.common.bus.device.util.DeviceTypeImpl;
import li.cil.oc2.common.tags.ItemTags;
import li.cil.oc2.common.util.TranslationUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;

public final class DeviceTypes {
    private static final DeferredRegister<DeviceType> DEVICE_TYPES = DeferredRegister.create(DeviceType.REGISTRY, (String)"oc2r");
    public static final Supplier<IForgeRegistry<DeviceType>> DEVICE_TYPE_REGISTRY = DEVICE_TYPES.makeRegistry(RegistryBuilder::new);

    public static void initialize() {
        DEVICE_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        DeviceTypes.register(ItemTags.DEVICES_MEMORY);
        DeviceTypes.register(ItemTags.DEVICES_HARD_DRIVE);
        DeviceTypes.register(ItemTags.DEVICES_FLASH_MEMORY);
        DeviceTypes.register(ItemTags.DEVICES_CARD);
        DeviceTypes.register(ItemTags.DEVICES_ROBOT_MODULE);
        DeviceTypes.register(ItemTags.DEVICES_FLOPPY);
        DeviceTypes.register(ItemTags.DEVICES_NETWORK_TUNNEL);
        DeviceTypes.register(ItemTags.DEVICES_CPU);
    }

    private static void register(TagKey<Item> tag) {
        String id = tag.f_203868_().m_135815_().replaceFirst("^devices/", "");
        DEVICE_TYPES.register(id, () -> new DeviceTypeImpl(tag, new ResourceLocation("oc2r", "item/" + id + "_slot"), (Component)TranslationUtils.text("gui.{mod}.device_type." + id)));
    }
}

