/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.container;

import javax.annotation.Nullable;
import li.cil.oc2.common.block.Blocks;
import li.cil.oc2.common.blockentity.MonitorBlockEntity;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.container.AbstractMachineContainer;
import li.cil.oc2.common.container.IntPrecisionContainerData;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.MonitorPowerMessage;
import li.cil.oc2.common.vm.VirtualMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class AbstractMonitorContainer
extends AbstractMachineContainer {
    private final MonitorBlockEntity monitor;

    protected AbstractMonitorContainer(MenuType<?> type, int id, Player player, MonitorBlockEntity monitor, IntPrecisionContainerData energyInfo) {
        super(type, id, energyInfo);
        this.monitor = monitor;
    }

    @Override
    public void switchToInventory() {
    }

    @Override
    @Nullable
    public VirtualMachine getVirtualMachine() {
        return null;
    }

    public MonitorBlockEntity getMonitor() {
        return this.monitor;
    }

    public boolean hasPower() {
        return this.monitor.hasPower();
    }

    public boolean getPowerState() {
        return this.monitor.getPowerState();
    }

    public boolean isMounted() {
        return this.monitor.isMounted();
    }

    @Override
    public void sendPowerStateToServer(boolean value) {
        Network.sendToServer(new MonitorPowerMessage(this.monitor, value));
    }

    public boolean m_6875_(Player player) {
        if (!this.monitor.isValid()) {
            return false;
        }
        Level level = this.monitor.m_58904_();
        return level != null && AbstractMonitorContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)level, (BlockPos)this.monitor.m_58899_()), (Player)player, (Block)((Block)Blocks.MONITOR.get()));
    }

    protected static IntPrecisionContainerData createEnergyInfo(final IEnergyStorage energy, final CommonDeviceBusController busController) {
        return new IntPrecisionContainerData.Server(){

            @Override
            public int getInt(int index) {
                return switch (index) {
                    case 0 -> energy.getEnergyStored();
                    case 1 -> energy.getMaxEnergyStored();
                    case 2 -> busController.getEnergyConsumption();
                    default -> 0;
                };
            }

            @Override
            public int getIntCount() {
                return 3;
            }
        };
    }

    protected static IntPrecisionContainerData createEnergyInfo(final IEnergyStorage energy) {
        return new IntPrecisionContainerData.Server(){

            @Override
            public int getInt(int index) {
                return switch (index) {
                    case 0 -> energy.getEnergyStored();
                    case 1 -> energy.getMaxEnergyStored();
                    default -> 0;
                };
            }

            @Override
            public int getIntCount() {
                return 3;
            }
        };
    }
}

