/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.energy;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.util.NBTUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public final class EnergyStorageItemStack
implements IEnergyStorage,
ICapabilityProvider {
    private final LazyOptional<IEnergyStorage> optional = LazyOptional.of(() -> this);
    private final ItemStack stack;
    private final int capacity;
    private final String[] tagPath;

    public EnergyStorageItemStack(ItemStack stack, int capacity, String ... tagPath) {
        this.stack = stack;
        this.capacity = capacity;
        this.tagPath = tagPath;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int stored = this.getEnergyStored();
        int receiveLimit = this.capacity - stored;
        int receive = Math.min(maxReceive, receiveLimit);
        if (!simulate) {
            NBTUtils.getOrCreateChildTag(this.stack.m_41784_(), this.tagPath).m_128405_("stored", stored + receive);
        }
        return receive;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return NBTUtils.getChildTag(this.stack.m_41783_(), this.tagPath).m_128451_("stored");
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        return Capabilities.energyStorage().orEmpty(capability, this.optional);
    }
}

