/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.entity;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.DeviceBusElement;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.ObjectDevice;
import li.cil.oc2.api.bus.device.object.Parameter;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.api.capabilities.TerminalUserProvider;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.bus.AbstractDeviceBusElement;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.bus.device.util.Devices;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.container.FixedSizeItemStackHandler;
import li.cil.oc2.common.container.RobotInventoryContainer;
import li.cil.oc2.common.container.RobotTerminalContainer;
import li.cil.oc2.common.energy.FixedEnergyStorage;
import li.cil.oc2.common.entity.robot.AbstractRobotAction;
import li.cil.oc2.common.entity.robot.MovementDirection;
import li.cil.oc2.common.entity.robot.RobotActionResult;
import li.cil.oc2.common.entity.robot.RobotActions;
import li.cil.oc2.common.entity.robot.RobotMovementAction;
import li.cil.oc2.common.entity.robot.RobotRotationAction;
import li.cil.oc2.common.entity.robot.RotationDirection;
import li.cil.oc2.common.integration.Wrenches;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.RobotBootErrorMessage;
import li.cil.oc2.common.network.message.RobotBusStateMessage;
import li.cil.oc2.common.network.message.RobotInitializationRequestMessage;
import li.cil.oc2.common.network.message.RobotRunStateMessage;
import li.cil.oc2.common.network.message.RobotTerminalOutputMessage;
import li.cil.oc2.common.serialization.NBTSerialization;
import li.cil.oc2.common.util.LevelUtils;
import li.cil.oc2.common.util.NBTUtils;
import li.cil.oc2.common.util.TerminalUtils;
import li.cil.oc2.common.vm.AbstractTerminalVMRunner;
import li.cil.oc2.common.vm.AbstractVMItemStackHandlers;
import li.cil.oc2.common.vm.AbstractVirtualMachine;
import li.cil.oc2.common.vm.Terminal;
import li.cil.oc2.common.vm.VMItemStackHandlers;
import li.cil.oc2.common.vm.VMRunState;
import li.cil.oc2.common.vm.VirtualMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public final class Robot
extends Entity
implements li.cil.oc2.api.capabilities.Robot,
TerminalUserProvider {
    public static final EntityDataAccessor<BlockPos> TARGET_POSITION = SynchedEntityData.m_135353_(Robot.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<Direction> TARGET_DIRECTION = SynchedEntityData.m_135353_(Robot.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    public static final EntityDataAccessor<Byte> SELECTED_SLOT = SynchedEntityData.m_135353_(Robot.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final String TERMINAL_TAG_NAME = "terminal";
    private static final String STATE_TAG_NAME = "state";
    private static final String BUS_ELEMENT_TAG_NAME = "bus_element";
    private static final String DEVICES_TAG_NAME = "devices";
    private static final String COMMAND_PROCESSOR_TAG_NAME = "commands";
    private static final String INVENTORY_TAG_NAME = "inventory";
    private static final String SELECTED_SLOT_TAG_NAME = "selected_slot";
    private static final int MAX_QUEUED_ACTIONS = 16;
    private static final int MAX_QUEUED_RESULTS = 16;
    private static final int MEMORY_SLOTS = 4;
    private static final int HARD_DRIVE_SLOTS = 2;
    private static final int FLASH_MEMORY_SLOTS = 1;
    private static final int MODULE_SLOTS = 4;
    private static final int INVENTORY_SIZE = 12;
    private static final int CPU_SLOTS = 1;
    private final Consumer<ChunkEvent.Unload> chunkUnloadListener = this::handleChunkUnload;
    private final Consumer<LevelEvent.Unload> worldUnloadListener = this::handleWorldUnload;
    private final BlockPos.MutableBlockPos mutablePosition = new BlockPos.MutableBlockPos();
    private final AnimationState animationState = new AnimationState();
    private final RobotActionProcessor actionProcessor = new RobotActionProcessor();
    private final Terminal terminal = new Terminal();
    private final RobotVirtualMachine virtualMachine;
    private final RobotBusElement busElement = new RobotBusElement();
    private final RobotItemStackHandlers deviceItems = new RobotItemStackHandlers();
    private final FixedEnergyStorage energy = new FixedEnergyStorage(Config.robotEnergyStorage);
    private final ItemStackHandler inventory = new FixedSizeItemStackHandler(12);
    private final Set<Player> terminalUsers = Collections.newSetFromMap(new WeakHashMap());
    private long lastPistonMovement;

    public Robot(EntityType<?> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
        this.m_20242_(true);
        CommonDeviceBusController busController = new CommonDeviceBusController(this.busElement, Config.robotEnergyPerTick);
        this.virtualMachine = new RobotVirtualMachine(busController);
        this.virtualMachine.state.builtinDevices.rtcMinecraft.setLevel(world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AnimationState getAnimationState() {
        return this.animationState;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public VirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public VMItemStackHandlers getItemStackHandlers() {
        return this.deviceItems;
    }

    @Override
    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public int getSelectedSlot() {
        return ((Byte)this.m_20088_().m_135370_(SELECTED_SLOT)).byteValue();
    }

    @Override
    public void setSelectedSlot(int value) {
        this.m_20088_().m_135381_(SELECTED_SLOT, (Object)((byte)Mth.m_14045_((int)value, (int)0, (int)11)));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (capability == Capabilities.itemHandler()) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        if (capability == Capabilities.energyStorage() && Config.robotsUseEnergy()) {
            return LazyOptional.of(() -> this.energy).cast();
        }
        if (capability == Capabilities.robot()) {
            return LazyOptional.of(() -> this).cast();
        }
        LazyOptional optional = super.getCapability(capability, side);
        if (optional.isPresent()) {
            return optional;
        }
        for (Device device : this.virtualMachine.busController.getDevices()) {
            ICapabilityProvider capabilityProvider;
            LazyOptional value;
            if (!(device instanceof ICapabilityProvider) || !(value = (capabilityProvider = (ICapabilityProvider)device).getCapability(capability, side)).isPresent()) continue;
            return value;
        }
        return LazyOptional.empty();
    }

    public long getLastPistonMovement() {
        return this.lastPistonMovement;
    }

    public void start() {
        if (!this.m_9236_().m_5776_()) {
            this.virtualMachine.start();
        }
    }

    public void stop() {
        if (!this.m_9236_().m_5776_()) {
            this.virtualMachine.stop();
        }
    }

    public void openTerminalScreen(ServerPlayer player) {
        RobotTerminalContainer.createServer(this, this.energy, this.virtualMachine.busController, player);
    }

    public void openInventoryScreen(ServerPlayer player) {
        RobotInventoryContainer.createServer(this, this.energy, this.virtualMachine.busController, player);
    }

    public void addTerminalUser(Player player) {
        this.terminalUsers.add(player);
    }

    public void removeTerminalUser(Player player) {
        this.terminalUsers.remove(player);
    }

    @Override
    public Iterable<Player> getTerminalUsers() {
        return this.terminalUsers;
    }

    public void dropSelf() {
        if (!this.m_6084_()) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)Items.ROBOT.get());
        this.exportToItemStack(stack);
        this.m_19983_(stack);
        this.m_146870_();
        LevelUtils.playSound((LevelAccessor)this.m_9236_(), this.m_20183_(), SoundType.f_56743_, SoundType::m_56775_);
    }

    public void m_8119_() {
        Level level;
        boolean isClient = this.m_9236_().m_5776_();
        if (this.f_19803_) {
            if (isClient) {
                this.requestInitialState();
            } else {
                this.registerListeners();
                RobotActions.initializeData(this);
                if (this.actionProcessor.action != null) {
                    this.actionProcessor.action.initialize(this);
                }
            }
        }
        super.m_8119_();
        if (isClient) {
            this.terminal.clientTick();
        }
        if (!isClient) {
            this.virtualMachine.tick();
        }
        this.actionProcessor.tick();
        if (!isClient && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VoxelShape shape = Shapes.m_83064_((AABB)this.m_20191_());
            Cursor3D iterator = this.getBlockPosIterator();
            while (iterator.m_122304_()) {
                VoxelShape blockShape;
                int x = iterator.m_122305_();
                int y = iterator.m_122306_();
                int z = iterator.m_122307_();
                this.mutablePosition.m_122178_(x, y, z);
                BlockState blockState = serverLevel.m_8055_((BlockPos)this.mutablePosition);
                if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_50110_) || blockState.m_60713_(Blocks.f_50040_) || !Shapes.m_83157_((VoxelShape)shape, (VoxelShape)(blockShape = blockState.m_60812_((BlockGetter)serverLevel, (BlockPos)this.mutablePosition)).m_83216_((double)x, (double)y, (double)z), (BooleanOp)BooleanOp.f_82689_)) continue;
                BlockEntity blockEntity = serverLevel.m_7702_((BlockPos)this.mutablePosition);
                LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287286_(LootContextParams.f_81461_, (Object)blockState).m_287289_(LootContextParams.f_81462_, (Object)blockEntity);
                List drops = blockState.m_287290_(builder);
                serverLevel.m_46597_((BlockPos)this.mutablePosition, Blocks.f_50016_.m_49966_());
                for (ItemStack drop : drops) {
                    Block.m_49840_((Level)serverLevel, (BlockPos)this.mutablePosition, (ItemStack)drop);
                }
            }
        }
    }

    public boolean m_7313_(Entity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            this.dropSelf();
        }
        return true;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.m_9236_().m_5776_()) {
            if (Wrenches.isWrench(stack)) {
                if (player.m_6144_()) {
                    this.dropSelf();
                } else if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    this.openInventoryScreen(serverPlayer);
                }
            } else if (player.m_6144_()) {
                this.start();
            } else if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.openTerminalScreen(serverPlayer);
            }
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_142467_(Entity.RemovalReason reason) {
        super.m_142467_(reason);
        if (!this.m_9236_().m_5776_()) {
            this.virtualMachine.stop();
            this.virtualMachine.dispose();
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_7337_(Entity entity) {
        return entity != this;
    }

    public void m_7334_(Entity entity) {
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_5843_() {
        return false;
    }

    public void exportToItemStack(ItemStack stack) {
        CompoundTag itemsTag = NBTUtils.getOrCreateChildTag(stack.m_41784_(), "oc2r", "items");
        this.deviceItems.saveItems(itemsTag);
        itemsTag.m_128365_(INVENTORY_TAG_NAME, (Tag)this.inventory.serializeNBT());
        NBTUtils.getOrCreateChildTag(stack.m_41784_(), "oc2r").m_128365_("energy", (Tag)this.energy.serializeNBT());
    }

    public void importFromItemStack(ItemStack stack) {
        CompoundTag itemsTag = NBTUtils.getChildTag(stack.m_41783_(), "oc2r", "items");
        this.deviceItems.loadItems(itemsTag);
        this.inventory.deserializeNBT(itemsTag.m_128469_(INVENTORY_TAG_NAME));
        this.energy.deserializeNBT((Tag)NBTUtils.getChildTag(stack.m_41783_(), "oc2r", "energy"));
    }

    protected void m_8097_() {
        SynchedEntityData dataManager = this.m_20088_();
        dataManager.m_135372_(TARGET_POSITION, (Object)BlockPos.f_121853_);
        dataManager.m_135372_(TARGET_DIRECTION, (Object)Direction.NORTH);
        dataManager.m_135372_(SELECTED_SLOT, (Object)0);
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.virtualMachine.getRunState() != VMRunState.STOPPED) {
            tag.m_128365_(STATE_TAG_NAME, (Tag)this.virtualMachine.serialize());
            tag.m_128365_(TERMINAL_TAG_NAME, (Tag)NBTSerialization.serialize(this.terminal));
        }
        tag.m_128365_(COMMAND_PROCESSOR_TAG_NAME, (Tag)this.actionProcessor.serialize());
        tag.m_128365_(BUS_ELEMENT_TAG_NAME, (Tag)this.busElement.serialize());
        tag.m_128365_("items", (Tag)this.deviceItems.saveItems());
        tag.m_128365_(DEVICES_TAG_NAME, (Tag)this.deviceItems.saveDevices());
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_(INVENTORY_TAG_NAME, (Tag)this.inventory.serializeNBT());
        tag.m_128344_(SELECTED_SLOT_TAG_NAME, ((Byte)this.m_20088_().m_135370_(SELECTED_SLOT)).byteValue());
    }

    protected void m_7378_(CompoundTag tag) {
        this.virtualMachine.deserialize(tag.m_128469_(STATE_TAG_NAME));
        NBTSerialization.deserialize(tag.m_128469_(TERMINAL_TAG_NAME), this.terminal);
        this.actionProcessor.deserialize(tag.m_128469_(COMMAND_PROCESSOR_TAG_NAME));
        this.busElement.deserialize(tag.m_128469_(BUS_ELEMENT_TAG_NAME));
        this.deviceItems.loadItems(tag.m_128469_("items"));
        this.deviceItems.loadDevices(tag.m_128469_(DEVICES_TAG_NAME));
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_(INVENTORY_TAG_NAME));
        this.setSelectedSlot(tag.m_128445_(SELECTED_SLOT_TAG_NAME));
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_20101_() {
    }

    protected Vec3 m_20133_(Vec3 pos) {
        this.lastPistonMovement = this.m_9236_().m_46467_();
        return super.m_20133_(pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void requestInitialState() {
        Network.sendToServer(new RobotInitializationRequestMessage(this));
    }

    private void registerListeners() {
        MinecraftForge.EVENT_BUS.addListener(this.chunkUnloadListener);
        MinecraftForge.EVENT_BUS.addListener(this.worldUnloadListener);
    }

    private void unregisterListeners() {
        MinecraftForge.EVENT_BUS.unregister(this.chunkUnloadListener);
        MinecraftForge.EVENT_BUS.unregister(this.worldUnloadListener);
    }

    private void handleChunkUnload(ChunkEvent.Unload event) {
        if (event.getLevel() != this.m_9236_()) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(this.m_20183_());
        if (!Objects.equals(chunkPos, event.getChunk().m_7697_())) {
            return;
        }
        this.unregisterListeners();
        this.virtualMachine.suspend();
        this.virtualMachine.dispose();
    }

    private void handleWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel() != this.m_9236_()) {
            return;
        }
        this.unregisterListeners();
        this.virtualMachine.suspend();
        this.virtualMachine.dispose();
    }

    private Cursor3D getBlockPosIterator() {
        AABB bounds = this.m_20191_();
        return new Cursor3D(Mth.m_14107_((double)bounds.f_82288_), Mth.m_14107_((double)bounds.f_82289_), Mth.m_14107_((double)bounds.f_82290_), Mth.m_14107_((double)bounds.f_82291_), Mth.m_14107_((double)bounds.f_82292_), Mth.m_14107_((double)bounds.f_82293_));
    }

    private static float lerpClamped(float from, float to, float delta) {
        if (from < to) {
            return Math.min(from + delta, to);
        }
        if (from > to) {
            return Math.max(from - delta, to);
        }
        return from;
    }

    private static float remapFrom01To(float x, float a1, float b1) {
        if (a1 == b1) {
            return a1;
        }
        return x * (b1 - a1) + a1;
    }

    public final class AnimationState {
        private static final float TOP_IDLE_Y = -0.125f;
        private static final float BASE_IDLE_Y = -0.0625f;
        private static final float TRANSLATION_SPEED = 0.005f;
        private static final float ROTATION_SPEED = 1.0f;
        private static final float MAX_ROTATION = 5.0f;
        private static final float MIN_ROTATION_SPEED = 0.055f;
        private static final float MAX_ROTATION_SPEED = 0.06f;
        private static final float HOVER_ANIMATION_SPEED = 0.01f;
        public float topRenderOffsetY = -0.125f;
        public float baseRenderOffsetY = -0.0625f;
        public float topRenderRotationY;
        public float topRenderTargetRotationY;
        public float topRenderRotationSpeed;
        public float topRenderHover = -(this.hashCode() & 0xFFFF);

        public void update(float deltaTime, RandomSource random) {
            if (Robot.this.getVirtualMachine().isRunning() || Robot.this.actionProcessor.hasQueuedActions()) {
                this.topRenderHover += deltaTime * 0.01f;
                float topOffsetY = Mth.m_14031_((float)this.topRenderHover) / 32.0f;
                this.topRenderOffsetY = Robot.lerpClamped(this.topRenderOffsetY, topOffsetY, deltaTime * 0.005f);
                this.baseRenderOffsetY = Robot.lerpClamped(this.baseRenderOffsetY, topOffsetY, deltaTime * 0.005f);
                this.topRenderRotationY = Robot.lerpClamped(this.topRenderRotationY, this.topRenderTargetRotationY, deltaTime * this.topRenderRotationSpeed);
                if (this.topRenderRotationY == this.topRenderTargetRotationY) {
                    this.topRenderTargetRotationY = Robot.remapFrom01To(random.m_188501_(), -5.0f, 5.0f);
                    this.topRenderRotationSpeed = Robot.remapFrom01To(random.m_188501_(), 0.055f, 0.06f);
                }
            } else {
                this.topRenderOffsetY = Robot.lerpClamped(this.topRenderOffsetY, -0.125f, deltaTime * 0.005f * 2.0f);
                this.baseRenderOffsetY = Robot.lerpClamped(this.baseRenderOffsetY, -0.0625f, deltaTime * 0.005f);
                this.topRenderRotationY = Robot.lerpClamped(this.topRenderRotationY, 0.0f, deltaTime * 1.0f);
            }
        }
    }

    private final class RobotActionProcessor {
        private static final String QUEUE_TAG_NAME = "queue";
        private static final String ACTION_TAG_NAME = "action";
        private static final String RESULTS_TAG_NAME = "results";
        private static final String LAST_ACTION_ID_TAG_NAME = "last_action_id";
        private final Queue<AbstractRobotAction> queue = new ArrayDeque<AbstractRobotAction>(15);
        @Nullable
        private AbstractRobotAction action;
        private final Queue<RobotActionProcessorResult> results = new ArrayDeque<RobotActionProcessorResult>(16);
        private int lastActionId;

        private RobotActionProcessor() {
        }

        public boolean hasQueuedActions() {
            return this.action != null || !this.queue.isEmpty();
        }

        public int getQueuedActionCount() {
            return (this.action != null ? 1 : 0) + this.queue.size();
        }

        public boolean move(MovementDirection direction) {
            return this.addAction(new RobotMovementAction(direction));
        }

        public boolean rotate(RotationDirection direction) {
            return this.addAction(new RobotRotationAction(direction));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tick() {
            if (Robot.this.m_9236_().m_5776_()) {
                RobotActions.performClient(Robot.this);
            } else {
                RobotActionResult result;
                if (this.action != null && (result = this.action.perform(Robot.this)) != RobotActionResult.INCOMPLETE) {
                    Queue<RobotActionProcessorResult> queue = this.results;
                    synchronized (queue) {
                        if (this.results.size() == 16) {
                            this.results.remove();
                        }
                        this.results.add(new RobotActionProcessorResult(this.action.getId(), result));
                    }
                    this.action = null;
                }
                if (this.action == null) {
                    this.action = this.queue.poll();
                    if (this.action != null) {
                        this.action.initialize(Robot.this);
                    } else {
                        return;
                    }
                }
                RobotActions.performServer(Robot.this, this.action);
            }
        }

        public void clear() {
            this.queue.clear();
            this.results.clear();
            this.lastActionId = 0;
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            ListTag queueTag = new ListTag();
            for (AbstractRobotAction action : this.queue) {
                queueTag.add((Object)RobotActions.serialize(action));
            }
            tag.m_128365_(QUEUE_TAG_NAME, (Tag)queueTag);
            if (this.action != null) {
                tag.m_128365_(ACTION_TAG_NAME, (Tag)RobotActions.serialize(this.action));
            }
            ListTag resultsTag = new ListTag();
            for (RobotActionProcessorResult result : this.results) {
                resultsTag.add((Object)result.serialize());
            }
            tag.m_128365_(RESULTS_TAG_NAME, (Tag)resultsTag);
            tag.m_128405_(LAST_ACTION_ID_TAG_NAME, this.lastActionId);
            return tag;
        }

        public void deserialize(CompoundTag tag) {
            this.queue.clear();
            this.results.clear();
            ListTag queueTag = tag.m_128437_(QUEUE_TAG_NAME, 10);
            for (int i = 0; i < Math.min(queueTag.size(), 15); ++i) {
                AbstractRobotAction action = RobotActions.deserialize(queueTag.m_128728_(i));
                if (action == null) continue;
                this.queue.add(action);
            }
            this.action = RobotActions.deserialize(tag.m_128469_(ACTION_TAG_NAME));
            ListTag resultsTag = tag.m_128437_(RESULTS_TAG_NAME, 10);
            for (int i = 0; i < Math.min(resultsTag.size(), 16); ++i) {
                RobotActionProcessorResult result = new RobotActionProcessorResult(resultsTag.m_128728_(i));
                if (result.actionId == 0) continue;
                this.results.add(result);
            }
            this.lastActionId = tag.m_128451_(LAST_ACTION_ID_TAG_NAME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addAction(AbstractRobotAction action) {
            if (Robot.this.m_9236_().m_5776_()) {
                return false;
            }
            if (!Robot.this.getVirtualMachine().isRunning()) {
                return false;
            }
            if (this.queue.size() < 15) {
                this.lastActionId = this.lastActionId + 1 & Integer.MAX_VALUE;
                action.setId(this.lastActionId);
                Queue<AbstractRobotAction> queue = this.queue;
                synchronized (queue) {
                    this.queue.add(action);
                }
                return true;
            }
            return false;
        }
    }

    private final class RobotBusElement
    extends AbstractDeviceBusElement {
        private static final String DEVICE_ID_TAG_NAME = "device_id";
        private final Device device;
        private UUID deviceId;

        private RobotBusElement() {
            this.device = new ObjectDevice((Object)new RobotDevice(), "robot");
            this.deviceId = UUID.randomUUID();
        }

        @Override
        public Optional<Collection<LazyOptional<DeviceBusElement>>> getNeighbors() {
            return Optional.of(Collections.singleton(LazyOptional.of(() -> Robot.this.deviceItems.busElement)));
        }

        @Override
        public Collection<Device> getLocalDevices() {
            return Collections.singleton(this.device);
        }

        @Override
        public Optional<UUID> getDeviceIdentifier(Device device) {
            if (device == this.device) {
                return Optional.of(this.deviceId);
            }
            return super.getDeviceIdentifier(device);
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_(DEVICE_ID_TAG_NAME, this.deviceId);
            return tag;
        }

        public void deserialize(CompoundTag tag) {
            if (tag.m_128403_(DEVICE_ID_TAG_NAME)) {
                this.deviceId = tag.m_128342_(DEVICE_ID_TAG_NAME);
            }
        }
    }

    private final class RobotItemStackHandlers
    extends AbstractVMItemStackHandlers {
        public RobotItemStackHandlers() {
            super(new AbstractVMItemStackHandlers.GroupDefinition(DeviceTypes.MEMORY, 4), new AbstractVMItemStackHandlers.GroupDefinition(DeviceTypes.HARD_DRIVE, 2), new AbstractVMItemStackHandlers.GroupDefinition(DeviceTypes.FLASH_MEMORY, 1), new AbstractVMItemStackHandlers.GroupDefinition(DeviceTypes.ROBOT_MODULE, 4), new AbstractVMItemStackHandlers.GroupDefinition(DeviceTypes.CPU, 1));
        }

        @Override
        protected ItemDeviceQuery makeQuery(ItemStack stack) {
            return Devices.makeQuery(Robot.this, stack);
        }

        @Override
        protected void onChanged() {
            super.onChanged();
            if (!Robot.this.m_9236_().m_5776_()) {
                Robot.this.virtualMachine.busController.scheduleBusScan();
            }
        }
    }

    private final class RobotVirtualMachine
    extends AbstractVirtualMachine {
        private RobotVirtualMachine(CommonDeviceBusController busController) {
            super(busController);
            this.state.vmAdapter.setBaseAddressProvider(Robot.this.deviceItems::getDeviceAddressBase);
        }

        @Override
        protected boolean consumeEnergy(int amount, boolean simulate) {
            if (!Config.robotsUseEnergy()) {
                return true;
            }
            if (amount > Robot.this.energy.getEnergyStored()) {
                return false;
            }
            Robot.this.energy.extractEnergy(amount, simulate);
            return true;
        }

        @Override
        protected void stopRunnerAndReset() {
            super.stopRunnerAndReset();
            TerminalUtils.resetTerminal(Robot.this.terminal, output -> Network.sendToClientsTrackingEntity(new RobotTerminalOutputMessage(Robot.this, (ByteBuffer)output), Robot.this));
            Robot.this.actionProcessor.clear();
        }

        @Override
        protected AbstractTerminalVMRunner createRunner() {
            return new RobotVMRunner(this, Robot.this.terminal);
        }

        @Override
        protected void handleBusStateChanged(CommonDeviceBusController.BusState value) {
            Network.sendToClientsTrackingEntity(new RobotBusStateMessage(Robot.this, value), Robot.this);
        }

        @Override
        protected void handleRunStateChanged(VMRunState value) {
            Network.sendToClientsTrackingEntity(new RobotRunStateMessage(Robot.this, value), Robot.this);
        }

        @Override
        protected void handleBootErrorChanged(@Nullable Component value) {
            if (value == null) {
                value = Component.m_237113_((String)"");
            }
            Network.sendToClientsTrackingEntity(new RobotBootErrorMessage(Robot.this, value), Robot.this);
        }
    }

    public final class RobotDevice {
        @Callback(synchronize=false)
        public int getEnergyStored() {
            return Robot.this.energy.getEnergyStored();
        }

        @Callback(synchronize=false)
        public int getEnergyCapacity() {
            return Robot.this.energy.getMaxEnergyStored();
        }

        @Callback(synchronize=false)
        public int getSelectedSlot() {
            return Robot.this.getSelectedSlot();
        }

        @Callback(synchronize=false)
        public void setSelectedSlot(@Parameter(value="slot") int slot) {
            Robot.this.setSelectedSlot(slot);
        }

        @Callback
        public ItemStack getStackInSlot(@Parameter(value="slot") int slot) {
            return Robot.this.inventory.getStackInSlot(slot);
        }

        @Callback(synchronize=false)
        public boolean move(@Parameter(value="direction") @Nullable MovementDirection direction) {
            if (direction == null) {
                throw new IllegalArgumentException();
            }
            return Robot.this.actionProcessor.move(direction);
        }

        @Callback(synchronize=false)
        public boolean turn(@Parameter(value="direction") @Nullable RotationDirection direction) {
            if (direction == null) {
                throw new IllegalArgumentException();
            }
            return Robot.this.actionProcessor.rotate(direction);
        }

        @Callback(synchronize=false)
        public int getLastActionId() {
            return Robot.this.actionProcessor.lastActionId;
        }

        @Callback(synchronize=false)
        public int getQueuedActionCount() {
            return Robot.this.actionProcessor.getQueuedActionCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @Callback(synchronize=false)
        public RobotActionResult getActionResult(@Parameter(value="actionId") int actionId) {
            AbstractRobotAction currentAction = Robot.this.actionProcessor.action;
            if (currentAction != null && currentAction.getId() == actionId) {
                return RobotActionResult.INCOMPLETE;
            }
            Queue<Object> queue = Robot.this.actionProcessor.queue;
            synchronized (queue) {
                for (AbstractRobotAction action : Robot.this.actionProcessor.queue) {
                    if (action.getId() != actionId) continue;
                    return RobotActionResult.INCOMPLETE;
                }
            }
            queue = Robot.this.actionProcessor.results;
            synchronized (queue) {
                for (RobotActionProcessorResult result : Robot.this.actionProcessor.results) {
                    if (result.actionId != actionId) continue;
                    return result.result;
                }
            }
            return null;
        }

        private RobotDevice() {
        }
    }

    private final class RobotVMRunner
    extends AbstractTerminalVMRunner {
        public RobotVMRunner(AbstractVirtualMachine virtualMachine, Terminal terminal) {
            super(virtualMachine, terminal);
        }

        @Override
        protected void sendTerminalUpdateToClient(ByteBuffer output) {
            Network.sendToClientsTrackingEntity(new RobotTerminalOutputMessage(Robot.this, output), Robot.this);
        }
    }

    private static final class RobotActionProcessorResult {
        private static final String ACTION_ID_TAG_NAME = "action_id";
        private static final String RESULT_TAG_NAME = "result";
        public int actionId;
        public RobotActionResult result;

        public RobotActionProcessorResult(int actionId, RobotActionResult result) {
            this.actionId = actionId;
            this.result = result;
        }

        public RobotActionProcessorResult(CompoundTag tag) {
            this.deserialize(tag);
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_(ACTION_ID_TAG_NAME, this.actionId);
            NBTUtils.putEnum(tag, RESULT_TAG_NAME, this.result);
            return tag;
        }

        public void deserialize(CompoundTag tag) {
            this.actionId = tag.m_128451_(ACTION_ID_TAG_NAME);
            this.result = NBTUtils.getEnum(tag, RESULT_TAG_NAME, RobotActionResult.class);
        }
    }
}

