/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.inet;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Random;
import li.cil.oc2.api.inet.LayerParameters;
import li.cil.oc2.api.inet.TransportMessage;
import li.cil.oc2.api.inet.layer.NetworkLayer;
import li.cil.oc2.api.inet.layer.TransportLayer;
import li.cil.oc2.common.inet.InetUtils;
import li.cil.oc2.common.inet.InternetManagerImpl;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DefaultNetworkLayer
implements NetworkLayer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random random = new Random();
    private static final int IPv4_HEADER_SIZE = 20;
    private static final int IPv4_VERSION = 4;
    private final TransportLayer transportLayer;
    private final TransportMessage inMessage = new TransportMessage();
    private final TransportMessage outMessage = new TransportMessage();
    private final InternetManagerImpl internetManager;

    public DefaultNetworkLayer(LayerParameters layerParameters, TransportLayer transportLayer) {
        this.internetManager = (InternetManagerImpl)layerParameters.getInternetManager();
        this.transportLayer = transportLayer;
    }

    @Override
    public Optional<Tag> onSave() {
        return this.transportLayer.onSave().map(transportLayerState -> {
            CompoundTag networkLayerState = new CompoundTag();
            networkLayerState.m_128365_("Transport", transportLayerState);
            return networkLayerState;
        });
    }

    @Override
    public void onStop() {
        this.transportLayer.onStop();
    }

    @Override
    public short receivePacket(ByteBuffer packet) {
        packet.position(packet.position() + 20);
        this.inMessage.initializeBuffer(packet);
        byte protocol = this.transportLayer.receiveTransportMessage(this.inMessage);
        if (protocol == 0 || !this.inMessage.isIpv4()) {
            return 0;
        }
        int srcIpAddress = this.inMessage.getSrcIpv4Address();
        int dstIpAddress = this.inMessage.getDstIpv4Address();
        int bodySize = packet.remaining();
        packet.position(packet.position() - 20);
        packet.put((byte)69);
        packet.put((byte)0);
        packet.putShort((short)(20 + bodySize));
        packet.putShort((short)random.nextInt());
        packet.putShort((short)0);
        packet.put(this.inMessage.getTtl());
        packet.put(protocol);
        packet.putShort((short)0);
        packet.putInt(srcIpAddress);
        packet.putInt(dstIpAddress);
        packet.position(packet.position() - 20);
        short checksum = InetUtils.rfc1071Checksum(packet, 20);
        packet.position(packet.position() - 10);
        packet.putShort(checksum);
        packet.position(packet.position() + 8 - 20);
        return 2048;
    }

    @Override
    public void sendPacket(short protocol, ByteBuffer packet) {
        if (protocol != 2048) {
            LOGGER.trace("Unsupported network protocol");
            return;
        }
        if (packet.remaining() < 20) {
            LOGGER.trace("IP header is too small");
            return;
        }
        byte versionAndIhl = packet.get();
        if (versionAndIhl >>> 4 != 4) {
            LOGGER.trace("Invalid protocol version");
            return;
        }
        int headerSize = (versionAndIhl & 0xF) * 4;
        if (headerSize < 20 || packet.remaining() < headerSize) {
            LOGGER.trace("Invalid header size");
            return;
        }
        packet.get();
        int messageLength = Short.toUnsignedInt(packet.getShort());
        if (packet.remaining() + 4 < messageLength) {
            LOGGER.trace("Packet size is lower than IP message size");
            return;
        }
        packet.getShort();
        short flagsAndFragmentOffset = packet.getShort();
        if ((flagsAndFragmentOffset >>> 13 & 5) != 0) {
            LOGGER.trace("Fragmented packet prohibited (1)");
            return;
        }
        if ((flagsAndFragmentOffset & 0x1FFF) != 0) {
            LOGGER.trace("Fragmented packet prohibited (2)");
            return;
        }
        byte ttl = (byte)(packet.get() - 1);
        if (ttl == 0) {
            LOGGER.trace("Small TTL value");
            return;
        }
        byte transportProtocol = packet.get();
        packet.getShort();
        int srcIpAddress = packet.getInt();
        int dstIpAddress = packet.getInt();
        if (!this.internetManager.isAllowedToConnect(dstIpAddress)) {
            LOGGER.trace("Forbidden IP address");
            return;
        }
        packet.position(packet.position() + headerSize - 20);
        packet.limit(packet.position() + messageLength - headerSize);
        LOGGER.trace("Transport message received");
        this.outMessage.initializeBuffer(packet);
        this.outMessage.updateIpv4(srcIpAddress, dstIpAddress, ttl);
        this.transportLayer.sendTransportMessage(transportProtocol, this.outMessage);
    }
}

