/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.inet;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.Function;
import li.cil.oc2.api.inet.LayerParameters;
import li.cil.oc2.common.inet.AddressParseException;
import li.cil.oc2.common.inet.Ipv4Space;
import li.cil.oc2.common.inet.LayerParametersImpl;
import li.cil.oc2.common.inet.MacAddress;
import li.cil.oc2.common.inet.NullLayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public final class InetUtils {
    private static int bufferChecksum(ByteBuffer buffer, int size) {
        int halfSize = size >>> 1;
        int checksum = 0;
        for (int i = 0; i < halfSize; ++i) {
            checksum += Short.toUnsignedInt(buffer.getShort());
        }
        if ((size & 1) != 0) {
            checksum += buffer.get() << 8 & 0xFFFF;
        }
        return checksum;
    }

    private static short finishChecksum(int checksum) {
        checksum = (checksum >>> 16) + (checksum & 0xFFFF);
        checksum = (checksum >>> 16) + (checksum & 0xFFFF);
        return (short)(~checksum);
    }

    public static short rfc1071Checksum(ByteBuffer buffer, int size) {
        int checksum = InetUtils.bufferChecksum(buffer, size);
        return InetUtils.finishChecksum(checksum);
    }

    public static short rfc1071Checksum(ByteBuffer buffer) {
        return InetUtils.rfc1071Checksum(buffer, buffer.remaining());
    }

    public static short transportRfc1071Checksum(ByteBuffer buffer, int srcIpAddress, int dstIpAddress, byte protocol) {
        int size = buffer.remaining();
        int checksumPart = InetUtils.bufferChecksum(buffer, size);
        int checksum = checksumPart + Byte.toUnsignedInt(protocol) + size + (srcIpAddress >>> 16) + (srcIpAddress & 0xFFFF) + (dstIpAddress >>> 16) + (dstIpAddress & 0xFFFF);
        return InetUtils.finishChecksum(checksum);
    }

    private static InetAddress getInetAddressByBytes(byte[] bytes) {
        try {
            return InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            throw new Error("unreachable", e);
        }
    }

    public static InetAddress toJavaInetAddress(int ipAddress) {
        byte[] bytes = new byte[]{(byte)(ipAddress >>> 24), (byte)(ipAddress >>> 16), (byte)(ipAddress >>> 8), (byte)ipAddress};
        return InetUtils.getInetAddressByBytes(bytes);
    }

    private static void fillLong(byte[] destination, int offset, long value) {
        for (int position = 0; position < 8; ++position) {
            destination[offset + position] = (byte)(value >>> (7 - position << 3));
        }
    }

    public static InetAddress toJavaInetAddress(long ipAddressMost, long ipAddressLeast) {
        byte[] bytes = new byte[16];
        InetUtils.fillLong(bytes, 0, ipAddressMost);
        InetUtils.fillLong(bytes, 8, ipAddressLeast);
        return InetUtils.getInetAddressByBytes(bytes);
    }

    public static void ipv4AddressToString(StringBuilder builder, int ipAddress) {
        builder.append(Integer.toUnsignedString(ipAddress >>> 24));
        builder.append('.');
        builder.append(Integer.toUnsignedString(ipAddress >>> 16 & 0xFF));
        builder.append('.');
        builder.append(Integer.toUnsignedString(ipAddress >>> 8 & 0xFF));
        builder.append('.');
        builder.append(Integer.toUnsignedString(ipAddress & 0xFF));
    }

    public static String ipv4AddressToString(int ipAddress) {
        StringBuilder stringBuilder = new StringBuilder();
        InetUtils.ipv4AddressToString(stringBuilder, ipAddress);
        return stringBuilder.toString();
    }

    private static char hexCodeToChar(int code) {
        if (code < 10) {
            return (char)(48 + code);
        }
        return (char)(65 + (code - 10));
    }

    private static void byteToHex(StringBuilder builder, byte code) {
        builder.append(InetUtils.hexCodeToChar(code >>> 4));
        builder.append(InetUtils.hexCodeToChar(code & 0xF));
    }

    public static void macAddressToString(StringBuilder builder, MacAddress macAddress) {
        short prefix = macAddress.prefix();
        int address = macAddress.address();
        InetUtils.byteToHex(builder, (byte)(prefix >>> 8));
        builder.append(':');
        InetUtils.byteToHex(builder, (byte)prefix);
        for (int i = 3; i >= 0; --i) {
            builder.append(':');
            InetUtils.byteToHex(builder, (byte)(address >>> 8 * i));
        }
    }

    public static String macAddressToString(MacAddress macAddress) {
        StringBuilder builder = new StringBuilder();
        InetUtils.macAddressToString(builder, macAddress);
        return builder.toString();
    }

    public static void socketAddressToString(StringBuilder builder, int ipAddress, short port) {
        InetUtils.ipv4AddressToString(builder, ipAddress);
        builder.append(':');
        builder.append(Short.toUnsignedInt(port));
    }

    public static byte[] quickICMPBody(ByteBuffer data) {
        int tmpPosition = data.position();
        int tmpLimit = data.limit();
        data.limit(data.capacity());
        data.position(14);
        int headerSize = (data.get() & 0xF) * 4;
        data.position(14);
        data.limit(14 + headerSize + 8);
        byte[] result = new byte[data.remaining() + 4];
        result[2] = 5;
        result[3] = -36;
        data.put(result, 4, data.remaining());
        data.limit(tmpLimit);
        data.position(tmpPosition);
        return result;
    }

    public static int javaInetAddressToIpAddress(Inet4Address address) {
        byte[] bytes = address.getAddress();
        return Byte.toUnsignedInt(bytes[0]) << 24 | Byte.toUnsignedInt(bytes[1]) << 16 | Byte.toUnsignedInt(bytes[2]) << 8 | Byte.toUnsignedInt(bytes[3]);
    }

    public static int indexOf(CharSequence string, char character, int start) {
        int length = string.length();
        for (int i = start; i < length; ++i) {
            if (string.charAt(i) != character) continue;
            return i;
        }
        return -1;
    }

    public static int surelyParseValidIpv4Address(CharSequence string) {
        int position = 0;
        int address = 0;
        for (int i = 0; i < 3; ++i) {
            int segmentEnd = InetUtils.indexOf(string, '.', position);
            address = address << 8 | Integer.parseUnsignedInt(string, position, segmentEnd, 10);
            position = segmentEnd + 1;
        }
        return address << 8 | Integer.parseUnsignedInt(string, position, string.length(), 10);
    }

    public static int parseIpv4Address(CharSequence string) throws AddressParseException {
        if (!Ipv4Space.ipAddressPattern.matcher(string).matches()) {
            throw new AddressParseException("Not an IPv4 address: " + String.valueOf(string));
        }
        return InetUtils.surelyParseValidIpv4Address(string);
    }

    private static int hexCodeToInt(char code) throws AddressParseException {
        if (code >= '0' && code <= '9') {
            return code - 48;
        }
        if (code >= 'a' && code <= 'f') {
            return code - 97 + 10;
        }
        if (code >= 'A' && code <= 'F') {
            return code - 65 + 10;
        }
        throw new AddressParseException("Illegal character '" + code + "' in address");
    }

    private static byte parseMacAddressByte(CharSequence string, int start) throws AddressParseException {
        return (byte)(InetUtils.hexCodeToInt(string.charAt(start)) << 4 | InetUtils.hexCodeToInt(string.charAt(start + 1)));
    }

    private static AddressParseException illegalDelimiter(CharSequence string, int index) {
        char illegal = string.charAt(index);
        return new AddressParseException("Illegal character '" + illegal + "' at index " + index + " in MAC address \"" + String.valueOf(string) + "\"");
    }

    public static MacAddress parseMacAddress(CharSequence string) throws AddressParseException {
        if (string.length() != 17) {
            throw new AddressParseException("MAC address length must be 17 characters: \"" + String.valueOf(string) + "\"");
        }
        byte first = InetUtils.parseMacAddressByte(string, 0);
        if (string.charAt(2) != ':') {
            throw InetUtils.illegalDelimiter(string, 2);
        }
        short prefix = (short)(first << 8 | InetUtils.parseMacAddressByte(string, 3));
        int address = 0;
        for (int i = 0; i < 4; ++i) {
            int pos = i * 3 + 5;
            if (string.charAt(pos) != ':') {
                throw InetUtils.illegalDelimiter(string, pos);
            }
            address = address << 8 | InetUtils.parseMacAddressByte(string, pos + 1);
        }
        return new MacAddress(prefix, address);
    }

    public static int getSubnetByPrefix(int prefix) {
        if (prefix > 30 || prefix < 0) {
            throw new IllegalArgumentException("Wrong subnet prefix range");
        }
        return -1 << 32 - prefix;
    }

    private static void configureIpSpace(Ipv4Space ipSpace, String hosts) {
        int i = 1;
        for (String hostString : hosts.split(",")) {
            String rangeString = hostString.trim();
            if (rangeString.isEmpty()) continue;
            try {
                ipSpace.put(rangeString);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse IPv4 address range #" + i + ": " + e.getMessage());
            }
            ++i;
        }
    }

    public static Ipv4Space computeIpSpace(String deniedHosts, String allowedHosts) {
        boolean deniedHostsIsEmpty = deniedHosts.trim().isEmpty();
        boolean allowedHostsIsEmpty = allowedHosts.trim().isEmpty();
        if (deniedHostsIsEmpty && allowedHostsIsEmpty) {
            return new Ipv4Space(Ipv4Space.Modes.DENYLIST);
        }
        if (allowedHostsIsEmpty) {
            Ipv4Space ipSpace = new Ipv4Space(Ipv4Space.Modes.DENYLIST);
            InetUtils.configureIpSpace(ipSpace, deniedHosts);
            return ipSpace;
        }
        if (deniedHostsIsEmpty) {
            Ipv4Space ipSpace = new Ipv4Space(Ipv4Space.Modes.ALLOWLIST);
            InetUtils.configureIpSpace(ipSpace, allowedHosts);
            return ipSpace;
        }
        throw new IllegalArgumentException("Both denied and allowed hosts are specified");
    }

    public static <PL, CL> PL createLayerIfNotStub(CL currentLayer, Function<CL, PL> getNextLayer) {
        if (currentLayer == NullLayer.INSTANCE) {
            return (PL)NullLayer.INSTANCE;
        }
        return getNextLayer.apply(currentLayer);
    }

    public static LayerParameters nextLayerParameters(LayerParameters layerParameters, String layerName) {
        Optional<Tag> nextLayerState = layerParameters.getSavedState().flatMap(currentLayerState -> {
            Optional<Object> optional;
            if (currentLayerState instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)currentLayerState;
                optional = Optional.ofNullable(tag.m_128423_(layerName));
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        return new LayerParametersImpl(nextLayerState, layerParameters.getInternetManager());
    }
}

