/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.network.message;

import java.util.function.Supplier;
import li.cil.oc2.common.network.Network;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.NotImplementedException;

public abstract class AbstractMessage {
    protected AbstractMessage() {
    }

    protected AbstractMessage(FriendlyByteBuf buffer) {
        this.fromBytes(buffer);
    }

    public static boolean handleMessage(AbstractMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        message.handleMessage(contextSupplier);
        return true;
    }

    public abstract void fromBytes(FriendlyByteBuf var1);

    public abstract void toBytes(FriendlyByteBuf var1);

    protected void handleMessage(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> this.handleMessage(context));
    }

    protected void handleMessage(NetworkEvent.Context context) {
        throw new NotImplementedException("Message implements neither asynchronous nor synchronous handleMessage() method.");
    }

    protected <T> void reply(T message, NetworkEvent.Context context) {
        Network.INSTANCE.reply(message, context);
    }
}

