/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.network.message;

import li.cil.oc2.common.blockentity.BusCableBlockEntity;
import li.cil.oc2.common.network.MessageUtils;
import li.cil.oc2.common.network.message.AbstractMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public abstract class BusInterfaceNameMessage
extends AbstractMessage {
    protected BlockPos pos;
    protected Direction side;
    protected String value;

    protected BusInterfaceNameMessage(BusCableBlockEntity busCable, Direction side, String value) {
        this.pos = busCable.m_58899_();
        this.side = side;
        this.value = value;
    }

    protected BusInterfaceNameMessage(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.side = (Direction)buffer.m_130066_(Direction.class);
        this.value = buffer.m_130136_(32);
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130068_((Enum)this.side);
        buffer.m_130072_(this.value, 32);
    }

    public static final class ToServer
    extends BusInterfaceNameMessage {
        public ToServer(BusCableBlockEntity busCable, Direction side, String value) {
            super(busCable, side, value);
        }

        public ToServer(FriendlyByteBuf buffer) {
            super(buffer);
        }

        @Override
        protected void handleMessage(NetworkEvent.Context context) {
            MessageUtils.withNearbyServerBlockEntityForInteraction(context, this.pos, BusCableBlockEntity.class, (player, busCable) -> busCable.setInterfaceName(this.side, this.value));
        }
    }

    public static final class ToClient
    extends BusInterfaceNameMessage {
        public ToClient(BusCableBlockEntity busCable, Direction side, String value) {
            super(busCable, side, value);
        }

        public ToClient(FriendlyByteBuf buffer) {
            super(buffer);
        }

        @Override
        protected void handleMessage(NetworkEvent.Context context) {
            MessageUtils.withClientBlockEntityAt(this.pos, BusCableBlockEntity.class, busCable -> busCable.setInterfaceName(this.side, this.value));
        }
    }
}

