/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.serialization;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import li.cil.ceres.Ceres;
import li.cil.ceres.api.DeserializationVisitor;
import li.cil.ceres.api.SerializationException;
import li.cil.ceres.api.SerializationVisitor;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Contract;

public final class NBTSerialization {
    private static final String IS_NULL_KEY = "<is_null>";
    private static final Map<Class<?>, ArraySerializer> ARRAY_SERIALIZERS = new HashMap();

    public static <T> void serialize(CompoundTag tag, T value, Class<T> type) throws SerializationException {
        Ceres.getSerializer(type).serialize((SerializationVisitor)new Serializer(tag), type, value);
    }

    public static <T> void serialize(CompoundTag tag, T value) throws SerializationException {
        Class<?> type = value.getClass();
        NBTSerialization.serialize(tag, value, type);
    }

    public static <T> CompoundTag serialize(T value, Class<T> type) throws SerializationException {
        CompoundTag tag = new CompoundTag();
        NBTSerialization.serialize(tag, value, type);
        return tag;
    }

    public static <T> CompoundTag serialize(T value) throws SerializationException {
        CompoundTag tag = new CompoundTag();
        NBTSerialization.serialize(tag, value);
        return tag;
    }

    public static <T> T deserialize(CompoundTag tag, Class<T> type, @Nullable T into) throws SerializationException {
        return (T)Ceres.getSerializer(type).deserialize((DeserializationVisitor)new Deserializer(tag), type, into);
    }

    public static <T> T deserialize(CompoundTag tag, Class<T> type) throws SerializationException {
        return NBTSerialization.deserialize(tag, type, null);
    }

    public static <T> T deserialize(CompoundTag tag, T into) throws SerializationException {
        Class<?> type = into.getClass();
        return (T)NBTSerialization.deserialize(tag, type, into);
    }

    static {
        ARRAY_SERIALIZERS.put(Boolean.TYPE, new BooleanArraySerializer());
        ARRAY_SERIALIZERS.put(Byte.TYPE, new ByteArraySerializer());
        ARRAY_SERIALIZERS.put(Character.TYPE, new CharArraySerializer());
        ARRAY_SERIALIZERS.put(Short.TYPE, new ShortArraySerializer());
        ARRAY_SERIALIZERS.put(Integer.TYPE, new IntArraySerializer());
        ARRAY_SERIALIZERS.put(Long.TYPE, new LongArraySerializer());
        ARRAY_SERIALIZERS.put(Float.TYPE, new FloatArraySerializer());
        ARRAY_SERIALIZERS.put(Double.TYPE, new DoubleArraySerializer());
        ARRAY_SERIALIZERS.put(Enum.class, new EnumArraySerializer());
        ARRAY_SERIALIZERS.put(String.class, new StringArraySerializer());
        ARRAY_SERIALIZERS.put(UUID.class, new UUIDArraySerializer());
    }

    private record Serializer(CompoundTag tag) implements SerializationVisitor
    {
        public void putBoolean(String name, boolean value) {
            this.tag.m_128379_(name, value);
        }

        public void putByte(String name, byte value) {
            this.tag.m_128344_(name, value);
        }

        public void putChar(String name, char value) {
            this.tag.m_128405_(name, (int)value);
        }

        public void putShort(String name, short value) {
            this.tag.m_128376_(name, value);
        }

        public void putInt(String name, int value) {
            this.tag.m_128405_(name, value);
        }

        public void putLong(String name, long value) {
            this.tag.m_128356_(name, value);
        }

        public void putFloat(String name, float value) {
            this.tag.m_128350_(name, value);
        }

        public void putDouble(String name, double value) {
            this.tag.m_128347_(name, value);
        }

        public void putObject(String name, Class<?> type, @Nullable Object value) throws SerializationException {
            if (this.putIsNull(name, value)) {
                return;
            }
            if (type.isArray()) {
                this.tag.m_128365_(name, this.putArray(name, type, value));
            } else if (type.isEnum()) {
                this.tag.m_128359_(name, ((Enum)value).name());
            } else if (type == String.class) {
                this.tag.m_128359_(name, (String)value);
            } else if (type == UUID.class) {
                CompoundTag uuidTag = new CompoundTag();
                uuidTag.m_128362_(name, (UUID)value);
                this.tag.m_128365_(name, (Tag)uuidTag);
            } else {
                CompoundTag valueTag = new CompoundTag();
                Ceres.getSerializer(type).serialize((SerializationVisitor)new Serializer(valueTag), type, value);
                if (!valueTag.m_128456_()) {
                    this.tag.m_128365_(name, (Tag)valueTag);
                }
            }
        }

        private Tag putArray(String name, Class<?> type, Object value) {
            ArrayComponentSerializer componentSerializer;
            Class<?> componentType = type.getComponentType();
            ArraySerializer arraySerializer = ARRAY_SERIALIZERS.get(componentType);
            if (arraySerializer != null) {
                return arraySerializer.serialize(value);
            }
            if (componentType.isArray()) {
                componentSerializer = (t, v) -> this.putArray(name, t, v);
            } else {
                li.cil.ceres.api.Serializer serializer = Ceres.getSerializer(componentType);
                componentSerializer = (t, v) -> {
                    CompoundTag tag = new CompoundTag();
                    serializer.serialize((SerializationVisitor)new Serializer(tag), t, v);
                    return tag;
                };
            }
            ListTag listTag = new ListTag();
            IntArrayList nullIndices = new IntArrayList();
            Object[] data = (Object[])value;
            for (int i = 0; i < data.length; ++i) {
                Object datum = data[i];
                if (datum == null) {
                    nullIndices.add(i);
                    continue;
                }
                if (datum.getClass() != componentType) {
                    throw new SerializationException(String.format("Polymorphism detected in generic array [%s]. This is not supported.", name));
                }
                listTag.add((Object)componentSerializer.serialize(componentType, datum));
            }
            if (nullIndices.isEmpty()) {
                return listTag;
            }
            CompoundTag arrayTag = new CompoundTag();
            arrayTag.m_128365_("value", (Tag)listTag);
            arrayTag.m_128408_("nulls", (List)nullIndices);
            return arrayTag;
        }

        @Contract(value="_, null -> true")
        private boolean putIsNull(String name, @Nullable Object value) {
            boolean isNull;
            boolean bl = isNull = value == null;
            if (isNull) {
                CompoundTag nullTag = new CompoundTag();
                nullTag.m_128379_(NBTSerialization.IS_NULL_KEY, true);
                this.tag.m_128365_(name, (Tag)nullTag);
            }
            return isNull;
        }

        @FunctionalInterface
        private static interface ArrayComponentSerializer {
            public Tag serialize(Class<?> var1, Object var2);
        }
    }

    private record Deserializer(CompoundTag tag) implements DeserializationVisitor
    {
        public boolean getBoolean(String name) {
            return this.tag.m_128471_(name);
        }

        public byte getByte(String name) {
            return this.tag.m_128445_(name);
        }

        public char getChar(String name) {
            return (char)this.tag.m_128451_(name);
        }

        public short getShort(String name) {
            return this.tag.m_128448_(name);
        }

        public int getInt(String name) {
            return this.tag.m_128451_(name);
        }

        public long getLong(String name) {
            return this.tag.m_128454_(name);
        }

        public float getFloat(String name) {
            return this.tag.m_128457_(name);
        }

        public double getDouble(String name) {
            return this.tag.m_128459_(name);
        }

        @Nullable
        public Object getObject(String name, Class<?> type, @Nullable Object into) throws SerializationException {
            if (this.isNull(name)) {
                return null;
            }
            if (!this.tag.m_128441_(name)) {
                return into;
            }
            if (type.isArray()) {
                Tag arrayTag = this.tag.m_128423_(name);
                assert (arrayTag != null);
                return Deserializer.getArray(arrayTag, type, into);
            }
            if (type.isEnum()) {
                return Enum.valueOf(type, this.tag.m_128461_(name));
            }
            if (type == String.class) {
                return this.tag.m_128461_(name);
            }
            if (type == UUID.class) {
                return this.tag.m_128469_(name).m_128342_(name);
            }
            CompoundTag valueTag = this.tag.m_128469_(name);
            return Ceres.getSerializer(type).deserialize((DeserializationVisitor)new Deserializer(valueTag), type, into);
        }

        @Nullable
        private static Object getArray(Tag tag, Class<?> type, @Nullable Object into) {
            int[] nulls;
            ListTag listTag;
            ArrayComponentDeserializer componentDeserializer;
            Class<?> componentType = type.getComponentType();
            ArraySerializer arraySerializer = ARRAY_SERIALIZERS.get(componentType);
            if (arraySerializer != null) {
                return arraySerializer.deserialize(tag, type, into);
            }
            if (componentType.isArray()) {
                componentDeserializer = Deserializer::getArray;
            } else {
                li.cil.ceres.api.Serializer serializer = Ceres.getSerializer(componentType);
                componentDeserializer = (n, t, i) -> serializer.deserialize((DeserializationVisitor)new Deserializer((CompoundTag)n), t, i);
            }
            Object[] data = (Object[])into;
            int nullsIndex = 0;
            if (tag instanceof ListTag) {
                ListTag plainListTag;
                listTag = plainListTag = (ListTag)tag;
                nulls = new int[]{};
            } else if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                listTag = (ListTag)compoundTag.m_128423_("value");
                nulls = compoundTag.m_128465_("nulls");
            } else {
                return data;
            }
            if (listTag == null) {
                return data;
            }
            int length = listTag.size() + nulls.length;
            if (data == null || data.length != length) {
                data = (Object[])Array.newInstance(componentType, length);
            }
            for (int i2 = 0; i2 < length; ++i2) {
                if (nullsIndex < nulls.length && i2 == nulls[nullsIndex]) {
                    ++nullsIndex;
                    continue;
                }
                Tag itemTag = listTag.get(i2 - nullsIndex);
                if (itemTag == null) continue;
                data[i2] = componentDeserializer.deserialize(itemTag, componentType, data[i2]);
            }
            return data;
        }

        public boolean exists(String name) {
            return this.tag.m_128441_(name);
        }

        private boolean isNull(String name) {
            return this.tag.m_128469_(name).m_128471_(NBTSerialization.IS_NULL_KEY);
        }

        @FunctionalInterface
        private static interface ArrayComponentDeserializer {
            @Nullable
            public Object deserialize(Tag var1, Class<?> var2, @Nullable Object var3);
        }
    }

    private static final class BooleanArraySerializer
    implements ArraySerializer {
        private BooleanArraySerializer() {
        }

        @Override
        public Tag serialize(Object value) {
            boolean[] data = (boolean[])value;
            byte[] convertedData = new byte[data.length];
            for (int i = 0; i < data.length; ++i) {
                convertedData[i] = data[i] ? (byte)1 : 0;
            }
            return new ByteArrayTag(convertedData);
        }

        @Override
        public Object deserialize(Tag tag, Class<?> type, @Nullable Object into) {
            boolean[] data = (boolean[])into;
            if (tag instanceof ByteArrayTag) {
                ByteArrayTag byteArrayTag = (ByteArrayTag)tag;
                byte[] convertedData = byteArrayTag.m_128227_();
                if (data == null || data.length != convertedData.length) {
                    data = new boolean[convertedData.length];
                }
                for (int i = 0; i < convertedData.length; ++i) {
                    data[i] = convertedData[i] != 0;
                }
            }
            return data;
        }
    }

    private static final class ByteArraySerializer
    implements ArraySerializer {
        private ByteArraySerializer() {
        }

        @Override
        public Tag serialize(Object value) {
            return new ByteArrayTag((byte[])value);
        }

        @Override
        public Object deserialize(Tag tag, Class<?> type, @Nullable Object into) {
            byte[] data = (byte[])into;
            if (tag instanceof ByteArrayTag) {
                ByteArrayTag byteArrayTag = (ByteArrayTag)tag;
                byte[] serializedData = byteArrayTag.m_128227_();
                if (data == null || data.length != serializedData.length) {
                    return serializedData;
                }
                System.arraycopy(serializedData, 0, data, 0, serializedData.length);
            }
            return data;
        }
    }

    private static final class CharArraySerializer
    implements ArraySerializer {
        private CharArraySerializer() {
        }

        @Override
        public Tag serialize(Object value) {
            char[] data = (char[])value;
            int[] convertedData = new int[data.length];
            for (int i = 0; i < data.length; ++i) {
                convertedData[i] = data[i];
            }
            return new IntArrayTag(convertedData);
        }

        @Override
        public Object deserialize(Tag tag, Class<?> type, @Nullable Object into) {
            char[] data = (char[])into;
            if (tag instanceof IntArrayTag) {
                IntArrayTag intArrayTag = (IntArrayTag)tag;
                int[] convertedData = intArrayTag.m_128648_();
                if (data == null || data.length != convertedData.length) {
                    data = new char[convertedData.length];
                }
                for (int i = 0; i < convertedData.length; ++i) {
                    data[i] = (char)convertedData[i];
                }
            }
            return data;
        }
    }

    private static final class ShortArraySerializer
    implements ArraySerializer {
        private ShortArraySerializer() {
        }

        @Override
        public Tag serialize(Object value) {
            short[] data = (short[])value;
            int[] convertedData = new int[data.length];
            for (int i = 0; i < data.length; ++i) {
                convertedData[i] = data[i];
            }
            return new IntArrayTag(convertedData);
        }

        @Override
        public Object deserialize(Tag tag, Class<?> type, @Nullable Object into) {
            short[] data = (short[])into;
            if (tag instanceof IntArrayTag) {
                IntArrayTag intArrayTag = (IntArrayTag)tag;
                int[] convertedData = intArrayTag.m_128648_();
                if (data == null || data.length != convertedData.length) {
                    data = new short[convertedData.length];
                }
                for (int i = 0; i < convertedData.length; ++i) {
                    data[i] = (short)convertedData[i];
                }
            }
            return data;
        }
    }

    private static final class IntArraySerializer
    implements ArraySerializer {
        private IntArraySerializer() {
        }

        @Override
        public Tag serialize(Object value) {
            return new IntArrayTag((int[])value);
        }

        @Override
        public Object deserialize(Tag tag, Class<?> type, @Nullable Object into) {
            int[] data = (int[])into;
            if (tag instanceof IntArrayTag) {
                IntArrayTag intArrayTag = (IntArrayTag)tag;
                int[] serializedData = intArrayTag.m_128648_();
                if (data == null || data.length != serializedData.length) {
                    return serializedData;
                }
                System.arraycopy(serializedData, 0, data, 0, serializedData.length);
            }
            return data;
        }
    }

    private static final class LongArraySerializer
    implements ArraySerializer {
        private LongArraySerializer() {
        }

        @Override
        public Tag serialize(Object value) {
            return new LongArrayTag((long[])value);
        }

        @Override
        public Object deserialize(Tag tag, Class<?> type, @Nullable Object into) {
            long[] data = (long[])into;
            if (tag instanceof LongArrayTag) {
                LongArrayTag longArrayTag = (LongArrayTag)tag;
                long[] serializedData = longArrayTag.m_128851_();
                if (data == null || data.length != serializedData.length) {
                    return serializedData;
                }
                System.arraycopy(serializedData, 0, data, 0, serializedData.length);
            }
            return data;
        }
    }

    private static final class FloatArraySerializer
    implements ArraySerializer {
        private FloatArraySerializer() {
        }

        @Override
        public Tag serialize(Object value) {
            float[] data = (float[])value;
            int[] convertedData = new int[data.length];
            for (int i = 0; i < data.length; ++i) {
                convertedData[i] = Float.floatToRawIntBits(data[i]);
            }
            return new IntArrayTag(convertedData);
        }

        @Override
        public Object deserialize(Tag tag, Class<?> type, @Nullable Object into) {
            float[] data = (float[])into;
            if (tag instanceof IntArrayTag) {
                IntArrayTag intArrayTag = (IntArrayTag)tag;
                int[] convertedData = intArrayTag.m_128648_();
                if (data == null || data.length != convertedData.length) {
                    data = new float[convertedData.length];
                }
                for (int i = 0; i < convertedData.length; ++i) {
                    data[i] = Float.intBitsToFloat(convertedData[i]);
                }
            }
            return data;
        }
    }

    private static final class DoubleArraySerializer
    implements ArraySerializer {
        private DoubleArraySerializer() {
        }

        @Override
        public Tag serialize(Object value) {
            double[] data = (double[])value;
            long[] convertedData = new long[data.length];
            for (int i = 0; i < data.length; ++i) {
                convertedData[i] = Double.doubleToRawLongBits(data[i]);
            }
            return new LongArrayTag(convertedData);
        }

        @Override
        public Object deserialize(Tag tag, Class<?> type, @Nullable Object into) {
            double[] data = (double[])into;
            if (tag instanceof LongArrayTag) {
                LongArrayTag longArrayTag = (LongArrayTag)tag;
                long[] convertedData = longArrayTag.m_128851_();
                if (data == null || data.length != convertedData.length) {
                    data = new double[convertedData.length];
                }
                for (int i = 0; i < convertedData.length; ++i) {
                    data[i] = Double.longBitsToDouble(convertedData[i]);
                }
            }
            return data;
        }
    }

    private static final class EnumArraySerializer
    implements ArraySerializer {
        private EnumArraySerializer() {
        }

        @Override
        public Tag serialize(Object value) {
            Enum[] data = (Enum[])value;
            int[] convertedData = new int[data.length];
            for (int i = 0; i < data.length; ++i) {
                convertedData[i] = data[i].ordinal();
            }
            return new IntArrayTag(convertedData);
        }

        @Override
        public Object deserialize(Tag tag, Class<?> type, @Nullable Object into) {
            Class<?> componentType = type.getComponentType();
            ?[] enumConstants = componentType.getEnumConstants();
            Enum[] data = (Enum[])into;
            if (tag instanceof IntArrayTag) {
                IntArrayTag intArrayTag = (IntArrayTag)tag;
                int[] serializedData = intArrayTag.m_128648_();
                if (data == null || data.length != serializedData.length) {
                    data = (Enum[])Array.newInstance(componentType, serializedData.length);
                }
                for (int i = 0; i < serializedData.length; ++i) {
                    data[i] = (Enum)enumConstants[serializedData[i]];
                }
            }
            return data;
        }
    }

    private static final class StringArraySerializer
    implements ArraySerializer {
        private StringArraySerializer() {
        }

        @Override
        public Tag serialize(Object value) {
            String[] data = (String[])value;
            ListTag list = new ListTag();
            for (String datum : data) {
                list.add((Object)StringTag.m_129297_((String)datum));
            }
            return list;
        }

        @Override
        public Object deserialize(Tag tag, Class<?> type, @Nullable Object into) {
            ListTag serializedData;
            String[] data = (String[])into;
            if (tag instanceof ListTag && ((serializedData = (ListTag)tag).isEmpty() || serializedData.m_7264_() == 8)) {
                if (data == null || data.length != serializedData.size()) {
                    data = new String[serializedData.size()];
                }
                for (int i = 0; i < serializedData.size(); ++i) {
                    data[i] = serializedData.m_128778_(i);
                }
            }
            return data;
        }
    }

    private static final class UUIDArraySerializer
    implements ArraySerializer {
        private UUIDArraySerializer() {
        }

        @Override
        public Tag serialize(Object value) {
            UUID[] data = (UUID[])value;
            ListTag list = new ListTag();
            for (UUID datum : data) {
                list.add((Object)StringTag.m_129297_((String)datum.toString()));
            }
            return list;
        }

        @Override
        public Object deserialize(Tag tag, Class<?> type, @Nullable Object into) {
            ListTag serializedData;
            UUID[] data = (UUID[])into;
            if (tag instanceof ListTag && ((serializedData = (ListTag)tag).isEmpty() || serializedData.m_7264_() == 8)) {
                if (data == null || data.length != serializedData.size()) {
                    data = new UUID[serializedData.size()];
                }
                for (int i = 0; i < serializedData.size(); ++i) {
                    data[i] = UUID.fromString(serializedData.m_128778_(i));
                }
            }
            return data;
        }
    }

    private static interface ArraySerializer {
        public Tag serialize(Object var1);

        @Nullable
        public Object deserialize(Tag var1, Class<?> var2, @Nullable Object var3);
    }
}

