/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import li.cil.oc2.api.bus.device.DeviceType;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.block.EnergyConsumingBlock;
import li.cil.oc2.common.bus.device.util.Devices;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.tags.ItemTags;
import li.cil.oc2.common.util.NBTUtils;
import li.cil.oc2.common.util.RegistryUtils;
import li.cil.oc2.common.util.TextFormatUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public final class TooltipUtils {
    private static final MutableComponent DEVICE_NEEDS_REBOOT = Component.m_237115_((String)Constants.TOOLTIP_DEVICE_NEEDS_REBOOT).m_130938_(s -> s.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.YELLOW)));
    private static final ThreadLocal<List<ItemStack>> ITEM_STACKS = ThreadLocal.withInitial(ArrayList::new);
    private static final ThreadLocal<IntList> ITEM_STACKS_SIZES = ThreadLocal.withInitial(IntArrayList::new);

    public static void drawTooltip(GuiGraphics graphics, List<? extends FormattedText> tooltip, int x, int y) {
        TooltipUtils.drawTooltip(graphics, tooltip, x, y, 200, ItemStack.f_41583_);
    }

    public static void drawTooltip(GuiGraphics graphics, List<? extends FormattedText> tooltip, int x, int y, int widthHint) {
        TooltipUtils.drawTooltip(graphics, tooltip, x, y, widthHint, ItemStack.f_41583_);
    }

    public static void drawTooltip(GuiGraphics graphics, List<? extends FormattedText> tooltip, int x, int y, int widthHint, ItemStack itemStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen == null) {
            return;
        }
        int availableWidth = Math.max(x, screen.f_96543_ - x);
        int targetWidth = Math.min(availableWidth, widthHint);
        Font font = ForgeHooksClient.getTooltipFont((ItemStack)itemStack, (Font)minecraft.f_91062_);
        boolean needsWrapping = tooltip.stream().anyMatch(line -> font.m_92852_(line) > targetWidth);
        if (!needsWrapping) {
            graphics.renderComponentTooltip(font, tooltip, x, y, itemStack);
        } else {
            StringSplitter splitter = font.m_92865_();
            List wrappedTooltip = tooltip.stream().flatMap(line -> splitter.m_92414_(line, targetWidth, Style.f_131099_).stream()).toList();
            graphics.renderComponentTooltip(font, wrappedTooltip, x, y, itemStack);
        }
    }

    public static void tryAddDescription(ItemStack stack, List<Component> tooltip) {
        MutableComponent energy;
        int energyConsumption;
        BlockItem blockItem;
        Item item;
        if (stack.m_41619_()) {
            return;
        }
        String translationKey = stack.m_41778_() + ".desc";
        Language language = Language.m_128107_();
        if (language.m_6722_(translationKey)) {
            MutableComponent description = Component.m_237115_((String)translationKey);
            tooltip.add((Component)TextFormatUtils.withFormat(description, ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ItemTags.DEVICE_NEEDS_REBOOT)) {
            tooltip.add((Component)DEVICE_NEEDS_REBOOT);
        }
        if ((item = stack.m_41720_()) instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof EnergyConsumingBlock) {
            EnergyConsumingBlock energyConsumingBlock = (EnergyConsumingBlock)item;
            energyConsumption = energyConsumingBlock.getEnergyConsumption();
        } else {
            ItemDeviceQuery query = Devices.makeQuery(stack);
            energyConsumption = Devices.getEnergyConsumption(query);
        }
        if (energyConsumption > 0) {
            energy = TextFormatUtils.withFormat(String.valueOf(energyConsumption), ChatFormatting.GREEN);
            tooltip.add((Component)TextFormatUtils.withFormat(Component.m_237110_((String)Constants.TOOLTIP_ENERGY_CONSUMPTION, (Object[])new Object[]{energy}), ChatFormatting.GRAY));
        }
        if (stack.m_41720_() == Items.INTERNET_GATEWAY.get()) {
            if (Config.gatewayEnergyPerPacket > 0) {
                energy = TextFormatUtils.withFormat(String.valueOf(Config.gatewayEnergyPerPacket), ChatFormatting.GREEN);
                tooltip.add((Component)TextFormatUtils.withFormat(Component.m_237110_((String)Constants.TOOLTIP_INTERNET_ENERGY_PER_PACKET, (Object[])new Object[]{energy}), ChatFormatting.GRAY));
            }
            if (!Config.internetCardEnabled) {
                tooltip.add((Component)TextFormatUtils.withFormat(Component.m_237115_((String)Constants.TOOLTIP_INTERNET_DISABLED), ChatFormatting.RED));
            }
        }
    }

    public static void addBlockEntityInventoryInformation(ItemStack stack, List<Component> tooltip) {
        TooltipUtils.addInventoryInformation(NBTUtils.getChildTag(stack.m_41783_(), "BlockEntityTag", "items"), tooltip);
    }

    public static void addEntityInventoryInformation(ItemStack stack, List<Component> tooltip) {
        TooltipUtils.addInventoryInformation(NBTUtils.getChildTag(stack.m_41783_(), "oc2r", "items"), tooltip);
    }

    public static void addInventoryInformation(CompoundTag itemsTag, List<Component> tooltip) {
        TooltipUtils.addInventoryInformation(itemsTag, tooltip, TooltipUtils.getDeviceTypeNames());
    }

    public static void addInventoryInformation(CompoundTag itemsTag, List<Component> tooltip, String ... subInventoryNames) {
        List<ItemStack> itemStacks = ITEM_STACKS.get();
        itemStacks.clear();
        IntList itemStackSizes = ITEM_STACKS_SIZES.get();
        itemStackSizes.clear();
        TooltipUtils.collectItemStacks(itemsTag, itemStacks, itemStackSizes);
        for (String subInventoryName : subInventoryNames) {
            if (!itemsTag.m_128425_(subInventoryName, 10)) continue;
            TooltipUtils.collectItemStacks(itemsTag.m_128469_(subInventoryName), itemStacks, itemStackSizes);
        }
        for (int i = 0; i < itemStacks.size(); ++i) {
            ItemStack itemStack = itemStacks.get(i);
            tooltip.add((Component)Component.m_237113_((String)"- ").m_7220_(itemStack.m_41611_()).m_130938_(style -> style.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY))).m_7220_((Component)Component.m_237113_((String)" x").m_130946_(String.valueOf(itemStackSizes.getInt(i))).m_130938_(style -> style.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_GRAY)))));
        }
    }

    public static void addEntityEnergyInformation(ItemStack stack, List<Component> tooltip) {
        stack.getCapability(Capabilities.energyStorage()).ifPresent(energy -> {
            if (energy.getEnergyStored() == 0) {
                return;
            }
            MutableComponent value = TextFormatUtils.withFormat(energy.getEnergyStored() + "/" + energy.getMaxEnergyStored(), ChatFormatting.GREEN);
            tooltip.add((Component)TextFormatUtils.withFormat(Component.m_237110_((String)Constants.TOOLTIP_ENERGY, (Object[])new Object[]{value}), ChatFormatting.GRAY));
        });
    }

    public static void addEnergyConsumption(double value, List<Component> tooltip) {
        if (value > 0.0) {
            tooltip.add((Component)TextFormatUtils.withFormat(Component.m_237110_((String)Constants.TOOLTIP_ENERGY_CONSUMPTION, (Object[])new Object[]{TextFormatUtils.withFormat(new DecimalFormat("#.##").format(value), ChatFormatting.GREEN)}), ChatFormatting.GRAY));
        }
    }

    private static String[] getDeviceTypeNames() {
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(DeviceType.REGISTRY);
        if (registry != null) {
            return (String[])registry.getValues().stream().map(RegistryUtils::key).toArray(String[]::new);
        }
        return new String[0];
    }

    private static void collectItemStacks(CompoundTag tag, List<ItemStack> stacks, IntList stackSizes) {
        ListTag itemsTag = tag.m_128437_("Items", 10);
        for (int i = 0; i < itemsTag.size(); ++i) {
            CompoundTag itemTag = itemsTag.m_128728_(i);
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)itemTag);
            boolean didMerge = false;
            for (int j = 0; j < stacks.size(); ++j) {
                ItemStack existingStack = stacks.get(j);
                if (!ItemStack.m_41728_((ItemStack)existingStack, (ItemStack)itemStack) || !ItemStack.m_41728_((ItemStack)existingStack, (ItemStack)itemStack)) continue;
                int existingCount = stackSizes.getInt(j);
                stackSizes.set(j, existingCount + itemStack.m_41613_());
                didMerge = true;
                break;
            }
            if (didMerge) continue;
            stacks.add(itemStack);
            stackSizes.add(itemStack.m_41613_());
        }
    }
}

