/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import li.cil.ceres.api.Serialized;
import li.cil.oc2.api.bus.device.data.BlockDeviceData;
import li.cil.oc2.common.bus.device.data.FileSystems;
import li.cil.oc2.common.vm.MinecraftRealTimeCounter;
import li.cil.oc2.common.vm.context.global.GlobalVMContext;
import li.cil.sedna.api.Interrupt;
import li.cil.sedna.api.device.BlockDevice;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.device.rtc.RealTimeCounter;
import li.cil.sedna.buildroot.Buildroot;
import li.cil.sedna.device.block.ByteBufferBlockDevice;
import li.cil.sedna.device.rtc.GoldfishRTC;
import li.cil.sedna.device.rtc.SystemTimeRealTimeCounter;
import li.cil.sedna.device.serial.UART16550A;
import li.cil.sedna.device.virtio.AbstractVirtIODevice;
import li.cil.sedna.device.virtio.VirtIOBlockDevice;
import li.cil.sedna.device.virtio.VirtIOConsoleDevice;
import li.cil.sedna.device.virtio.VirtIOFileSystemDevice;

public final class BuiltinDevices {
    public static final int RTC_HOST_INTERRUPT = 1;
    public static final int RTC_MINECRAFT_INTERRUPT = 2;
    public static final int RPC_INTERRUPT = 3;
    private static final int UART_INTERRUPT = 4;
    private static final int VFS_INTERRUPT = 5;
    private static final int BFS_INTERRUPT = 6;
    private static final int RFS_INTERRUPT = 7;
    public final MinecraftRealTimeCounter rtcMinecraft = new MinecraftRealTimeCounter();
    @Serialized
    public final VirtIOConsoleDevice rpcSerialDevice;
    @Serialized
    public final UART16550A uart;
    @Serialized
    public final VirtIOFileSystemDevice vfs;
    @Serialized
    public VirtIOBlockDevice bfs;
    @Serialized
    public VirtIOBlockDevice rfs;

    public BuiltinDevices(GlobalVMContext context) {
        BuiltinDevices.initialize(context, new GoldfishRTC(SystemTimeRealTimeCounter.get()), 1, GoldfishRTC::getInterrupt);
        BuiltinDevices.initialize(context, new GoldfishRTC((RealTimeCounter)this.rtcMinecraft), 2, GoldfishRTC::getInterrupt);
        this.rpcSerialDevice = BuiltinDevices.initialize(context, new VirtIOConsoleDevice(context.getMemoryMap()), 3, AbstractVirtIODevice::getInterrupt);
        this.uart = BuiltinDevices.initialize(context, new UART16550A(), 4, UART16550A::getInterrupt);
        this.vfs = BuiltinDevices.initialize(context, new VirtIOFileSystemDevice(context.getMemoryMap(), "builtin", FileSystems.getLayeredFileSystem()), 5, AbstractVirtIODevice::getInterrupt);
        InputStream ris = Buildroot.getRootFilesystem();
        try {
            BlockDeviceData bfsd = FileSystems.getBlockByName("bootfs");
            this.bfs = bfsd != null ? BuiltinDevices.initialize(context, new VirtIOBlockDevice(context.getMemoryMap(), bfsd.getBlockDevice()), 6, AbstractVirtIODevice::getInterrupt) : null;
            this.rfs = BuiltinDevices.initialize(context, new VirtIOBlockDevice(context.getMemoryMap(), (BlockDevice)ByteBufferBlockDevice.createFromStream((InputStream)ris, (boolean)true)), 7, AbstractVirtIODevice::getInterrupt);
        }
        catch (IOException e) {
            System.out.println("Failed to load lower block device");
        }
    }

    private static <T extends MemoryMappedDevice> T initialize(GlobalVMContext context, T device, int interrupt, Function<T, Interrupt> interruptSupplier) {
        if (!context.getInterruptAllocator().claimInterrupt(interrupt)) {
            throw new IllegalStateException();
        }
        interruptSupplier.apply(device).set(interrupt, context.getInterruptController());
        context.getMemoryRangeAllocator().claimMemoryRange(device);
        return device;
    }
}

