/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.jcodec.codecs.h264.decode.aso;

import li.cil.oc2.jcodec.codecs.h264.decode.aso.MBToSliceGroupMap;
import li.cil.oc2.jcodec.codecs.h264.decode.aso.Mapper;

public final class PrebuiltMBlockMapper
implements Mapper {
    private final MBToSliceGroupMap map;
    private final int firstMBInSlice;
    private final int groupId;
    private final int picWidthInMbs;
    private final int indexOfFirstMb;

    public PrebuiltMBlockMapper(MBToSliceGroupMap map, int firstMBInSlice, int picWidthInMbs) {
        this.map = map;
        this.firstMBInSlice = firstMBInSlice;
        this.groupId = map.groups()[firstMBInSlice];
        this.picWidthInMbs = picWidthInMbs;
        this.indexOfFirstMb = map.indices()[firstMBInSlice];
    }

    @Override
    public int getAddress(int mbIndex) {
        return this.map.inverse()[this.groupId][mbIndex + this.indexOfFirstMb];
    }

    @Override
    public boolean leftAvailable(int mbIndex) {
        int mbAddr = this.map.inverse()[this.groupId][mbIndex + this.indexOfFirstMb];
        int leftMBAddr = mbAddr - 1;
        return leftMBAddr >= this.firstMBInSlice && mbAddr % this.picWidthInMbs != 0 && this.map.groups()[leftMBAddr] == this.groupId;
    }

    @Override
    public boolean topAvailable(int mbIndex) {
        int mbAddr = this.map.inverse()[this.groupId][mbIndex + this.indexOfFirstMb];
        int topMBAddr = mbAddr - this.picWidthInMbs;
        return topMBAddr >= this.firstMBInSlice && this.map.groups()[topMBAddr] == this.groupId;
    }

    @Override
    public int getMbX(int index) {
        return this.getAddress(index) % this.picWidthInMbs;
    }

    @Override
    public int getMbY(int index) {
        return this.getAddress(index) / this.picWidthInMbs;
    }

    @Override
    public boolean topRightAvailable(int mbIndex) {
        int mbAddr = this.map.inverse()[this.groupId][mbIndex + this.indexOfFirstMb];
        int topRMBAddr = mbAddr - this.picWidthInMbs + 1;
        return topRMBAddr >= this.firstMBInSlice && (mbAddr + 1) % this.picWidthInMbs != 0 && this.map.groups()[topRMBAddr] == this.groupId;
    }

    @Override
    public boolean topLeftAvailable(int mbIndex) {
        int mbAddr = this.map.inverse()[this.groupId][mbIndex + this.indexOfFirstMb];
        int topLMBAddr = mbAddr - this.picWidthInMbs - 1;
        return topLMBAddr >= this.firstMBInSlice && mbAddr % this.picWidthInMbs != 0 && this.map.groups()[topLMBAddr] == this.groupId;
    }
}

