/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.jcodec.codecs.h264.io.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import li.cil.oc2.jcodec.codecs.h264.H264Const;
import li.cil.oc2.jcodec.codecs.h264.decode.CAVLCReader;
import li.cil.oc2.jcodec.codecs.h264.io.model.AspectRatio;
import li.cil.oc2.jcodec.codecs.h264.io.model.HRDParameters;
import li.cil.oc2.jcodec.codecs.h264.io.model.VUIParameters;
import li.cil.oc2.jcodec.codecs.h264.io.write.CAVLCWriter;
import li.cil.oc2.jcodec.common.io.BitReader;
import li.cil.oc2.jcodec.common.io.BitWriter;
import li.cil.oc2.jcodec.common.model.ColorSpace;

public final class SeqParameterSet {
    public int picOrderCntType;
    public boolean fieldPicFlag;
    public boolean deltaPicOrderAlwaysZeroFlag;
    public boolean mbAdaptiveFrameFieldFlag;
    public boolean direct8x8InferenceFlag;
    public ColorSpace chromaFormatIdc;
    public int log2MaxFrameNumMinus4;
    public int log2MaxPicOrderCntLsbMinus4;
    public int picHeightInMapUnitsMinus1;
    public int picWidthInMbsMinus1;
    public int bitDepthLumaMinus8;
    public int bitDepthChromaMinus8;
    public boolean qpprimeYZeroTransformBypassFlag;
    public int profileIdc;
    public boolean constraintSet0Flag;
    public boolean constraintSet1Flag;
    public boolean constraintSet2Flag;
    public boolean constraintSet3Flag;
    public boolean constraintSet4Flag;
    public boolean constraintSet5Flag;
    public int levelIdc;
    public int seqParameterSetId;
    public boolean separateColourPlaneFlag;
    public int offsetForNonRefPic;
    public int offsetForTopToBottomField;
    public int numRefFrames;
    public boolean gapsInFrameNumValueAllowedFlag;
    public boolean frameMbsOnlyFlag;
    public boolean frameCroppingFlag;
    public int frameCropLeftOffset;
    public int frameCropRightOffset;
    public int frameCropTopOffset;
    public int frameCropBottomOffset;
    public int[] offsetForRefFrame;
    public VUIParameters vuiParams;
    public int[][] scalingMatrix;
    public int numRefFramesInPicOrderCntCycle;

    public static ColorSpace getColor(int id) {
        return switch (id) {
            case 0 -> ColorSpace.MONO;
            case 1 -> ColorSpace.YUV420J;
            case 2 -> ColorSpace.YUV422;
            case 3 -> ColorSpace.YUV444;
            default -> throw new RuntimeException("Colorspace not supported");
        };
    }

    public static int fromColor(ColorSpace color) {
        if (color == ColorSpace.MONO) {
            return 0;
        }
        if (color == ColorSpace.YUV420J) {
            return 1;
        }
        if (color == ColorSpace.YUV422) {
            return 2;
        }
        if (color == ColorSpace.YUV444) {
            return 3;
        }
        throw new RuntimeException("Colorspace not supported");
    }

    public static SeqParameterSet read(ByteBuffer is) {
        boolean vuiParametersPresentFlag;
        BitReader _in = BitReader.createBitReader(is);
        SeqParameterSet sps = new SeqParameterSet();
        sps.profileIdc = CAVLCReader.readNBit(_in, 8);
        sps.constraintSet0Flag = CAVLCReader.readBool(_in);
        sps.constraintSet1Flag = CAVLCReader.readBool(_in);
        sps.constraintSet2Flag = CAVLCReader.readBool(_in);
        sps.constraintSet3Flag = CAVLCReader.readBool(_in);
        sps.constraintSet4Flag = CAVLCReader.readBool(_in);
        sps.constraintSet5Flag = CAVLCReader.readBool(_in);
        CAVLCReader.readNBit(_in, 2);
        sps.levelIdc = CAVLCReader.readNBit(_in, 8);
        sps.seqParameterSetId = CAVLCReader.readUE(_in);
        if (sps.profileIdc == 100 || sps.profileIdc == 110 || sps.profileIdc == 122 || sps.profileIdc == 144) {
            sps.chromaFormatIdc = SeqParameterSet.getColor(CAVLCReader.readUE(_in));
            if (sps.chromaFormatIdc == ColorSpace.YUV444) {
                sps.separateColourPlaneFlag = CAVLCReader.readBool(_in);
            }
            sps.bitDepthLumaMinus8 = CAVLCReader.readUE(_in);
            sps.bitDepthChromaMinus8 = CAVLCReader.readUE(_in);
            sps.qpprimeYZeroTransformBypassFlag = CAVLCReader.readBool(_in);
            boolean seqScalingMatrixPresent = CAVLCReader.readBool(_in);
            if (seqScalingMatrixPresent) {
                SeqParameterSet.readScalingListMatrix(_in, sps);
            }
        } else {
            sps.chromaFormatIdc = ColorSpace.YUV420J;
        }
        sps.log2MaxFrameNumMinus4 = CAVLCReader.readUE(_in);
        sps.picOrderCntType = CAVLCReader.readUE(_in);
        if (sps.picOrderCntType == 0) {
            sps.log2MaxPicOrderCntLsbMinus4 = CAVLCReader.readUE(_in);
        } else if (sps.picOrderCntType == 1) {
            sps.deltaPicOrderAlwaysZeroFlag = CAVLCReader.readBool(_in);
            sps.offsetForNonRefPic = CAVLCReader.readSE(_in);
            sps.offsetForTopToBottomField = CAVLCReader.readSE(_in);
            sps.numRefFramesInPicOrderCntCycle = CAVLCReader.readUE(_in);
            sps.offsetForRefFrame = new int[sps.numRefFramesInPicOrderCntCycle];
            for (int i = 0; i < sps.numRefFramesInPicOrderCntCycle; ++i) {
                sps.offsetForRefFrame[i] = CAVLCReader.readSE(_in);
            }
        }
        sps.numRefFrames = CAVLCReader.readUE(_in);
        sps.gapsInFrameNumValueAllowedFlag = CAVLCReader.readBool(_in);
        sps.picWidthInMbsMinus1 = CAVLCReader.readUE(_in);
        sps.picHeightInMapUnitsMinus1 = CAVLCReader.readUE(_in);
        sps.frameMbsOnlyFlag = CAVLCReader.readBool(_in);
        if (!sps.frameMbsOnlyFlag) {
            sps.mbAdaptiveFrameFieldFlag = CAVLCReader.readBool(_in);
        }
        sps.direct8x8InferenceFlag = CAVLCReader.readBool(_in);
        sps.frameCroppingFlag = CAVLCReader.readBool(_in);
        if (sps.frameCroppingFlag) {
            sps.frameCropLeftOffset = CAVLCReader.readUE(_in);
            sps.frameCropRightOffset = CAVLCReader.readUE(_in);
            sps.frameCropTopOffset = CAVLCReader.readUE(_in);
            sps.frameCropBottomOffset = CAVLCReader.readUE(_in);
        }
        if (vuiParametersPresentFlag = CAVLCReader.readBool(_in)) {
            sps.vuiParams = SeqParameterSet.readVUIParameters(_in);
        }
        return sps;
    }

    public static void writeScalingList(BitWriter out, int[][] scalingMatrix, int which) {
        boolean useDefaultScalingMatrixFlag = switch (which) {
            case 0 -> Arrays.equals(scalingMatrix[which], H264Const.defaultScalingList4x4Intra);
            case 1, 2 -> Arrays.equals(scalingMatrix[which], scalingMatrix[0]);
            case 3 -> Arrays.equals(scalingMatrix[which], H264Const.defaultScalingList4x4Inter);
            case 4, 5 -> Arrays.equals(scalingMatrix[which], scalingMatrix[3]);
            case 6 -> Arrays.equals(scalingMatrix[which], H264Const.defaultScalingList8x8Intra);
            case 7 -> Arrays.equals(scalingMatrix[which], H264Const.defaultScalingList8x8Inter);
            default -> false;
        };
        int[] scalingList = scalingMatrix[which];
        if (useDefaultScalingMatrixFlag) {
            CAVLCWriter.writeSE(out, -8);
            return;
        }
        int lastScale = 8;
        for (int i : scalingList) {
            int deltaScale = i - lastScale - 256;
            CAVLCWriter.writeSE(out, deltaScale);
            lastScale = i;
        }
    }

    public static int[] readScalingList(BitReader src, int sizeOfScalingList) {
        int[] scalingList = new int[sizeOfScalingList];
        int lastScale = 8;
        int nextScale = 8;
        for (int j = 0; j < sizeOfScalingList; ++j) {
            if (nextScale != 0) {
                int deltaScale = CAVLCReader.readSE(src);
                nextScale = (lastScale + deltaScale + 256) % 256;
                if (j == 0 && nextScale == 0) {
                    return null;
                }
            }
            scalingList[j] = nextScale == 0 ? lastScale : nextScale;
            lastScale = scalingList[j];
        }
        return scalingList;
    }

    private static void readScalingListMatrix(BitReader src, SeqParameterSet sps) {
        sps.scalingMatrix = new int[8][];
        for (int i = 0; i < 8; ++i) {
            boolean seqScalingListPresentFlag = CAVLCReader.readBool(src);
            if (!seqScalingListPresentFlag) continue;
            int scalingListSize = i < 6 ? 16 : 64;
            sps.scalingMatrix[i] = SeqParameterSet.readScalingList(src, scalingListSize);
        }
    }

    private static VUIParameters readVUIParameters(BitReader _in) {
        boolean vclHRDParametersPresentFlag;
        boolean nalHRDParametersPresentFlag;
        VUIParameters vuip = new VUIParameters();
        vuip.aspectRatioInfoPresentFlag = CAVLCReader.readBool(_in);
        if (vuip.aspectRatioInfoPresentFlag) {
            vuip.aspectRatio = AspectRatio.fromValue(CAVLCReader.readNBit(_in, 8));
            if (vuip.aspectRatio == AspectRatio.Extended_SAR) {
                vuip.sarWidth = CAVLCReader.readNBit(_in, 16);
                vuip.sarHeight = CAVLCReader.readNBit(_in, 16);
            }
        }
        vuip.overscanInfoPresentFlag = CAVLCReader.readBool(_in);
        if (vuip.overscanInfoPresentFlag) {
            vuip.overscanAppropriateFlag = CAVLCReader.readBool(_in);
        }
        vuip.videoSignalTypePresentFlag = CAVLCReader.readBool(_in);
        if (vuip.videoSignalTypePresentFlag) {
            vuip.videoFormat = CAVLCReader.readNBit(_in, 3);
            vuip.videoFullRangeFlag = CAVLCReader.readBool(_in);
            vuip.colourDescriptionPresentFlag = CAVLCReader.readBool(_in);
            if (vuip.colourDescriptionPresentFlag) {
                vuip.colourPrimaries = CAVLCReader.readNBit(_in, 8);
                vuip.transferCharacteristics = CAVLCReader.readNBit(_in, 8);
                vuip.matrixCoefficients = CAVLCReader.readNBit(_in, 8);
            }
        }
        vuip.chromaLocInfoPresentFlag = CAVLCReader.readBool(_in);
        if (vuip.chromaLocInfoPresentFlag) {
            vuip.chromaSampleLocTypeTopField = CAVLCReader.readUE(_in);
            vuip.chromaSampleLocTypeBottomField = CAVLCReader.readUE(_in);
        }
        vuip.timingInfoPresentFlag = CAVLCReader.readBool(_in);
        if (vuip.timingInfoPresentFlag) {
            vuip.numUnitsInTick = CAVLCReader.readNBit(_in, 32);
            vuip.timeScale = CAVLCReader.readNBit(_in, 32);
            vuip.fixedFrameRateFlag = CAVLCReader.readBool(_in);
        }
        if (nalHRDParametersPresentFlag = CAVLCReader.readBool(_in)) {
            vuip.nalHRDParams = SeqParameterSet.readHRDParameters(_in);
        }
        if (vclHRDParametersPresentFlag = CAVLCReader.readBool(_in)) {
            vuip.vclHRDParams = SeqParameterSet.readHRDParameters(_in);
        }
        if (nalHRDParametersPresentFlag || vclHRDParametersPresentFlag) {
            vuip.lowDelayHrdFlag = CAVLCReader.readBool(_in);
        }
        vuip.picStructPresentFlag = CAVLCReader.readBool(_in);
        boolean bitstreamRestrictionFlag = CAVLCReader.readBool(_in);
        if (bitstreamRestrictionFlag) {
            vuip.bitstreamRestriction = new VUIParameters.BitstreamRestriction();
            vuip.bitstreamRestriction.motionVectorsOverPicBoundariesFlag = CAVLCReader.readBool(_in);
            vuip.bitstreamRestriction.maxBytesPerPicDenom = CAVLCReader.readUE(_in);
            vuip.bitstreamRestriction.maxBitsPerMbDenom = CAVLCReader.readUE(_in);
            vuip.bitstreamRestriction.log2MaxMvLengthHorizontal = CAVLCReader.readUE(_in);
            vuip.bitstreamRestriction.log2MaxMvLengthVertical = CAVLCReader.readUE(_in);
            vuip.bitstreamRestriction.numReorderFrames = CAVLCReader.readUE(_in);
            vuip.bitstreamRestriction.maxDecFrameBuffering = CAVLCReader.readUE(_in);
        }
        return vuip;
    }

    private static HRDParameters readHRDParameters(BitReader _in) {
        HRDParameters hrd = new HRDParameters();
        hrd.cpbCntMinus1 = CAVLCReader.readUE(_in);
        hrd.bitRateScale = CAVLCReader.readNBit(_in, 4);
        hrd.cpbSizeScale = CAVLCReader.readNBit(_in, 4);
        hrd.bitRateValueMinus1 = new int[hrd.cpbCntMinus1 + 1];
        hrd.cpbSizeValueMinus1 = new int[hrd.cpbCntMinus1 + 1];
        hrd.cbrFlag = new boolean[hrd.cpbCntMinus1 + 1];
        for (int SchedSelIdx = 0; SchedSelIdx <= hrd.cpbCntMinus1; ++SchedSelIdx) {
            hrd.bitRateValueMinus1[SchedSelIdx] = CAVLCReader.readUE(_in);
            hrd.cpbSizeValueMinus1[SchedSelIdx] = CAVLCReader.readUE(_in);
            hrd.cbrFlag[SchedSelIdx] = CAVLCReader.readBool(_in);
        }
        hrd.initialCpbRemovalDelayLengthMinus1 = CAVLCReader.readNBit(_in, 5);
        hrd.cpbRemovalDelayLengthMinus1 = CAVLCReader.readNBit(_in, 5);
        hrd.dpbOutputDelayLengthMinus1 = CAVLCReader.readNBit(_in, 5);
        hrd.timeOffsetLength = CAVLCReader.readNBit(_in, 5);
        return hrd;
    }

    public void write(ByteBuffer out) {
        BitWriter writer = new BitWriter(out);
        CAVLCWriter.writeNBit(writer, this.profileIdc, 8, "");
        CAVLCWriter.writeBool(writer, this.constraintSet0Flag);
        CAVLCWriter.writeBool(writer, this.constraintSet1Flag);
        CAVLCWriter.writeBool(writer, this.constraintSet2Flag);
        CAVLCWriter.writeBool(writer, this.constraintSet3Flag);
        CAVLCWriter.writeBool(writer, this.constraintSet4Flag);
        CAVLCWriter.writeBool(writer, this.constraintSet5Flag);
        CAVLCWriter.writeNBit(writer, 0L, 2, "");
        CAVLCWriter.writeNBit(writer, this.levelIdc, 8, "");
        CAVLCWriter.writeUE(writer, this.seqParameterSetId);
        if (this.profileIdc == 100 || this.profileIdc == 110 || this.profileIdc == 122 || this.profileIdc == 144) {
            CAVLCWriter.writeUE(writer, SeqParameterSet.fromColor(this.chromaFormatIdc));
            if (this.chromaFormatIdc == ColorSpace.YUV444) {
                CAVLCWriter.writeBool(writer, this.separateColourPlaneFlag);
            }
            CAVLCWriter.writeUE(writer, this.bitDepthLumaMinus8);
            CAVLCWriter.writeUE(writer, this.bitDepthChromaMinus8);
            CAVLCWriter.writeBool(writer, this.qpprimeYZeroTransformBypassFlag);
            CAVLCWriter.writeBool(writer, this.scalingMatrix != null);
            if (this.scalingMatrix != null) {
                for (int i = 0; i < 8; ++i) {
                    CAVLCWriter.writeBool(writer, this.scalingMatrix[i] != null);
                    if (this.scalingMatrix[i] == null) continue;
                    SeqParameterSet.writeScalingList(writer, this.scalingMatrix, i);
                }
            }
        }
        CAVLCWriter.writeUE(writer, this.log2MaxFrameNumMinus4);
        CAVLCWriter.writeUE(writer, this.picOrderCntType);
        if (this.picOrderCntType == 0) {
            CAVLCWriter.writeUE(writer, this.log2MaxPicOrderCntLsbMinus4);
        } else if (this.picOrderCntType == 1) {
            CAVLCWriter.writeBool(writer, this.deltaPicOrderAlwaysZeroFlag);
            CAVLCWriter.writeSE(writer, this.offsetForNonRefPic);
            CAVLCWriter.writeSE(writer, this.offsetForTopToBottomField);
            CAVLCWriter.writeUE(writer, this.offsetForRefFrame.length);
            for (int j : this.offsetForRefFrame) {
                CAVLCWriter.writeSE(writer, j);
            }
        }
        CAVLCWriter.writeUE(writer, this.numRefFrames);
        CAVLCWriter.writeBool(writer, this.gapsInFrameNumValueAllowedFlag);
        CAVLCWriter.writeUE(writer, this.picWidthInMbsMinus1);
        CAVLCWriter.writeUE(writer, this.picHeightInMapUnitsMinus1);
        CAVLCWriter.writeBool(writer, this.frameMbsOnlyFlag);
        if (!this.frameMbsOnlyFlag) {
            CAVLCWriter.writeBool(writer, this.mbAdaptiveFrameFieldFlag);
        }
        CAVLCWriter.writeBool(writer, this.direct8x8InferenceFlag);
        CAVLCWriter.writeBool(writer, this.frameCroppingFlag);
        if (this.frameCroppingFlag) {
            CAVLCWriter.writeUE(writer, this.frameCropLeftOffset);
            CAVLCWriter.writeUE(writer, this.frameCropRightOffset);
            CAVLCWriter.writeUE(writer, this.frameCropTopOffset);
            CAVLCWriter.writeUE(writer, this.frameCropBottomOffset);
        }
        CAVLCWriter.writeBool(writer, this.vuiParams != null);
        if (this.vuiParams != null) {
            this.writeVUIParameters(this.vuiParams, writer);
        }
        CAVLCWriter.writeTrailingBits(writer);
    }

    private void writeVUIParameters(VUIParameters vuip, BitWriter writer) {
        CAVLCWriter.writeBool(writer, vuip.aspectRatioInfoPresentFlag);
        if (vuip.aspectRatioInfoPresentFlag) {
            CAVLCWriter.writeNBit(writer, vuip.aspectRatio.value(), 8, "");
            if (vuip.aspectRatio == AspectRatio.Extended_SAR) {
                CAVLCWriter.writeNBit(writer, vuip.sarWidth, 16, "");
                CAVLCWriter.writeNBit(writer, vuip.sarHeight, 16, "");
            }
        }
        CAVLCWriter.writeBool(writer, vuip.overscanInfoPresentFlag);
        if (vuip.overscanInfoPresentFlag) {
            CAVLCWriter.writeBool(writer, vuip.overscanAppropriateFlag);
        }
        CAVLCWriter.writeBool(writer, vuip.videoSignalTypePresentFlag);
        if (vuip.videoSignalTypePresentFlag) {
            CAVLCWriter.writeNBit(writer, vuip.videoFormat, 3, "");
            CAVLCWriter.writeBool(writer, vuip.videoFullRangeFlag);
            CAVLCWriter.writeBool(writer, vuip.colourDescriptionPresentFlag);
            if (vuip.colourDescriptionPresentFlag) {
                CAVLCWriter.writeNBit(writer, vuip.colourPrimaries, 8, "");
                CAVLCWriter.writeNBit(writer, vuip.transferCharacteristics, 8, "");
                CAVLCWriter.writeNBit(writer, vuip.matrixCoefficients, 8, "");
            }
        }
        CAVLCWriter.writeBool(writer, vuip.chromaLocInfoPresentFlag);
        if (vuip.chromaLocInfoPresentFlag) {
            CAVLCWriter.writeUE(writer, vuip.chromaSampleLocTypeTopField);
            CAVLCWriter.writeUE(writer, vuip.chromaSampleLocTypeBottomField);
        }
        CAVLCWriter.writeBool(writer, vuip.timingInfoPresentFlag);
        if (vuip.timingInfoPresentFlag) {
            CAVLCWriter.writeNBit(writer, vuip.numUnitsInTick, 32, "");
            CAVLCWriter.writeNBit(writer, vuip.timeScale, 32, "");
            CAVLCWriter.writeBool(writer, vuip.fixedFrameRateFlag);
        }
        CAVLCWriter.writeBool(writer, vuip.nalHRDParams != null);
        if (vuip.nalHRDParams != null) {
            this.writeHRDParameters(vuip.nalHRDParams, writer);
        }
        CAVLCWriter.writeBool(writer, vuip.vclHRDParams != null);
        if (vuip.vclHRDParams != null) {
            this.writeHRDParameters(vuip.vclHRDParams, writer);
        }
        if (vuip.nalHRDParams != null || vuip.vclHRDParams != null) {
            CAVLCWriter.writeBool(writer, vuip.lowDelayHrdFlag);
        }
        CAVLCWriter.writeBool(writer, vuip.picStructPresentFlag);
        CAVLCWriter.writeBool(writer, vuip.bitstreamRestriction != null);
        if (vuip.bitstreamRestriction != null) {
            CAVLCWriter.writeBool(writer, vuip.bitstreamRestriction.motionVectorsOverPicBoundariesFlag);
            CAVLCWriter.writeUE(writer, vuip.bitstreamRestriction.maxBytesPerPicDenom);
            CAVLCWriter.writeUE(writer, vuip.bitstreamRestriction.maxBitsPerMbDenom);
            CAVLCWriter.writeUE(writer, vuip.bitstreamRestriction.log2MaxMvLengthHorizontal);
            CAVLCWriter.writeUE(writer, vuip.bitstreamRestriction.log2MaxMvLengthVertical);
            CAVLCWriter.writeUE(writer, vuip.bitstreamRestriction.numReorderFrames);
            CAVLCWriter.writeUE(writer, vuip.bitstreamRestriction.maxDecFrameBuffering);
        }
    }

    private void writeHRDParameters(HRDParameters hrd, BitWriter writer) {
        CAVLCWriter.writeUE(writer, hrd.cpbCntMinus1);
        CAVLCWriter.writeNBit(writer, hrd.bitRateScale, 4, "");
        CAVLCWriter.writeNBit(writer, hrd.cpbSizeScale, 4, "");
        for (int SchedSelIdx = 0; SchedSelIdx <= hrd.cpbCntMinus1; ++SchedSelIdx) {
            CAVLCWriter.writeUE(writer, hrd.bitRateValueMinus1[SchedSelIdx]);
            CAVLCWriter.writeUE(writer, hrd.cpbSizeValueMinus1[SchedSelIdx]);
            CAVLCWriter.writeBool(writer, hrd.cbrFlag[SchedSelIdx]);
        }
        CAVLCWriter.writeNBit(writer, hrd.initialCpbRemovalDelayLengthMinus1, 5, "");
        CAVLCWriter.writeNBit(writer, hrd.cpbRemovalDelayLengthMinus1, 5, "");
        CAVLCWriter.writeNBit(writer, hrd.dpbOutputDelayLengthMinus1, 5, "");
        CAVLCWriter.writeNBit(writer, hrd.timeOffsetLength, 5, "");
    }

    public SeqParameterSet copy() {
        ByteBuffer buf = ByteBuffer.allocate(2048);
        this.write(buf);
        buf.flip();
        return SeqParameterSet.read(buf);
    }

    public static int getPicHeightInMbs(SeqParameterSet sps) {
        return sps.picHeightInMapUnitsMinus1 + 1 << (sps.frameMbsOnlyFlag ? 0 : 1);
    }
}

