# 基础知识
本文档包含了一些关于[计算机](block/computer.md)工作原理的基础信息。这并不意味着这些信息是易于阅读的。这里的“基础”指的是使用中的一般概念。

## 架构
计算机运行在单核的通用 RISC-V 架构上。这意味着它们具有 64 位寄存器，并支持浮点运算。这使得可以在它们上启动现代的 Linux 内核。

### 本机设备
连接到计算机的本机设备是内存映射设备。这意味着它们被映射到物理内存中的某个区域。计算机使用常规的 Linux 驱动程序与它们交互。

有哪些设备可用，以及这些设备的地址在哪里，是通过扁平化设备树传达给计算机上运行的软件的。这种数据结构可能包含关于整个系统的其他信息。特别是，它还存储了已安装的[内存](item/memory.md)大小。由于此数据结构在启动时被复制，因此不能在稍后更新。这就是在更改本机设备（如[网卡](item/network_interface_card.md)）时必须重启计算机的原因。对于需要重启的设备，其工具提示中通常会有相应的说明。

### HLAPI 设备
另一种设备是高级 API 设备，有时也称为 RPC 设备。这些设备使用单个控制器，通过单个串行设备与计算机通信。所有计算机中都存在该控制器设备，它负责收集来自多个设备的消息，并将消息分派到设备上。此控制器使用的协议是基于简单 JSON 消息的协议。默认 Linux 库提供的 `devices` Lua 库封装了用于连接此控制器的串行设备。因此，在使用 HLAPI 设备（如[红石接口](block/redstone_interface.md)）时，*强烈*建议使用 `devices` 库。

由于所用协议的性质，数据传输速率相对有限。因此，大多数设备通常仅提供相对简单的 API，不需要发送大量数据。

## 配置
计算机可以在一定程度上进行配置。内存的大小、以[硬盘](item/hard_drive.md)形式的额外存储空间，以及最重要的是安装哪些卡片，主要由用户决定。请注意，默认的 Linux 发行版至少需要 20M 的内存，建议使用 24M。

大多数组件都会增加计算机的整体能耗。为了节约能源，选择仅必要的组件至关重要。

## Linux
默认的 Linux 发行版包含一些基本的命令行工具，以及编写和运行 Lua 程序的功能。有关如何使用 Lua 与 HLAPI 设备交互的概述，请参阅[脚本编写](scripting.md)手册条目。

本机设备使用常规的 Linux 驱动程序。例如，硬盘驱动器显示为 `/dev/vdaX` 设备，可以常规地格式化和挂载。

计算机提供了两个硬件时钟（RTC）设备。第一个以大多数用户熟悉的时间单位计时。它是默认使用的，例如通过 `date` 和 `time` 等命令行工具。第二个时钟按计算机运行的世界中的时间计时。要获取当前世界时间，请使用 `hwclock -f /dev/rtc1`。
