/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class BowLootConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/many_bows.json");
    public boolean easyLootEnabled = true;
    public float easyLootDropChance = 0.5f;
    public boolean mediumLootEnabled = true;
    public float mediumLootDropChance = 0.4f;
    public boolean hardLootEnabled = true;
    public float hardLootDropChance = 0.3f;
    public boolean endgameLootEnabled = true;
    public float endgameLootDropChance = 0.2f;

    public static BowLootConfig loadConfig() {
        BowLootConfig bowLootConfig;
        if (!CONFIG_FILE.exists()) {
            BowLootConfig defaultConfig = new BowLootConfig();
            defaultConfig.saveConfig();
            return defaultConfig;
        }
        FileReader reader = new FileReader(CONFIG_FILE);
        try {
            bowLootConfig = (BowLootConfig)GSON.fromJson((Reader)reader, BowLootConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new BowLootConfig();
            }
        }
        reader.close();
        return bowLootConfig;
    }

    public void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

