/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.entity.RiftEntity;
import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class AuroraArrowEntity
extends AbstractArrow {
    public AuroraArrowEntity(EntityType<? extends AuroraArrowEntity> entityType, Level world) {
        super(entityType, world);
    }

    public AuroraArrowEntity(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.AURORA_ARROW.get(), shooter, level, bowStack, arrowStack);
        this.setBaseDamage(7.0);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide) {
            this.spawnRift(BlockPos.containing((Position)result.getLocation()));
        }
        this.discard();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide) {
            this.spawnRift(result.getBlockPos());
        }
        this.discard();
    }

    private void spawnRift(BlockPos position) {
        RiftEntity rift = new RiftEntity(this.level(), position);
        this.level().addFreshEntity((Entity)rift);
    }

    private void spawnRift(double x, double y, double z) {
        RiftEntity rift = new RiftEntity(this.level(), x, y, z);
        this.level().addFreshEntity((Entity)rift);
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return null;
    }
}

