/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.bandit.many_bows.util.AncientSageDamageSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;

public class RadiantArrow
extends AbstractArrow {
    private boolean hasExploded = false;

    public RadiantArrow(EntityType<? extends RadiantArrow> entityType, Level level) {
        super(entityType, level);
    }

    public RadiantArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.RADIANT_ARROW.get(), shooter, level, bowStack, arrowStack);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.hasExploded && result.getType() == HitResult.Type.BLOCK) {
            this.hasExploded = true;
            this.createRadiantExplosion(this.level(), this);
            this.discard();
        }
    }

    private void createRadiantExplosion(Level level, RadiantArrow arrow) {
        level.explode(null, arrow.getX(), arrow.getY(), arrow.getZ(), 2.0f, Level.ExplosionInteraction.NONE);
        AABB explosionArea = new AABB(arrow.getX() - 5.0, arrow.getY() - 5.0, arrow.getZ() - 5.0, arrow.getX() + 5.0, arrow.getY() + 5.0, arrow.getZ() + 5.0);
        level.getEntitiesOfClass(LivingEntity.class, explosionArea).forEach(entity -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = entity;
                DamageSource radiantSource = AncientSageDamageSource.createRadiantDamage(level, (Entity)arrow);
                if (livingEntity.isInvertedHealAndHarm()) {
                    livingEntity.hurt(radiantSource, 6.0f);
                } else {
                    livingEntity.hurt(radiantSource, 3.0f);
                }
            }
        });
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

