/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import java.util.List;
import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class RiftEntity
extends Entity {
    private int lifeTime = 60;
    private static final double PULL_RADIUS = 5.0;
    private static final double EXPLOSION_RADIUS = 4.0;
    private static final double PULL_STRENGTH = 0.1;

    public RiftEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.noPhysics = true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public RiftEntity(Level world, double x, double y, double z) {
        this((EntityType)EntityRegistry.RIFT_ENTITY.get(), world);
        this.setPos(x, y, z);
    }

    public RiftEntity(Level world, BlockPos pos) {
        this(world, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
    }

    public void tick() {
        super.tick();
        if (this.lifeTime-- <= 0) {
            if (!this.level().isClientSide) {
                this.explode();
            }
            this.discard();
        } else {
            if (!this.level().isClientSide) {
                List entities = this.level().getEntities((Entity)this, new AABB(this.getX() - 5.0, this.getY() - 5.0, this.getZ() - 5.0, this.getX() + 5.0, this.getY() + 5.0, this.getZ() + 5.0));
                for (Entity entity : entities) {
                    double dz;
                    double dy;
                    double dx;
                    double distance;
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (entity instanceof Player && ((Player)entity).getAbilities().instabuild || !((distance = Math.sqrt((dx = this.getX() - living.getX()) * dx + (dy = this.getY() - living.getY()) * dy + (dz = this.getZ() - living.getZ()) * dz)) > 0.1)) continue;
                    double strength = 0.1 / distance;
                    living.push(dx * strength, dy * strength, dz * strength);
                }
            }
            if (this.level().isClientSide) {
                int i;
                double corePulse = Math.sin((double)this.lifeTime * 0.1) * 0.5 + 1.5;
                for (i = 0; i < 30; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, this.getX() + this.random.nextGaussian() * corePulse, this.getY() + this.random.nextGaussian() * corePulse, this.getZ() + this.random.nextGaussian() * corePulse, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 20; ++i) {
                    double spawnRadius = 8.0;
                    double angle = this.random.nextDouble() * Math.PI * 2.0;
                    double offsetX = Math.cos(angle) * spawnRadius;
                    double offsetZ = Math.sin(angle) * spawnRadius;
                    double offsetY = (this.random.nextDouble() - 0.5) * 4.0;
                    double velocityX = (this.getX() - (this.getX() + offsetX)) * 0.2;
                    double velocityY = (this.getY() - (this.getY() + offsetY)) * 0.2;
                    double velocityZ = (this.getZ() - (this.getZ() + offsetZ)) * 0.2;
                    this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANT, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, velocityX, velocityY, velocityZ);
                }
                for (int layer = 0; layer < 3; ++layer) {
                    double height = this.getY() + (double)layer * 0.3;
                    double radius = 2.5 + (double)layer * 0.3;
                    for (int i2 = 0; i2 < 40; ++i2) {
                        double angle = ((double)this.lifeTime * 0.1 + (double)i2) % (Math.PI * 2);
                        double offsetX = Math.cos(angle) * radius;
                        double offsetZ = Math.sin(angle) * radius;
                        this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getX() + offsetX, height, this.getZ() + offsetZ, 0.0, 0.0, 0.0);
                    }
                }
                if (this.lifeTime % 20 == 0) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private void explode() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.level().explode(null, this.getX(), this.getY(), this.getZ(), 4.0f, Level.ExplosionInteraction.NONE);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.lifeTime = compound.getInt("LifeTime");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("LifeTime", this.lifeTime);
    }
}

