/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class SonicBoomProjectile
extends AbstractArrow {
    private int lifetime = 60;
    private int tickCount = 0;

    public SonicBoomProjectile(EntityType<? extends SonicBoomProjectile> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
    }

    public SonicBoomProjectile(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.SONIC_BOOM_PROJECTILE.get(), shooter, level, bowStack, arrowStack);
        this.setNoGravity(true);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide() && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            target.hurt(this.damageSources().sonicBoom((Entity)this), 20.0f);
            target.knockback(2.0, Math.sin((double)this.getYRot() * Math.PI / 180.0), -Math.cos((double)this.getYRot() * Math.PI / 180.0));
            this.level().playSound(null, target.getX(), target.getY(), target.getZ(), SoundEvents.WARDEN_SONIC_BOOM, SoundSource.PLAYERS, 0.5f, 1.0f);
            this.discard();
        }
    }

    public void tick() {
        super.tick();
        ++this.tickCount;
        if (!this.level().isClientSide && --this.lifetime <= 0) {
            this.discard();
        }
        if (this.level().isClientSide) {
            this.createSonicBoomSpiral();
        }
    }

    private void createSonicBoomSpiral() {
        int particles = 25;
        double radius = 0.5;
        double spiralExpansionRate = 0.15;
        for (int i = 0; i < particles; ++i) {
            double angle = Math.PI * 2 * ((double)i + (double)this.tickCount * 0.1);
            double offsetX = radius * Math.cos(angle);
            double offsetZ = radius * Math.sin(angle);
            double offsetY = (double)this.tickCount * 0.05 - (double)i * 0.01;
            this.level().addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, 0.0, 0.0, 0.0);
            radius += spiralExpansionRate;
        }
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return null;
    }
}

