/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class TidalArrow
extends AbstractArrow {
    public TidalArrow(EntityType<? extends TidalArrow> entityType, Level level) {
        super(entityType, level);
    }

    public TidalArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.TIDAL_ARROW.get(), shooter, level, bowStack, arrowStack);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && this.isInWater()) {
            Vec3 motion = this.getDeltaMovement();
            for (int i = 0; i < 5; ++i) {
                double xOffset = (this.random.nextDouble() - 0.5) * 0.3;
                double yOffset = (this.random.nextDouble() - 0.5) * 0.3;
                double zOffset = (this.random.nextDouble() - 0.5) * 0.3;
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() + motion.x * (double)i * 0.1, this.getY() + motion.y * (double)i * 0.1, this.getZ() + motion.z * (double)i * 0.1, xOffset, yOffset, zOffset);
            }
        }
    }

    protected float getWaterInertia() {
        return 1.0f;
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide() && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity hitEntity = (LivingEntity)entity;
            hitEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 2));
            this.createWaterBindingEffect(hitEntity);
        }
    }

    private void createWaterBindingEffect(LivingEntity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos entityPos = entity.blockPosition();
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 4, false, false));
            for (int i = 0; i < 30; ++i) {
                double angle = (double)i * Math.PI / 15.0;
                double xOffset = Math.cos(angle) * 0.5;
                double zOffset = Math.sin(angle) * 0.5;
                double yOffset = 0.3 * (double)i;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH, (double)entityPos.getX() + xOffset, (double)entityPos.getY() + yOffset, (double)entityPos.getZ() + zOffset, 1, 0.0, 0.0, 0.0, 0.0);
            }
            this.level().playSound(null, entityPos, SoundEvents.GENERIC_SPLASH, this.getSoundSource(), 0.5f, 0.8f);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.createWaterSplash(result.getLocation());
    }

    private void createWaterSplash(Vec3 position) {
        if (!this.level().isClientSide()) {
            for (int i = 0; i < 20; ++i) {
                double xOffset = (this.random.nextDouble() - 0.5) * 2.0;
                double yOffset = this.random.nextDouble();
                double zOffset = (this.random.nextDouble() - 0.5) * 2.0;
                this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, position.x + xOffset, position.y + yOffset, position.z + zOffset, 0.0, 0.1, 0.0);
            }
            this.level().playSound(null, position.x, position.y, position.z, SoundEvents.SPLASH_POTION_BREAK, this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

