/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.function.Predicate;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ArcaneBow
extends BowItem {
    public ArcaneBow(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(ItemStack bowStack, Level level, LivingEntity entity, int chargeTime) {
        int charge;
        float power;
        Player player;
        List projectiles;
        if (entity instanceof Player && (!(projectiles = ArcaneBow.draw((ItemStack)bowStack, (ItemStack)(player = (Player)entity).getProjectile(bowStack), (LivingEntity)player)).isEmpty() || player.getAbilities().instabuild) && (power = ArcaneBow.getPowerForTime(charge = this.getUseDuration(bowStack, entity) - chargeTime)) >= 0.1f) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.fireTripleArrows(serverLevel, player, bowStack, projectiles, power);
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.getAbilities().instabuild) {
                bowStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
        }
    }

    private void fireTripleArrows(ServerLevel serverLevel, Player player, ItemStack bowStack, List<ItemStack> projectileStacks, float power) {
        float basePitch = player.getXRot();
        float baseYaw = player.getYRot();
        float spreadAngle = 5.0f;
        if (projectileStacks.isEmpty() && !player.getAbilities().instabuild) {
            return;
        }
        ItemStack projectileStack = projectileStacks.get(0);
        boolean arrowConsumed = false;
        for (int i = -1; i <= 1; ++i) {
            AbstractArrow arrow = ((ArrowItem)projectileStack.getItem()).createArrow((Level)serverLevel, projectileStack, (LivingEntity)player, bowStack);
            float spreadOffset = (float)i * spreadAngle;
            arrow.shootFromRotation((Entity)player, basePitch, baseYaw + spreadOffset, 0.0f, power * 2.5f, 1.0f);
            arrow.pickup = i == 0 ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.CREATIVE_ONLY;
            serverLevel.addFreshEntity((Entity)arrow);
        }
        if (!player.getAbilities().instabuild) {
            projectileStack.shrink(1);
        }
    }

    public static float getPowerForTime(int pCharge) {
        float f = (float)pCharge / 16.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean hasArrows;
        ItemStack bowStack = player.getItemInHand(hand);
        boolean bl = hasArrows = !player.getProjectile(bowStack).isEmpty();
        if (!hasArrows) {
            return InteractionResultHolder.fail((Object)bowStack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)bowStack);
    }

    public int getDefaultProjectileRange() {
        return 64;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is((Item)ItemRegistry.POWER_CRYSTAL.get());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.arcane_bow.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.arcane_bow.tooltip.ability").withStyle(ChatFormatting.GOLD));
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.arcane_bow.tooltip.legend").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.hold_shift"));
        }
    }
}

