/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.function.Predicate;
import net.bandit.many_bows.entity.AuroraArrowEntity;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AuroraBow
extends BowItem {
    public AuroraBow(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(ItemStack bowStack, Level level, LivingEntity entity, int chargeTime) {
        if (entity instanceof Player) {
            int charge;
            float power;
            ItemStack arrowStack;
            Player player = (Player)entity;
            if (!level.isClientSide() && (!(arrowStack = player.getProjectile(bowStack)).isEmpty() || player.getAbilities().instabuild) && (power = AuroraBow.getPowerForTime((int)(charge = this.getUseDuration(bowStack, entity) - chargeTime))) >= 0.1f) {
                if (this.consumeRiftShard(player, 1)) {
                    List projectiles = AuroraBow.draw((ItemStack)bowStack, (ItemStack)arrowStack, (LivingEntity)player);
                    boolean arrowConsumed = false;
                    if (!projectiles.isEmpty() && level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (ItemStack projectileStack : projectiles) {
                            Object arrow = projectileStack.is(Items.SPECTRAL_ARROW) || projectileStack.is(Items.TIPPED_ARROW) ? ((ArrowItem)projectileStack.getItem()).createArrow((Level)serverLevel, projectileStack, (LivingEntity)player, bowStack) : new AuroraArrowEntity((Level)serverLevel, (LivingEntity)player, bowStack, projectileStack);
                            this.applyPowerEnchantment((AbstractArrow)arrow, bowStack, level);
                            this.applyKnockbackEnchantment((AbstractArrow)arrow, bowStack, (LivingEntity)player, level);
                            this.applyFlameEnchantment((AbstractArrow)arrow, bowStack, level);
                            arrow.pickup = this.hasInfinityEnchantment(bowStack, level) || player.getAbilities().instabuild ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                            arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, power * 3.0f, 1.0f);
                            serverLevel.addFreshEntity((Entity)arrow);
                            if (this.hasInfinityEnchantment(bowStack, level) || player.getAbilities().instabuild || arrowConsumed) continue;
                            projectileStack.shrink(1);
                            arrowConsumed = true;
                        }
                    }
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    if (!player.getAbilities().instabuild) {
                        bowStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    }
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"item.many_bows.aurora_bow.no_rift_shard").withStyle(ChatFormatting.RED), true);
                }
            }
        }
    }

    private boolean consumeRiftShard(Player player, int count) {
        if (player.getAbilities().instabuild) {
            return true;
        }
        int shardsRemoved = 0;
        for (ItemStack stack : player.getInventory().items) {
            if (stack.getItem() != ItemRegistry.RIFT_SHARD.get()) continue;
            int removeAmount = Math.min(stack.getCount(), count - shardsRemoved);
            stack.shrink(removeAmount);
            if ((shardsRemoved += removeAmount) < count) continue;
            return true;
        }
        return false;
    }

    private boolean hasInfinityEnchantment(ItemStack bow, Level level) {
        Holder<Enchantment> infinity = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.INFINITY);
        return EnchantmentHelper.getItemEnchantmentLevel(infinity, (ItemStack)bow) > 0;
    }

    private void applyFlameEnchantment(AbstractArrow arrow, ItemStack bow, Level level) {
        Holder<Enchantment> flame = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.FLAME);
        int flameLevel = EnchantmentHelper.getItemEnchantmentLevel(flame, (ItemStack)bow);
        if (flameLevel > 0) {
            arrow.igniteForSeconds(5.0f);
        }
    }

    private void applyKnockbackEnchantment(AbstractArrow arrow, ItemStack bow, LivingEntity shooter, Level level) {
        Holder<Enchantment> punch = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.PUNCH);
        int punchLevel = EnchantmentHelper.getItemEnchantmentLevel(punch, (ItemStack)bow);
        if (punchLevel > 0) {
            double resistance = Math.max(0.0, 1.0 - shooter.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 knockbackVec = arrow.getDeltaMovement().normalize().scale((double)punchLevel * 0.6 * resistance);
            arrow.push(knockbackVec.x, 0.1, knockbackVec.z);
        }
    }

    private void applyPowerEnchantment(AbstractArrow arrow, ItemStack bow, Level level) {
        Holder<Enchantment> power = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.POWER);
        int powerLevel = EnchantmentHelper.getItemEnchantmentLevel(power, (ItemStack)bow);
        if (powerLevel > 0) {
            double extraDamage = 0.5 * (double)powerLevel + 1.0;
            arrow.setBaseDamage(arrow.getBaseDamage() + extraDamage);
        }
    }

    private Holder<Enchantment> getEnchantmentHolder(Level level, ResourceKey<Enchantment> enchantmentKey) {
        return level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(enchantmentKey);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 16;
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is((Item)ItemRegistry.POWER_CRYSTAL.get());
    }
}

