/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.function.Predicate;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BurntRelicBow
extends BowItem {
    public BurntRelicBow(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(ItemStack bowStack, Level level, LivingEntity entity, int chargeTime) {
        if (entity instanceof Player) {
            int charge;
            float power;
            Player player = (Player)entity;
            ItemStack arrowStack = player.getProjectile(bowStack);
            boolean hasArrows = !arrowStack.isEmpty();
            boolean isCreative = player.getAbilities().instabuild;
            if ((hasArrows || isCreative) && (power = BurntRelicBow.getPowerForTime(charge = this.getUseDuration(bowStack, entity) - chargeTime)) >= 0.1f) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    AbstractArrow arrow = arrowStack.is(Items.SPECTRAL_ARROW) || arrowStack.is(Items.TIPPED_ARROW) ? ((ArrowItem)arrowStack.getItem()).createArrow((Level)serverLevel, arrowStack, (LivingEntity)player, bowStack) : ((ArrowItem)Items.ARROW).createArrow((Level)serverLevel, new ItemStack((ItemLike)Items.ARROW), (LivingEntity)player, bowStack);
                    arrow.setBaseDamage(arrow.getBaseDamage() + 3.0);
                    arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                    arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, power * 3.5f, 1.0f);
                    serverLevel.addFreshEntity((Entity)arrow);
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (!isCreative) {
                    arrowStack.shrink(0);
                }
                if (!isCreative) {
                    bowStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
            }
        }
    }

    public static float getPowerForTime(int pCharge) {
        float f = (float)pCharge / 16.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    @NotNull
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> true;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean hasArrows;
        ItemStack bowStack = player.getItemInHand(hand);
        boolean bl = hasArrows = !player.getProjectile(bowStack).isEmpty();
        if (!player.hasInfiniteMaterials() && !hasArrows) {
            return InteractionResultHolder.fail((Object)bowStack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)bowStack);
    }

    public int getDefaultProjectileRange() {
        return 64;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is((Item)ItemRegistry.POWER_CRYSTAL.get());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.burnt_relic.tooltip").withStyle(ChatFormatting.GOLD));
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.burnt_relic.tooltip1").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.burnt_relic.tooltip2").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.hold_shift"));
        }
    }
}

