/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.function.Predicate;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EtherealHunterBow
extends BowItem {
    private static final int HUNGER_COST = 2;

    public EtherealHunterBow(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(ItemStack bowStack, Level level, LivingEntity entity, int chargeTime) {
        if (entity instanceof Player) {
            int charge;
            float power;
            Player player = (Player)entity;
            if (!level.isClientSide() && (power = EtherealHunterBow.getPowerForTime(charge = this.getUseDuration(bowStack, entity) - chargeTime)) >= 0.1f && this.consumeHunger(player)) {
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.5f);
                ItemStack arrowStack = player.getProjectile(bowStack);
                ArrowItem arrowItem = arrowStack.getItem() instanceof ArrowItem ? (ArrowItem)arrowStack.getItem() : (ArrowItem)Items.ARROW;
                AbstractArrow arrow = arrowItem.createArrow(level, arrowStack, (LivingEntity)player, bowStack);
                arrow.setBaseDamage(arrow.getBaseDamage() + 3.0);
                arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, power * 3.0f, 1.0f);
                if (player.getHealth() == player.getMaxHealth()) {
                    arrow.setCritArrow(true);
                }
                level.addFreshEntity((Entity)arrow);
                bowStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        projectile.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot() + angle, 0.0f, velocity, inaccuracy);
    }

    public static float getPowerForTime(int pCharge) {
        float f = (float)pCharge / 16.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private boolean consumeHunger(Player player) {
        int currentHunger = player.getFoodData().getFoodLevel();
        if (currentHunger >= 2) {
            player.getFoodData().setFoodLevel(currentHunger - 2);
            return true;
        }
        player.displayClientMessage((Component)Component.translatable((String)"item.many_bows.ethereal_hunter.no_hunger").withStyle(ChatFormatting.RED), true);
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 15;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is((Item)ItemRegistry.POWER_CRYSTAL.get());
    }

    @NotNull
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.ethereal_hunter.tooltip.info").withStyle(ChatFormatting.DARK_PURPLE));
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.ethereal_hunter.tooltip.hunger", (Object[])new Object[]{2}).withStyle(ChatFormatting.GRAY));
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.ethereal_hunter.tooltip.legend").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.hold_shift").withStyle(ChatFormatting.YELLOW));
        }
    }
}

