/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ScatterBow
extends BowItem {
    private static final int MAX_ARROWS = 8;

    public ScatterBow(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(ItemStack bowStack, Level level, LivingEntity entity, int chargeTime) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            List projectiles = ScatterBow.draw((ItemStack)bowStack, (ItemStack)player.getProjectile(bowStack), (LivingEntity)player);
            boolean hasInfinity = this.hasInfinityEnchantment(bowStack, level);
            if (!projectiles.isEmpty() || hasInfinity || player.getAbilities().instabuild) {
                int arrowsAvailable;
                int charge = this.getUseDuration(bowStack, entity) - chargeTime;
                float power = ScatterBow.getPowerForTime((int)charge);
                int n = arrowsAvailable = player.getAbilities().instabuild ? 8 : Math.min(8, this.getArrowCount(player));
                if (power >= 0.1f && arrowsAvailable > 0) {
                    for (int i = 0; i < arrowsAvailable; ++i) {
                        Arrow arrow = (Arrow)EntityType.ARROW.create(level);
                        if (arrow == null) continue;
                        arrow.setOwner((Entity)player);
                        arrow.setPos(player.getX(), player.getEyeY(), player.getZ());
                        arrow.setBaseDamage(1.0);
                        this.applyPowerEnchantment((AbstractArrow)arrow, bowStack, level);
                        this.applyKnockbackEnchantment((AbstractArrow)arrow, bowStack, (LivingEntity)player, level);
                        this.applyFlameEnchantment((AbstractArrow)arrow, bowStack, level);
                        arrow.pickup = hasInfinity ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                        float yawOffset = (level.getRandom().nextFloat() - 0.5f) * 20.0f;
                        float pitchOffset = (level.getRandom().nextFloat() - 0.5f) * 10.0f;
                        arrow.shootFromRotation((Entity)player, player.getXRot() + pitchOffset, player.getYRot() + yawOffset, 0.0f, power * 3.0f, 1.0f);
                        level.addFreshEntity((Entity)arrow);
                    }
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    if (!hasInfinity && !player.getAbilities().instabuild) {
                        bowStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                        this.removeArrowsFromInventory(player, arrowsAvailable);
                    }
                }
            }
        }
    }

    private int getArrowCount(Player player) {
        int arrowCount = 0;
        for (ItemStack stack : player.getInventory().items) {
            ItemStack projectile = player.getProjectile(stack);
            if (projectile.isEmpty()) continue;
            arrowCount += projectile.getCount();
        }
        return arrowCount;
    }

    private void removeArrowsFromInventory(Player player, int count) {
        int removed = 0;
        for (ItemStack stack : player.getInventory().items) {
            if (stack.isEmpty() || !(stack.getItem() instanceof ArrowItem)) continue;
            int toRemove = Math.min(stack.getCount(), count - removed);
            stack.shrink(toRemove);
            if ((removed += toRemove) < count) continue;
            break;
        }
    }

    private void applyFlameEnchantment(AbstractArrow arrow, ItemStack bow, Level level) {
        Holder<Enchantment> flame = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.FLAME);
        int flameLevel = EnchantmentHelper.getItemEnchantmentLevel(flame, (ItemStack)bow);
        if (flameLevel > 0) {
            arrow.igniteForSeconds(5.0f);
        }
    }

    private void applyKnockbackEnchantment(AbstractArrow arrow, ItemStack bow, LivingEntity shooter, Level level) {
        Holder<Enchantment> punch = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.PUNCH);
        int punchLevel = EnchantmentHelper.getItemEnchantmentLevel(punch, (ItemStack)bow);
        if (punchLevel > 0) {
            double resistance = Math.max(0.0, 1.0 - shooter.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 knockbackVec = arrow.getDeltaMovement().normalize().scale((double)punchLevel * 0.6 * resistance);
            arrow.push(knockbackVec.x, 0.1, knockbackVec.z);
        }
    }

    private void applyPowerEnchantment(AbstractArrow arrow, ItemStack bow, Level level) {
        Holder<Enchantment> power = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.POWER);
        int powerLevel = EnchantmentHelper.getItemEnchantmentLevel(power, (ItemStack)bow);
        if (powerLevel > 0) {
            double extraDamage = 0.5 * (double)powerLevel + 1.0;
            arrow.setBaseDamage(arrow.getBaseDamage() + extraDamage);
        }
    }

    private boolean hasInfinityEnchantment(ItemStack bow, Level level) {
        Holder<Enchantment> infinity = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.INFINITY);
        return EnchantmentHelper.getItemEnchantmentLevel(infinity, (ItemStack)bow) > 0;
    }

    private Holder<Enchantment> getEnchantmentHolder(Level level, ResourceKey<Enchantment> enchantmentKey) {
        return level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(enchantmentKey);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.scatter_bow.tooltip").withStyle(ChatFormatting.GOLD));
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.scatter_bow.tooltip.ability").withStyle(ChatFormatting.DARK_GREEN));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.hold_shift"));
        }
    }
}

