/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.function.Predicate;
import net.bandit.many_bows.entity.WebstringArrow;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WebstringVolleyBow
extends BowItem {
    private static final int ARROWS_TO_FIRE = 5;

    public WebstringVolleyBow(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(ItemStack bowStack, Level level, LivingEntity entity, int chargeTime) {
        if (entity instanceof Player) {
            int charge;
            float power;
            Player player = (Player)entity;
            List projectiles = WebstringVolleyBow.draw((ItemStack)bowStack, (ItemStack)player.getProjectile(bowStack), (LivingEntity)player);
            boolean hasInfinity = this.hasInfinityEnchantment(bowStack, level);
            if ((!projectiles.isEmpty() || hasInfinity || player.getAbilities().instabuild) && (power = WebstringVolleyBow.getPowerForTime((int)(charge = this.getUseDuration(bowStack, entity) - chargeTime))) >= 0.1f) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.fireMultiArrows(serverLevel, player, bowStack, projectiles, power, level);
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (!player.getAbilities().instabuild) {
                    bowStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
            }
        }
    }

    private void fireMultiArrows(ServerLevel serverLevel, Player player, ItemStack bowStack, List<ItemStack> projectileStacks, float power, Level level) {
        float basePitch = player.getXRot();
        float baseYaw = player.getYRot();
        float spreadAngle = 8.0f;
        if (projectileStacks.isEmpty() && !player.getAbilities().instabuild) {
            return;
        }
        ItemStack projectileStack = projectileStacks.get(0);
        boolean arrowConsumed = false;
        boolean hasInfinity = this.hasInfinityEnchantment(bowStack, level);
        for (int i = -2; i <= 2; ++i) {
            WebstringArrow arrow = new WebstringArrow((Level)serverLevel, (LivingEntity)player, bowStack, projectileStack);
            this.applyPowerEnchantment(arrow, bowStack, level);
            this.applyKnockbackEnchantment(arrow, bowStack, (LivingEntity)player, level);
            this.applyFlameEnchantment(arrow, bowStack, level);
            float spreadOffset = (float)i * spreadAngle;
            arrow.shootFromRotation((Entity)player, basePitch, baseYaw + spreadOffset, 0.0f, power * 2.5f, 1.0f);
            arrow.pickup = i == 0 || hasInfinity ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.CREATIVE_ONLY;
            serverLevel.addFreshEntity((Entity)arrow);
        }
        if (!(hasInfinity || player.getAbilities().instabuild || arrowConsumed)) {
            projectileStack.shrink(1);
            arrowConsumed = true;
        }
    }

    private void applyFlameEnchantment(AbstractArrow arrow, ItemStack bow, Level level) {
        Holder<Enchantment> flame = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.FLAME);
        int flameLevel = EnchantmentHelper.getItemEnchantmentLevel(flame, (ItemStack)bow);
        if (flameLevel > 0) {
            arrow.igniteForSeconds(5.0f);
        }
    }

    private void applyKnockbackEnchantment(AbstractArrow arrow, ItemStack bow, LivingEntity shooter, Level level) {
        Holder<Enchantment> punch = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.PUNCH);
        int punchLevel = EnchantmentHelper.getItemEnchantmentLevel(punch, (ItemStack)bow);
        if (punchLevel > 0) {
            double resistance = Math.max(0.0, 1.0 - shooter.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 knockbackVec = arrow.getDeltaMovement().normalize().scale((double)punchLevel * 0.6 * resistance);
            arrow.push(knockbackVec.x, 0.1, knockbackVec.z);
        }
    }

    private void applyPowerEnchantment(AbstractArrow arrow, ItemStack bow, Level level) {
        Holder<Enchantment> power = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.POWER);
        int powerLevel = EnchantmentHelper.getItemEnchantmentLevel(power, (ItemStack)bow);
        if (powerLevel > 0) {
            double extraDamage = 0.5 * (double)powerLevel + 1.0;
            arrow.setBaseDamage(arrow.getBaseDamage() + extraDamage);
        }
    }

    private boolean hasInfinityEnchantment(ItemStack bow, Level level) {
        Holder<Enchantment> infinity = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.INFINITY);
        return EnchantmentHelper.getItemEnchantmentLevel(infinity, (ItemStack)bow) > 0;
    }

    private Holder<Enchantment> getEnchantmentHolder(Level level, ResourceKey<Enchantment> enchantmentKey) {
        return level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(enchantmentKey);
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 16;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack bowStack = player.getItemInHand(hand);
        boolean hasArrows = !player.getProjectile(bowStack).isEmpty();
        boolean hasInfinity = this.hasInfinityEnchantment(bowStack, level);
        if (!(hasArrows || hasInfinity || player.getAbilities().instabuild)) {
            return InteractionResultHolder.fail((Object)bowStack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)bowStack);
    }

    public int getDefaultProjectileRange() {
        return 64;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is((Item)ItemRegistry.POWER_CRYSTAL.get());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.webstring_volley.details").withStyle(ChatFormatting.YELLOW));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.webstring_volley").withStyle(ChatFormatting.GOLD));
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.webstring_volley.tooltip").withStyle(ChatFormatting.GREEN));
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.hold_shift").withStyle(ChatFormatting.GRAY));
        }
    }
}

