/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.function.Predicate;
import net.bandit.many_bows.entity.WindProjectile;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WindBow
extends BowItem {
    private static final int MOVEMENT_SPEED_DURATION = 0;
    private static final int MOVEMENT_SPEED_LEVEL = 15;

    public WindBow(Item.Properties properties) {
        super(properties);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.isClientSide()) {
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 0, 15, true, false));
            }
        }
        super.onUseTick(level, entity, stack, count);
    }

    public void releaseUsing(ItemStack bowStack, Level level, LivingEntity entity, int chargeTime) {
        int charge;
        float power;
        Player player;
        ItemStack arrowStack;
        if (entity instanceof Player && (!(arrowStack = (player = (Player)entity).getProjectile(bowStack)).isEmpty() || player.getAbilities().instabuild) && (power = WindBow.getPowerForTime(charge = this.getUseDuration(bowStack, entity) - chargeTime)) >= 0.1f) {
            List projectiles = WindBow.draw((ItemStack)bowStack, (ItemStack)arrowStack, (LivingEntity)player);
            boolean arrowConsumed = false;
            if (!projectiles.isEmpty() && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (ItemStack projectileStack : projectiles) {
                    Object arrow = projectileStack.is(Items.SPECTRAL_ARROW) || projectileStack.is(Items.TIPPED_ARROW) ? ((ArrowItem)projectileStack.getItem()).createArrow((Level)serverLevel, projectileStack, (LivingEntity)player, bowStack) : new WindProjectile((Level)serverLevel, (LivingEntity)player, bowStack, projectileStack);
                    this.applyPowerEnchantment((AbstractArrow)arrow, bowStack, level);
                    this.applyKnockbackEnchantment((AbstractArrow)arrow, bowStack, (LivingEntity)player, level);
                    this.applyFlameEnchantment((AbstractArrow)arrow, bowStack, level);
                    arrow.pickup = this.hasInfinityEnchantment(bowStack, level) || player.getAbilities().instabuild ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                    arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, power * 2.5f, 1.0f);
                    serverLevel.addFreshEntity((Entity)arrow);
                    if (this.hasInfinityEnchantment(bowStack, level) || player.getAbilities().instabuild || arrowConsumed) continue;
                    projectileStack.shrink(1);
                    arrowConsumed = true;
                }
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_BREATH, SoundSource.PLAYERS, 1.0f, 1.2f);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.getAbilities().instabuild) {
                bowStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
        }
    }

    private void applyFlameEnchantment(AbstractArrow arrow, ItemStack bow, Level level) {
        Holder<Enchantment> flame = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.FLAME);
        int flameLevel = EnchantmentHelper.getItemEnchantmentLevel(flame, (ItemStack)bow);
        if (flameLevel > 0) {
            arrow.igniteForSeconds(5.0f);
        }
    }

    private void applyKnockbackEnchantment(AbstractArrow arrow, ItemStack bow, LivingEntity shooter, Level level) {
        Holder<Enchantment> punch = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.PUNCH);
        int punchLevel = EnchantmentHelper.getItemEnchantmentLevel(punch, (ItemStack)bow);
        if (punchLevel > 0) {
            double resistance = Math.max(0.0, 1.0 - shooter.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 knockbackVec = arrow.getDeltaMovement().normalize().scale((double)punchLevel * 0.6 * resistance);
            arrow.push(knockbackVec.x, 0.1, knockbackVec.z);
        }
    }

    private void applyPowerEnchantment(AbstractArrow arrow, ItemStack bow, Level level) {
        Holder<Enchantment> power = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.POWER);
        int powerLevel = EnchantmentHelper.getItemEnchantmentLevel(power, (ItemStack)bow);
        if (powerLevel > 0) {
            double extraDamage = 0.5 * (double)powerLevel + 1.0;
            arrow.setBaseDamage(arrow.getBaseDamage() + extraDamage);
        }
    }

    private boolean hasInfinityEnchantment(ItemStack bow, Level level) {
        Holder<Enchantment> infinity = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.INFINITY);
        return EnchantmentHelper.getItemEnchantmentLevel(infinity, (ItemStack)bow) > 0;
    }

    private Holder<Enchantment> getEnchantmentHolder(Level level, ResourceKey<Enchantment> enchantmentKey) {
        return level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(enchantmentKey);
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        projectile.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot() + angle, 0.0f, velocity, inaccuracy);
    }

    public static float getPowerForTime(int pCharge) {
        float f = (float)pCharge / 16.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 16;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean hasArrows;
        ItemStack bowStack = player.getItemInHand(hand);
        boolean bl = hasArrows = !player.getProjectile(bowStack).isEmpty();
        if (!player.hasInfiniteMaterials() && !hasArrows) {
            return InteractionResultHolder.fail((Object)bowStack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)bowStack);
    }

    public int getDefaultProjectileRange() {
        return 64;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is((Item)ItemRegistry.POWER_CRYSTAL.get());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.wind_bow.tooltip").withStyle(ChatFormatting.AQUA));
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.wind_bow.tooltip.ability").withStyle(ChatFormatting.LIGHT_PURPLE));
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.wind_bow.tooltip.effect").withStyle(ChatFormatting.GRAY));
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.wind_bow.tooltip.legend").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.hold_shift"));
        }
    }
}

