/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.mixin;

import net.bandit.many_bows.registry.EffectRegistry;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"heal(F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventHealing(float amount, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.hasEffect(EffectRegistry.CURSED_FLAME)) {
            ci.cancel();
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void preventExtinguishInWater(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.hasEffect(EffectRegistry.CURSED_FLAME) && (entity.isInWaterOrRain() || entity.isInLava())) {
            entity.setRemainingFireTicks(100);
        }
    }
}

