/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticleInteractionsLogging {
    public static final Logger LOG = LoggerFactory.getLogger((String)"Particle Interactions");
    private static final SystemToast.SystemToastId INTERACTION_DEBUG_LOGS_TOAST = new SystemToast.SystemToastId(3000L);
    private static boolean interactionDebugLogsEnabled = false;
    private static final SystemToast.SystemToastId TEXTURE_DEBUG_LOGS_TOAST = new SystemToast.SystemToastId(3000L);
    private static boolean textureDebugLogsEnabled = false;
    private static final String messagePrefix = "[Particle Interactions]: ";
    private static final String interactionDebugPrefix = "[Particle Interactions Interaction Debug]: ";
    private static final String textureDebugPrefix = "[Particle Interactions Texture Debug]: ";

    public static void info(String message, Object ... args) {
        LOG.info(messagePrefix + message, args);
    }

    public static void interactionDebugInfo(String message, Object ... args) {
        if (interactionDebugLogsEnabled) {
            LOG.info(interactionDebugPrefix + message, args);
        }
    }

    public static void textureDebugInfo(String message, Object ... args) {
        if (textureDebugLogsEnabled) {
            LOG.info(textureDebugPrefix + message, args);
        }
    }

    protected static void toggleDebugLogs(Consumer<Boolean> fieldSetter, Supplier<Boolean> fieldGetter, SystemToast.SystemToastId toastId, String debugLoggingName, String debugPrefix, String enabledTranslationKey, String disabledTranslationKey) {
        if (fieldGetter.get().booleanValue()) {
            fieldSetter.accept(false);
            LOG.info(debugPrefix + debugLoggingName + " disabled");
            SystemToast.addOrUpdate((ToastManager)Minecraft.getInstance().getToastManager(), (SystemToast.SystemToastId)toastId, (Component)Component.literal((String)"Particle Interactions"), (Component)Component.translatable((String)disabledTranslationKey));
            return;
        }
        fieldSetter.accept(true);
        LOG.info(debugPrefix + debugLoggingName + " enabled");
        SystemToast.addOrUpdate((ToastManager)Minecraft.getInstance().getToastManager(), (SystemToast.SystemToastId)toastId, (Component)Component.literal((String)"Particle Interactions"), (Component)Component.translatable((String)enabledTranslationKey));
    }

    public static void toggleInteractionDebugLogging() {
        ParticleInteractionsLogging.toggleDebugLogs(newValue -> {
            interactionDebugLogsEnabled = newValue;
        }, () -> interactionDebugLogsEnabled, INTERACTION_DEBUG_LOGS_TOAST, "Interaction Debug Logging", interactionDebugPrefix, "eg_particle_interactions.toast.debug_logs_enabled", "eg_particle_interactions.toast.debug_logs_disabled");
    }

    public static void toggleTextureDebugLogging() {
        ParticleInteractionsLogging.toggleDebugLogs(newValue -> {
            textureDebugLogsEnabled = newValue;
        }, () -> textureDebugLogsEnabled, TEXTURE_DEBUG_LOGS_TOAST, "Texture Debug Logging", textureDebugPrefix, "eg_particle_interactions.toast.texture_debug_logs_enabled", "eg_particle_interactions.toast.texture_debug_logs_disabled");
    }
}

