/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.config.controller;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import games.enchanted.blockplaceparticles.config.controller.FluidLocationController;
import games.enchanted.blockplaceparticles.config.controller.generic.GenericListControllerElement;
import games.enchanted.blockplaceparticles.registry.RegistryHelpers;
import games.enchanted.blockplaceparticles.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FluidLocationControllerElement
extends GenericListControllerElement<ResourceLocation, FluidLocationController> {
    public FluidLocationControllerElement(FluidLocationController control, YACLScreen screen, Dimension<Integer> dim) {
        super(control, screen, dim);
    }

    public List<ResourceLocation> computeMatchingValues() {
        List<ResourceLocation> resourceLocations = RegistryHelpers.getMatchingLocations(this.inputField, BuiltInRegistries.FLUID).toList();
        ArrayList<ResourceLocation> fluidLocations = new ArrayList<ResourceLocation>();
        this.currentItem = RegistryHelpers.validateFluidLocationWithFallback(this.inputField, null);
        for (ResourceLocation resourceLocation : resourceLocations) {
            Fluid blockFromLocation = RegistryHelpers.getFluidFromLocation(resourceLocation);
            if (blockFromLocation.defaultFluidState().createLegacyBlock().isAir()) continue;
            this.matchingItems.put(resourceLocation, RegistryHelpers.getLocationFromFluid(blockFromLocation));
            fluidLocations.add(resourceLocation);
        }
        return fluidLocations;
    }

    @Override
    protected void renderDropdownEntry(GuiGraphics graphics, Dimension<Integer> entryDimension, ResourceLocation identifier) {
        ResourceLocation item = (ResourceLocation)this.matchingItems.get(identifier);
        if (item == null) {
            return;
        }
        super.renderDropdownEntry(graphics, entryDimension, identifier);
        this.renderItemIcon(graphics, this.getItemToRender(item), (Integer)entryDimension.xLimit() - 2, (Integer)entryDimension.y() + 1);
    }

    @Override
    @Nullable
    public Component getHoverTooltipText() {
        return TextUtil.formatResourceLocationToChatComponent((ResourceLocation)((FluidLocationController)((Object)this.getController())).option().pendingValue());
    }

    @Override
    public Item getItemToRender(ResourceLocation value) {
        return RegistryHelpers.getFluidFromLocation(value).getBucket();
    }

    @Override
    public Component getRenderedValueText() {
        return Component.translatable((String)RegistryHelpers.getFluidFromLocation((ResourceLocation)((FluidLocationController)((Object)this.getController())).option().pendingValue()).defaultFluidState().createLegacyBlock().getBlock().getDescriptionId());
    }
}

