/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.config.controller.generic;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ControllerPopupWidget;
import dev.isxander.yacl3.gui.controllers.dropdown.AbstractDropdownController;
import dev.isxander.yacl3.gui.controllers.dropdown.AbstractDropdownControllerElement;
import games.enchanted.blockplaceparticles.config.controller.generic.FixedDropdownWidget;
import games.enchanted.blockplaceparticles.mixin.accessor.yacl.DropdownWidgetAccessor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class GenericListControllerElement<T, R extends AbstractDropdownController<T>>
extends AbstractDropdownControllerElement<T, T> {
    private static final ResourceLocation MISSING_ITEM_ICON_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"eg_particle_interactions", (String)"missing_item_icon");
    private final R controller;
    protected T currentItem = null;
    protected Map<ResourceLocation, T> matchingItems = new HashMap<ResourceLocation, T>();
    int lastKnownSelectedDropdownIndex = 0;

    public GenericListControllerElement(R control, YACLScreen screen, Dimension<Integer> dim) {
        super(control, screen, dim);
        this.controller = control;
    }

    public R getController() {
        return this.controller;
    }

    protected void renderDropdownEntry(GuiGraphics graphics, Dimension<Integer> entryDimension, T value) {
        super.renderDropdownEntry(graphics, entryDimension, value);
    }

    protected void drawValueText(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Dimension oldDimension = this.getDimension();
        this.setDimension(this.getDimension().withWidth((Number)((Integer)this.getDimension().width() - this.getDecorationPadding())));
        super.drawValueText(graphics, mouseX, mouseY, delta);
        this.setDimension(oldDimension);
        if (this.currentItem != null) {
            this.renderItemIcon(graphics, this.getItemToRender(this.currentItem), (Integer)this.getDimension().xLimit() - this.getXPadding() - this.getDecorationPadding() + 2, (Integer)this.getDimension().y() + 2);
        }
    }

    protected void renderItemIcon(GuiGraphics graphics, Item item, int x, int y) {
        if (item == null) {
            return;
        }
        if (item == Items.AIR) {
            graphics.blitSprite(RenderType::guiTextured, MISSING_ITEM_ICON_SPRITE, x, y, 16, 16);
            return;
        }
        graphics.renderFakeItem(new ItemStack((ItemLike)item), x, y);
    }

    protected void drawHoveredControl(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.drawHoveredControl(graphics, mouseX, mouseY, delta);
        Component text = this.getHoverTooltipText();
        if (text == null) {
            return;
        }
        Dimension dimension = this.getDimension();
        graphics.renderTooltip(Minecraft.getInstance().font, text, ((Integer)dimension.x()).intValue(), ((Integer)dimension.y()).intValue());
    }

    @Nullable
    public Component getHoverTooltipText() {
        return Component.literal((String)this.getController().option().pendingValue().toString());
    }

    public boolean charTyped(char chr, int modifiers) {
        if (this.dropdownWidget != null) {
            ((DropdownWidgetAccessor)this.dropdownWidget).block_place_particle$setFirstVisibleIndex(0);
            this.dropdownWidget.scrollUp();
        }
        return super.charTyped(chr, modifiers);
    }

    public String getString(T val) {
        return val.toString();
    }

    protected int getDecorationPadding() {
        return 16;
    }

    protected int getDropdownEntryPadding() {
        return 4;
    }

    protected int getControlWidth() {
        return super.getControlWidth() + this.getDecorationPadding();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX + (double)this.getDecorationPadding(), mouseY, button);
    }

    public void setLastSelectedDropdownIndex(int index) {
        this.lastKnownSelectedDropdownIndex = index;
    }

    public int getLastSelectedDropdownIndex() {
        return this.lastKnownSelectedDropdownIndex;
    }

    public void createDropdownWidget() {
        this.dropdownVisible = true;
        this.dropdownWidget = new FixedDropdownWidget(this.controller, this.screen, (Dimension<Integer>)this.getDimension(), this);
        this.screen.addPopupControllerWidget((ControllerPopupWidget)this.dropdownWidget);
    }

    protected Component getValueText() {
        if (this.inputField.isEmpty() || this.controller == null) {
            return super.getValueText();
        }
        if (this.inputFieldFocused) {
            return Component.literal((String)this.inputField);
        }
        return this.getRenderedValueText();
    }

    public abstract Item getItemToRender(T var1);

    public abstract Component getRenderedValueText();
}

