/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.mixin.entity;

import games.enchanted.blockplaceparticles.particle_spawning.SpawnParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractMinecart.class})
public abstract class AbstractMinecartMixin
extends VehicleEntity {
    @Shadow
    public abstract boolean isOnRails();

    @Shadow
    @NotNull
    public abstract Direction getMotionDirection();

    @Shadow
    public abstract BlockState getDisplayBlockState();

    public AbstractMinecartMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Unique
    private boolean block_place_particle$shouldSpawnSparks() {
        BlockPos blockPos = BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ());
        BlockState blockState = this.level().getBlockState(blockPos);
        return !blockState.getFluidState().is(FluidTags.WATER);
    }

    @Unique
    private double block_place_particle$maxSpeed() {
        return this.isInWater() ? 0.2 : 0.4;
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    protected void spawnSparksWhileMovingOnRails(CallbackInfo ci) {
        if (this.block_place_particle$shouldSpawnSparks() && this.level().isClientSide) {
            float horizontalRot = this.getYRot();
            float verticalRot = this.getXRot();
            BlockPos blockPos = BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ());
            BlockState blockState = this.level().getBlockState(blockPos);
            boolean hasBlock = !this.getDisplayBlockState().is(BlockTags.AIR);
            SpawnParticles.spawnSparksAtMinecartWheels(this.getX(), this.getY(), this.getZ(), horizontalRot, verticalRot, BaseRailBlock.isRail((BlockState)blockState), !this.getPassengers().isEmpty(), hasBlock, this.getDeltaMovement(), this.block_place_particle$maxSpeed(), this.level());
        }
    }
}

